<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyID StructType
 * Meta information extracted from the WSDL
 * - documentation: Partner identification | Identifikace partnera
 * @subpackage Structs
 */
class PartyID extends AbstractStructBase
{
    /**
     * The ident_num
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $ident_num;
    /**
     * The tax_num
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $tax_num;
    /**
     * The comp_register
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 160
     * - minLength: 0
     * @var string
     */
    public $comp_register;
    /**
     * Constructor method for PartyID
     * @uses PartyID::setIdent_num()
     * @uses PartyID::setTax_num()
     * @uses PartyID::setComp_register()
     * @param string $ident_num
     * @param string $tax_num
     * @param string $comp_register
     */
    public function __construct($ident_num = null, $tax_num = null, $comp_register = null)
    {
        $this
            ->setIdent_num($ident_num)
            ->setTax_num($tax_num)
            ->setComp_register($comp_register);
    }
    /**
     * Get ident_num value
     * @return string|null
     */
    public function getIdent_num()
    {
        return $this->{'ident-num'};
    }
    /**
     * Set ident_num value
     * @param string $ident_num
     * @return \StructType\PartyID
     */
    public function setIdent_num($ident_num = null)
    {
        // validation for constraint: string
        if (!is_null($ident_num) && !is_string($ident_num)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ident_num, true), gettype($ident_num)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ident_num) && mb_strlen($ident_num) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($ident_num)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ident_num) && mb_strlen($ident_num) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ident_num)), __LINE__);
        }
        $this->ident_num = $this->{'ident-num'} = $ident_num;
        return $this;
    }
    /**
     * Get tax_num value
     * @return string|null
     */
    public function getTax_num()
    {
        return $this->{'tax-num'};
    }
    /**
     * Set tax_num value
     * @param string $tax_num
     * @return \StructType\PartyID
     */
    public function setTax_num($tax_num = null)
    {
        // validation for constraint: string
        if (!is_null($tax_num) && !is_string($tax_num)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax_num, true), gettype($tax_num)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($tax_num) && mb_strlen($tax_num) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($tax_num)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($tax_num) && mb_strlen($tax_num) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($tax_num)), __LINE__);
        }
        $this->tax_num = $this->{'tax-num'} = $tax_num;
        return $this;
    }
    /**
     * Get comp_register value
     * @return string|null
     */
    public function getComp_register()
    {
        return $this->{'comp-register'};
    }
    /**
     * Set comp_register value
     * @param string $comp_register
     * @return \StructType\PartyID
     */
    public function setComp_register($comp_register = null)
    {
        // validation for constraint: string
        if (!is_null($comp_register) && !is_string($comp_register)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comp_register, true), gettype($comp_register)), __LINE__);
        }
        // validation for constraint: maxLength(160)
        if (!is_null($comp_register) && mb_strlen($comp_register) > 160) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 160', mb_strlen($comp_register)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($comp_register) && mb_strlen($comp_register) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($comp_register)), __LINE__);
        }
        $this->comp_register = $this->{'comp-register'} = $comp_register;
        return $this;
    }
}
