<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MASTERDATA StructType
 * Meta information extracted from the WSDL
 * - documentation: Following part of xml document contains either information about change of supplier or about PDT | Další část xml dokumentu obsahuje buď informace o změně dodavatele nebo o OPM | Root element containing basic message data |
 * Rootovský element obsahující základní údaje o zprávě
 * @subpackage Structs
 */
class MASTERDATA extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Unique message identification | Jednoznačný identifikátor zprávy | Typ pro číslo zprávy | Message number type
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The message_code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $message_code;
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Date and time of message | Datum a čas zprávy
     * - use: required
     * @var string
     */
    public $date_time;
    /**
     * The dtd_version
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions. So far a constant '1' | Rezervováno pro pozdější verze. Nyní konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_version;
    /**
     * The dtd_release
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions. So far a constant '1' | Rezervováno pro pozdější verze. Nyní konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_release;
    /**
     * The answer_required
     * Meta information extracted from the WSDL
     * - documentation: Indication of request for response | Indikace požadavku na odpověď
     * - use: required
     * @var bool
     */
    public $answer_required;
    /**
     * The SenderIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message sender identification | Identifikace odesílatele zprávy
     * @var \StructType\SenderIdentificationType
     */
    public $SenderIdentification;
    /**
     * The ReceiverIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message receiver identification | Identifikace příjemce zprávy
     * @var \StructType\ReceiverIdentificationType
     */
    public $ReceiverIdentification;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the previous message | Reference na předešlou zprávu
     * - minOccurs: 0
     * @var \StructType\ReferenceType
     */
    public $Reference;
    /**
     * The OPM
     * Meta information extracted from the WSDL
     * - choice: OPM | Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\OPM[]
     */
    public $OPM;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - choice: OPM | Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType
     */
    public $Signature;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - documentation: Message language | Jazyk zprávy
     * - use: optional
     * @var string
     */
    public $language;
    /**
     * The split_counter
     * Meta information extracted from the WSDL
     * - documentation: Message order within response | Pořadí zprávy v rámci odpovědi
     * - use: optional
     * @var int
     */
    public $split_counter;
    /**
     * The split_last
     * Meta information extracted from the WSDL
     * - documentation: Last message | Poslední zpráva
     * - use: optional
     * @var bool
     */
    public $split_last;
    /**
     * Constructor method for MASTERDATA
     * @uses MASTERDATA::setId()
     * @uses MASTERDATA::setMessage_code()
     * @uses MASTERDATA::setDate_time()
     * @uses MASTERDATA::setDtd_version()
     * @uses MASTERDATA::setDtd_release()
     * @uses MASTERDATA::setAnswer_required()
     * @uses MASTERDATA::setSenderIdentification()
     * @uses MASTERDATA::setReceiverIdentification()
     * @uses MASTERDATA::setReference()
     * @uses MASTERDATA::setOPM()
     * @uses MASTERDATA::setData()
     * @uses MASTERDATA::setSignature()
     * @uses MASTERDATA::setLanguage()
     * @uses MASTERDATA::setSplit_counter()
     * @uses MASTERDATA::setSplit_last()
     * @param string $id
     * @param string $message_code
     * @param string $date_time
     * @param string $dtd_version
     * @param string $dtd_release
     * @param bool $answer_required
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @param \StructType\ReferenceType $reference
     * @param \StructType\OPM[] $oPM
     * @param \StructType\Data[] $data
     * @param \StructType\SignatureType $signature
     * @param string $language
     * @param int $split_counter
     * @param bool $split_last
     */
    public function __construct($id = null, $message_code = null, $date_time = null, $dtd_version = null, $dtd_release = null, $answer_required = null, \StructType\SenderIdentificationType $senderIdentification = null, \StructType\ReceiverIdentificationType $receiverIdentification = null, \StructType\ReferenceType $reference = null, array $oPM = array(), array $data = array(), \StructType\SignatureType $signature = null, $language = null, $split_counter = null, $split_last = null)
    {
        $this
            ->setId($id)
            ->setMessage_code($message_code)
            ->setDate_time($date_time)
            ->setDtd_version($dtd_version)
            ->setDtd_release($dtd_release)
            ->setAnswer_required($answer_required)
            ->setSenderIdentification($senderIdentification)
            ->setReceiverIdentification($receiverIdentification)
            ->setReference($reference)
            ->setOPM($oPM)
            ->setData($data)
            ->setSignature($signature)
            ->setLanguage($language)
            ->setSplit_counter($split_counter)
            ->setSplit_last($split_last);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\MASTERDATA
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($id) && mb_strlen($id) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get message_code value
     * @return string
     */
    public function getMessage_code()
    {
        return $this->{'message-code'};
    }
    /**
     * Set message_code value
     * @param string $message_code
     * @return \StructType\MASTERDATA
     */
    public function setMessage_code($message_code = null)
    {
        // validation for constraint: string
        if (!is_null($message_code) && !is_string($message_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message_code, true), gettype($message_code)), __LINE__);
        }
        $this->message_code = $this->{'message-code'} = $message_code;
        return $this;
    }
    /**
     * Get date_time value
     * @return string
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\MASTERDATA
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
    /**
     * Get dtd_version value
     * @return string
     */
    public function getDtd_version()
    {
        return $this->{'dtd-version'};
    }
    /**
     * Set dtd_version value
     * @param string $dtd_version
     * @return \StructType\MASTERDATA
     */
    public function setDtd_version($dtd_version = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_version) && !is_string($dtd_version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_version, true), gettype($dtd_version)), __LINE__);
        }
        $this->dtd_version = $this->{'dtd-version'} = $dtd_version;
        return $this;
    }
    /**
     * Get dtd_release value
     * @return string
     */
    public function getDtd_release()
    {
        return $this->{'dtd-release'};
    }
    /**
     * Set dtd_release value
     * @param string $dtd_release
     * @return \StructType\MASTERDATA
     */
    public function setDtd_release($dtd_release = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_release) && !is_string($dtd_release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_release, true), gettype($dtd_release)), __LINE__);
        }
        $this->dtd_release = $this->{'dtd-release'} = $dtd_release;
        return $this;
    }
    /**
     * Get answer_required value
     * @return bool
     */
    public function getAnswer_required()
    {
        return $this->{'answer-required'};
    }
    /**
     * Set answer_required value
     * @param bool $answer_required
     * @return \StructType\MASTERDATA
     */
    public function setAnswer_required($answer_required = null)
    {
        // validation for constraint: boolean
        if (!is_null($answer_required) && !is_bool($answer_required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($answer_required, true), gettype($answer_required)), __LINE__);
        }
        $this->answer_required = $this->{'answer-required'} = $answer_required;
        return $this;
    }
    /**
     * Get SenderIdentification value
     * @return \StructType\SenderIdentificationType|null
     */
    public function getSenderIdentification()
    {
        return $this->SenderIdentification;
    }
    /**
     * Set SenderIdentification value
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @return \StructType\MASTERDATA
     */
    public function setSenderIdentification(\StructType\SenderIdentificationType $senderIdentification = null)
    {
        $this->SenderIdentification = $senderIdentification;
        return $this;
    }
    /**
     * Get ReceiverIdentification value
     * @return \StructType\ReceiverIdentificationType|null
     */
    public function getReceiverIdentification()
    {
        return $this->ReceiverIdentification;
    }
    /**
     * Set ReceiverIdentification value
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @return \StructType\MASTERDATA
     */
    public function setReceiverIdentification(\StructType\ReceiverIdentificationType $receiverIdentification = null)
    {
        $this->ReceiverIdentification = $receiverIdentification;
        return $this;
    }
    /**
     * Get Reference value
     * @return \StructType\ReferenceType|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \StructType\ReferenceType $reference
     * @return \StructType\MASTERDATA
     */
    public function setReference(\StructType\ReferenceType $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get OPM value
     * @return \StructType\OPM[]|null
     */
    public function getOPM()
    {
        return isset($this->OPM) ? $this->OPM : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOPM method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOPM method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOPMForArrayConstraintsFromSetOPM(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mASTERDATAOPMItem) {
            // validation for constraint: itemType
            if (!$mASTERDATAOPMItem instanceof \StructType\OPM) {
                $invalidValues[] = is_object($mASTERDATAOPMItem) ? get_class($mASTERDATAOPMItem) : sprintf('%s(%s)', gettype($mASTERDATAOPMItem), var_export($mASTERDATAOPMItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OPM property can only contain items of type \StructType\OPM, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setOPM method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOPM method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOPMForChoiceConstraintsFromSetOPM($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OPM can\'t be set as the property %s is already set. Only one property must be set among these properties: OPM, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OPM value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\OPM[] $oPM
     * @return \StructType\MASTERDATA
     */
    public function setOPM(array $oPM = array())
    {
        // validation for constraint: array
        if ('' !== ($oPMArrayErrorMessage = self::validateOPMForArrayConstraintsFromSetOPM($oPM))) {
            throw new \InvalidArgumentException($oPMArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OPM, Data)
        if ('' !== ($oPMChoiceErrorMessage = self::validateOPMForChoiceConstraintsFromSetOPM($oPM))) {
            throw new \InvalidArgumentException($oPMChoiceErrorMessage, __LINE__);
        }
        if (is_null($oPM) || (is_array($oPM) && empty($oPM))) {
            unset($this->OPM);
        } else {
            $this->OPM = $oPM;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToOPM method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToOPM method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToOPM($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OPM can\'t be set as the property %s is already set. Only one property must be set among these properties: OPM, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to OPM value
     * @throws \InvalidArgumentException
     * @param \StructType\OPM $item
     * @return \StructType\MASTERDATA
     */
    public function addToOPM(\StructType\OPM $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OPM) {
            throw new \InvalidArgumentException(sprintf('The OPM property can only contain items of type \StructType\OPM, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OPM, Data)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToOPM($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->OPM[] = $item;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return isset($this->Data) ? $this->Data : null;
    }
    /**
     * This method is responsible for validating the values passed to the setData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDataForArrayConstraintsFromSetData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mASTERDATADataItem) {
            // validation for constraint: itemType
            if (!$mASTERDATADataItem instanceof \StructType\Data) {
                $invalidValues[] = is_object($mASTERDATADataItem) ? get_class($mASTERDATADataItem) : sprintf('%s(%s)', gettype($mASTERDATADataItem), var_export($mASTERDATADataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Data property can only contain items of type \StructType\Data, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDataForChoiceConstraintsFromSetData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OPM',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\MASTERDATA
     */
    public function setData(array $data = array())
    {
        // validation for constraint: array
        if ('' !== ($dataArrayErrorMessage = self::validateDataForArrayConstraintsFromSetData($data))) {
            throw new \InvalidArgumentException($dataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(OPM, Data)
        if ('' !== ($dataChoiceErrorMessage = self::validateDataForChoiceConstraintsFromSetData($data))) {
            throw new \InvalidArgumentException($dataChoiceErrorMessage, __LINE__);
        }
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->Data);
        } else {
            $this->Data = $data;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToData method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OPM',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\MASTERDATA
     */
    public function addToData(\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of type \StructType\Data, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(OPM, Data)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToData($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \StructType\SignatureType $signature
     * @return \StructType\MASTERDATA
     */
    public function setSignature(\StructType\SignatureType $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\MASTERDATA
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get split_counter value
     * @return int|null
     */
    public function getSplit_counter()
    {
        return $this->{'split-counter'};
    }
    /**
     * Set split_counter value
     * @param int $split_counter
     * @return \StructType\MASTERDATA
     */
    public function setSplit_counter($split_counter = null)
    {
        // validation for constraint: int
        if (!is_null($split_counter) && !(is_int($split_counter) || ctype_digit($split_counter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($split_counter, true), gettype($split_counter)), __LINE__);
        }
        $this->split_counter = $this->{'split-counter'} = $split_counter;
        return $this;
    }
    /**
     * Get split_last value
     * @return bool|null
     */
    public function getSplit_last()
    {
        return $this->{'split-last'};
    }
    /**
     * Set split_last value
     * @param bool $split_last
     * @return \StructType\MASTERDATA
     */
    public function setSplit_last($split_last = null)
    {
        // validation for constraint: boolean
        if (!is_null($split_last) && !is_bool($split_last)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($split_last, true), gettype($split_last)), __LINE__);
        }
        $this->split_last = $this->{'split-last'} = $split_last;
        return $this;
    }
}
