<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location StructType
 * Meta information extracted from the WSDL
 * - documentation: PDT and interval identification | Identifikace OPM a intervalu | Locality | Lokalita
 * @subpackage Structs
 */
class Location extends AbstractStructBase
{
    /**
     * The profile_role
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $profile_role;
    /**
     * The date_time_from
     * Meta information extracted from the WSDL
     * - documentation: Start of period, which are the data requested for. | Počátek období, pro které jsou požadována data
     * - use: required
     * @var string
     */
    public $date_time_from;
    /**
     * The date_time_to
     * Meta information extracted from the WSDL
     * - documentation: End of period, which are the data requested for. | Konec období, pro které jsou požadována data
     * - use: required
     * @var string
     */
    public $date_time_to;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: EAN18 - Locality (PDT) identification | EAN18 identifikující lokalitu (OPM) | Typ pro EAN 13 - 18 znaků | EAN 13 - 18 type
     * - base: xsd:string
     * - pattern: \d{13}(\d{5})?
     * - use: optional
     * @var string
     */
    public $id;
    /**
     * The profile_version
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $profile_version;
    /**
     * The mr_qual
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $mr_qual;
    /**
     * The default_diag
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $default_diag;
    /**
     * The value_type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $value_type;
    /**
     * The version_date_time
     * Meta information extracted from the WSDL
     * - documentation: Value calculation timestamp | Časová značku výpočtu hodnoty
     * @var string
     */
    public $version_date_time;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $version;
    /**
     * The grid_id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4
     * - use: optional
     * @var string
     */
    public $grid_id;
    /**
     * The typm
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $typm;
    /**
     * The temp_area
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - use: optional
     * @var string
     */
    public $temp_area;
    /**
     * The tdd_class
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - use: optional
     * @var string
     */
    public $tdd_class;
    /**
     * The anlart
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $anlart;
    /**
     * The typsrc
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $typsrc;
    /**
     * The spebene
     * Meta information extracted from the WSDL
     * - documentation: Voltage level 1 | Napěťová úroveň 1
     * - use: optional
     * @var string
     */
    public $spebene;
    /**
     * The inv_sender
     * Meta information extracted from the WSDL
     * - documentation: Electronic invoice sender | Odesílatel elektronické faktury | EAN type | Typ pro EAN | Typ pro EAN 13 znaků | EAN 13 type
     * - base: ean
     * - length: 13
     * - pattern: \d+
     * @var string
     */
    public $inv_sender;
    /**
     * The inv_type
     * Meta information extracted from the WSDL
     * - documentation: Electronic invoice document type | Typ dokladu elektronické faktury
     * @var string
     */
    public $inv_type;
    /**
     * The inv_doc_id
     * Meta information extracted from the WSDL
     * - documentation: Electronic invoice document id | Id dokladu elektronické faktury
     * @var string
     */
    public $inv_doc_id;
    /**
     * The claim_method
     * @var string
     */
    public $claim_method;
    /**
     * The claim_id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $claim_id;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The version_date_time_from
     * Meta information extracted from the WSDL
     * - documentation: Počátek období, kdy byl výpočet hodnot proveden
     * - use: optional
     * @var string
     */
    public $version_date_time_from;
    /**
     * The version_date_time_to
     * Meta information extracted from the WSDL
     * - documentation: Konec období, kdy byl výpočet hodnot proveden
     * - use: optional
     * @var string
     */
    public $version_date_time_to;
    /**
     * The chs_status
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $chs_status;
    /**
     * The import_date_time_from
     * Meta information extracted from the WSDL
     * - documentation: Date and time of sending request from (for change of supplier extract request) | Datum a čas zaslání požadavku od (pro výpis změny dodavatele)
     * - use: optional
     * @var string
     */
    public $import_date_time_from;
    /**
     * The import_date_time_to
     * Meta information extracted from the WSDL
     * - documentation: Date and time of sending request to (for change of supplier extract request) | Datum a čas zaslání požadavku do (pro výpis změny dodavatele)
     * - use: optional
     * @var string
     */
    public $import_date_time_to;
    /**
     * The rut_identification
     * Meta information extracted from the WSDL
     * - documentation: Service provider (EAN) | Poskytovatel služby (EAN) | Typ pro pseudo-EIC kód | EIC code type
     * - base: xsd:string
     * - maxLength: 16
     * - minLength: 13
     * - pattern: \c{16}
     * - use: optional
     * @var string
     */
    public $rut_identification;
    /**
     * The rut_service
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $rut_service;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $service;
    /**
     * The syst_serv_status
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $syst_serv_status;
    /**
     * The chs_type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $chs_type;
    /**
     * The chs_reason
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $chs_reason;
    /**
     * Constructor method for Location
     * @uses Location::setProfile_role()
     * @uses Location::setDate_time_from()
     * @uses Location::setDate_time_to()
     * @uses Location::setData()
     * @uses Location::setId()
     * @uses Location::setProfile_version()
     * @uses Location::setMr_qual()
     * @uses Location::setDefault_diag()
     * @uses Location::setValue_type()
     * @uses Location::setVersion_date_time()
     * @uses Location::setVersion()
     * @uses Location::setGrid_id()
     * @uses Location::setTypm()
     * @uses Location::setTemp_area()
     * @uses Location::setTdd_class()
     * @uses Location::setAnlart()
     * @uses Location::setTypsrc()
     * @uses Location::setSpebene()
     * @uses Location::setInv_sender()
     * @uses Location::setInv_type()
     * @uses Location::setInv_doc_id()
     * @uses Location::setClaim_method()
     * @uses Location::setClaim_id()
     * @uses Location::setStatus()
     * @uses Location::setVersion_date_time_from()
     * @uses Location::setVersion_date_time_to()
     * @uses Location::setChs_status()
     * @uses Location::setImport_date_time_from()
     * @uses Location::setImport_date_time_to()
     * @uses Location::setRut_identification()
     * @uses Location::setRut_service()
     * @uses Location::setService()
     * @uses Location::setSyst_serv_status()
     * @uses Location::setChs_type()
     * @uses Location::setChs_reason()
     * @param string $profile_role
     * @param string $date_time_from
     * @param string $date_time_to
     * @param \StructType\Data[] $data
     * @param string $id
     * @param string $profile_version
     * @param string $mr_qual
     * @param string $default_diag
     * @param string $value_type
     * @param string $version_date_time
     * @param string $version
     * @param string $grid_id
     * @param string $typm
     * @param string $temp_area
     * @param string $tdd_class
     * @param string $anlart
     * @param string $typsrc
     * @param string $spebene
     * @param string $inv_sender
     * @param string $inv_type
     * @param string $inv_doc_id
     * @param string $claim_method
     * @param string $claim_id
     * @param string $status
     * @param string $version_date_time_from
     * @param string $version_date_time_to
     * @param string $chs_status
     * @param string $import_date_time_from
     * @param string $import_date_time_to
     * @param string $rut_identification
     * @param string $rut_service
     * @param string $service
     * @param string $syst_serv_status
     * @param string $chs_type
     * @param string $chs_reason
     */
    public function __construct($profile_role = null, $date_time_from = null, $date_time_to = null, array $data = array(), $id = null, $profile_version = null, $mr_qual = null, $default_diag = null, $value_type = null, $version_date_time = null, $version = null, $grid_id = null, $typm = null, $temp_area = null, $tdd_class = null, $anlart = null, $typsrc = null, $spebene = null, $inv_sender = null, $inv_type = null, $inv_doc_id = null, $claim_method = null, $claim_id = null, $status = null, $version_date_time_from = null, $version_date_time_to = null, $chs_status = null, $import_date_time_from = null, $import_date_time_to = null, $rut_identification = null, $rut_service = null, $service = null, $syst_serv_status = null, $chs_type = null, $chs_reason = null)
    {
        $this
            ->setProfile_role($profile_role)
            ->setDate_time_from($date_time_from)
            ->setDate_time_to($date_time_to)
            ->setData($data)
            ->setId($id)
            ->setProfile_version($profile_version)
            ->setMr_qual($mr_qual)
            ->setDefault_diag($default_diag)
            ->setValue_type($value_type)
            ->setVersion_date_time($version_date_time)
            ->setVersion($version)
            ->setGrid_id($grid_id)
            ->setTypm($typm)
            ->setTemp_area($temp_area)
            ->setTdd_class($tdd_class)
            ->setAnlart($anlart)
            ->setTypsrc($typsrc)
            ->setSpebene($spebene)
            ->setInv_sender($inv_sender)
            ->setInv_type($inv_type)
            ->setInv_doc_id($inv_doc_id)
            ->setClaim_method($claim_method)
            ->setClaim_id($claim_id)
            ->setStatus($status)
            ->setVersion_date_time_from($version_date_time_from)
            ->setVersion_date_time_to($version_date_time_to)
            ->setChs_status($chs_status)
            ->setImport_date_time_from($import_date_time_from)
            ->setImport_date_time_to($import_date_time_to)
            ->setRut_identification($rut_identification)
            ->setRut_service($rut_service)
            ->setService($service)
            ->setSyst_serv_status($syst_serv_status)
            ->setChs_type($chs_type)
            ->setChs_reason($chs_reason);
    }
    /**
     * Get profile_role value
     * @return string
     */
    public function getProfile_role()
    {
        return $this->{'profile-role'};
    }
    /**
     * Set profile_role value
     * @param string $profile_role
     * @return \StructType\Location
     */
    public function setProfile_role($profile_role = null)
    {
        // validation for constraint: string
        if (!is_null($profile_role) && !is_string($profile_role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profile_role, true), gettype($profile_role)), __LINE__);
        }
        $this->profile_role = $this->{'profile-role'} = $profile_role;
        return $this;
    }
    /**
     * Get date_time_from value
     * @return string
     */
    public function getDate_time_from()
    {
        return $this->{'date-time-from'};
    }
    /**
     * Set date_time_from value
     * @param string $date_time_from
     * @return \StructType\Location
     */
    public function setDate_time_from($date_time_from = null)
    {
        // validation for constraint: string
        if (!is_null($date_time_from) && !is_string($date_time_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time_from, true), gettype($date_time_from)), __LINE__);
        }
        $this->date_time_from = $this->{'date-time-from'} = $date_time_from;
        return $this;
    }
    /**
     * Get date_time_to value
     * @return string
     */
    public function getDate_time_to()
    {
        return $this->{'date-time-to'};
    }
    /**
     * Set date_time_to value
     * @param string $date_time_to
     * @return \StructType\Location
     */
    public function setDate_time_to($date_time_to = null)
    {
        // validation for constraint: string
        if (!is_null($date_time_to) && !is_string($date_time_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time_to, true), gettype($date_time_to)), __LINE__);
        }
        $this->date_time_to = $this->{'date-time-to'} = $date_time_to;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * This method is responsible for validating the values passed to the setData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDataForArrayConstraintsFromSetData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationDataItem) {
            // validation for constraint: itemType
            if (!$locationDataItem instanceof \StructType\Data) {
                $invalidValues[] = is_object($locationDataItem) ? get_class($locationDataItem) : sprintf('%s(%s)', gettype($locationDataItem), var_export($locationDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Data property can only contain items of type \StructType\Data, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\Location
     */
    public function setData(array $data = array())
    {
        // validation for constraint: array
        if ('' !== ($dataArrayErrorMessage = self::validateDataForArrayConstraintsFromSetData($data))) {
            throw new \InvalidArgumentException($dataArrayErrorMessage, __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\Location
     */
    public function addToData(\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of type \StructType\Data, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Location
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern(\d{13}(\d{5})?)
        if (!is_null($id) && !preg_match('/\\d{13}(\\d{5})?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{13}(\d{5})?', var_export($id, true)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get profile_version value
     * @return string|null
     */
    public function getProfile_version()
    {
        return $this->{'profile-version'};
    }
    /**
     * Set profile_version value
     * @param string $profile_version
     * @return \StructType\Location
     */
    public function setProfile_version($profile_version = null)
    {
        // validation for constraint: string
        if (!is_null($profile_version) && !is_string($profile_version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profile_version, true), gettype($profile_version)), __LINE__);
        }
        $this->profile_version = $this->{'profile-version'} = $profile_version;
        return $this;
    }
    /**
     * Get mr_qual value
     * @return string|null
     */
    public function getMr_qual()
    {
        return $this->{'mr-qual'};
    }
    /**
     * Set mr_qual value
     * @param string $mr_qual
     * @return \StructType\Location
     */
    public function setMr_qual($mr_qual = null)
    {
        // validation for constraint: string
        if (!is_null($mr_qual) && !is_string($mr_qual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mr_qual, true), gettype($mr_qual)), __LINE__);
        }
        $this->mr_qual = $this->{'mr-qual'} = $mr_qual;
        return $this;
    }
    /**
     * Get default_diag value
     * @return string|null
     */
    public function getDefault_diag()
    {
        return $this->{'default-diag'};
    }
    /**
     * Set default_diag value
     * @param string $default_diag
     * @return \StructType\Location
     */
    public function setDefault_diag($default_diag = null)
    {
        // validation for constraint: string
        if (!is_null($default_diag) && !is_string($default_diag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($default_diag, true), gettype($default_diag)), __LINE__);
        }
        $this->default_diag = $this->{'default-diag'} = $default_diag;
        return $this;
    }
    /**
     * Get value_type value
     * @return string|null
     */
    public function getValue_type()
    {
        return $this->{'value-type'};
    }
    /**
     * Set value_type value
     * @param string $value_type
     * @return \StructType\Location
     */
    public function setValue_type($value_type = null)
    {
        // validation for constraint: string
        if (!is_null($value_type) && !is_string($value_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value_type, true), gettype($value_type)), __LINE__);
        }
        $this->value_type = $this->{'value-type'} = $value_type;
        return $this;
    }
    /**
     * Get version_date_time value
     * @return string|null
     */
    public function getVersion_date_time()
    {
        return $this->{'version-date-time'};
    }
    /**
     * Set version_date_time value
     * @param string $version_date_time
     * @return \StructType\Location
     */
    public function setVersion_date_time($version_date_time = null)
    {
        // validation for constraint: string
        if (!is_null($version_date_time) && !is_string($version_date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version_date_time, true), gettype($version_date_time)), __LINE__);
        }
        $this->version_date_time = $this->{'version-date-time'} = $version_date_time;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Location
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get grid_id value
     * @return string|null
     */
    public function getGrid_id()
    {
        return $this->{'grid-id'};
    }
    /**
     * Set grid_id value
     * @param string $grid_id
     * @return \StructType\Location
     */
    public function setGrid_id($grid_id = null)
    {
        // validation for constraint: string
        if (!is_null($grid_id) && !is_string($grid_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grid_id, true), gettype($grid_id)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($grid_id) && mb_strlen($grid_id) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($grid_id)), __LINE__);
        }
        $this->grid_id = $this->{'grid-id'} = $grid_id;
        return $this;
    }
    /**
     * Get typm value
     * @return string|null
     */
    public function getTypm()
    {
        return $this->typm;
    }
    /**
     * Set typm value
     * @param string $typm
     * @return \StructType\Location
     */
    public function setTypm($typm = null)
    {
        // validation for constraint: string
        if (!is_null($typm) && !is_string($typm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typm, true), gettype($typm)), __LINE__);
        }
        $this->typm = $typm;
        return $this;
    }
    /**
     * Get temp_area value
     * @return string|null
     */
    public function getTemp_area()
    {
        return $this->{'temp-area'};
    }
    /**
     * Set temp_area value
     * @param string $temp_area
     * @return \StructType\Location
     */
    public function setTemp_area($temp_area = null)
    {
        // validation for constraint: string
        if (!is_null($temp_area) && !is_string($temp_area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temp_area, true), gettype($temp_area)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($temp_area) && mb_strlen($temp_area) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($temp_area)), __LINE__);
        }
        $this->temp_area = $this->{'temp-area'} = $temp_area;
        return $this;
    }
    /**
     * Get tdd_class value
     * @return string|null
     */
    public function getTdd_class()
    {
        return $this->{'tdd-class'};
    }
    /**
     * Set tdd_class value
     * @param string $tdd_class
     * @return \StructType\Location
     */
    public function setTdd_class($tdd_class = null)
    {
        // validation for constraint: string
        if (!is_null($tdd_class) && !is_string($tdd_class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tdd_class, true), gettype($tdd_class)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($tdd_class) && mb_strlen($tdd_class) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($tdd_class)), __LINE__);
        }
        $this->tdd_class = $this->{'tdd-class'} = $tdd_class;
        return $this;
    }
    /**
     * Get anlart value
     * @return string|null
     */
    public function getAnlart()
    {
        return $this->anlart;
    }
    /**
     * Set anlart value
     * @param string $anlart
     * @return \StructType\Location
     */
    public function setAnlart($anlart = null)
    {
        // validation for constraint: string
        if (!is_null($anlart) && !is_string($anlart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anlart, true), gettype($anlart)), __LINE__);
        }
        $this->anlart = $anlart;
        return $this;
    }
    /**
     * Get typsrc value
     * @return string|null
     */
    public function getTypsrc()
    {
        return $this->typsrc;
    }
    /**
     * Set typsrc value
     * @param string $typsrc
     * @return \StructType\Location
     */
    public function setTypsrc($typsrc = null)
    {
        // validation for constraint: string
        if (!is_null($typsrc) && !is_string($typsrc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typsrc, true), gettype($typsrc)), __LINE__);
        }
        $this->typsrc = $typsrc;
        return $this;
    }
    /**
     * Get spebene value
     * @return string|null
     */
    public function getSpebene()
    {
        return $this->spebene;
    }
    /**
     * Set spebene value
     * @uses \EnumType\Voltage_level::valueIsValid()
     * @uses \EnumType\Voltage_level::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $spebene
     * @return \StructType\Location
     */
    public function setSpebene($spebene = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Voltage_level::valueIsValid($spebene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Voltage_level', is_array($spebene) ? implode(', ', $spebene) : var_export($spebene, true), implode(', ', \EnumType\Voltage_level::getValidValues())), __LINE__);
        }
        $this->spebene = $spebene;
        return $this;
    }
    /**
     * Get inv_sender value
     * @return string|null
     */
    public function getInv_sender()
    {
        return $this->{'inv-sender'};
    }
    /**
     * Set inv_sender value
     * @param string $inv_sender
     * @return \StructType\Location
     */
    public function setInv_sender($inv_sender = null)
    {
        // validation for constraint: string
        if (!is_null($inv_sender) && !is_string($inv_sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_sender, true), gettype($inv_sender)), __LINE__);
        }
        // validation for constraint: length(13)
        if (!is_null($inv_sender) && mb_strlen($inv_sender) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 13', mb_strlen($inv_sender)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($inv_sender) && !preg_match('/\\d+/', $inv_sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($inv_sender, true)), __LINE__);
        }
        $this->inv_sender = $this->{'inv-sender'} = $inv_sender;
        return $this;
    }
    /**
     * Get inv_type value
     * @return string|null
     */
    public function getInv_type()
    {
        return $this->{'inv-type'};
    }
    /**
     * Set inv_type value
     * @param string $inv_type
     * @return \StructType\Location
     */
    public function setInv_type($inv_type = null)
    {
        // validation for constraint: string
        if (!is_null($inv_type) && !is_string($inv_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_type, true), gettype($inv_type)), __LINE__);
        }
        $this->inv_type = $this->{'inv-type'} = $inv_type;
        return $this;
    }
    /**
     * Get inv_doc_id value
     * @return string|null
     */
    public function getInv_doc_id()
    {
        return $this->{'inv-doc-id'};
    }
    /**
     * Set inv_doc_id value
     * @param string $inv_doc_id
     * @return \StructType\Location
     */
    public function setInv_doc_id($inv_doc_id = null)
    {
        // validation for constraint: string
        if (!is_null($inv_doc_id) && !is_string($inv_doc_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_doc_id, true), gettype($inv_doc_id)), __LINE__);
        }
        $this->inv_doc_id = $this->{'inv-doc-id'} = $inv_doc_id;
        return $this;
    }
    /**
     * Get claim_method value
     * @return string|null
     */
    public function getClaim_method()
    {
        return $this->{'claim-method'};
    }
    /**
     * Set claim_method value
     * @param string $claim_method
     * @return \StructType\Location
     */
    public function setClaim_method($claim_method = null)
    {
        // validation for constraint: string
        if (!is_null($claim_method) && !is_string($claim_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claim_method, true), gettype($claim_method)), __LINE__);
        }
        $this->claim_method = $this->{'claim-method'} = $claim_method;
        return $this;
    }
    /**
     * Get claim_id value
     * @return string|null
     */
    public function getClaim_id()
    {
        return $this->{'claim-id'};
    }
    /**
     * Set claim_id value
     * @param string $claim_id
     * @return \StructType\Location
     */
    public function setClaim_id($claim_id = null)
    {
        // validation for constraint: string
        if (!is_null($claim_id) && !is_string($claim_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claim_id, true), gettype($claim_id)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($claim_id) && mb_strlen($claim_id) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($claim_id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($claim_id) && mb_strlen($claim_id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($claim_id)), __LINE__);
        }
        $this->claim_id = $this->{'claim-id'} = $claim_id;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Location
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get version_date_time_from value
     * @return string|null
     */
    public function getVersion_date_time_from()
    {
        return $this->{'version-date-time-from'};
    }
    /**
     * Set version_date_time_from value
     * @param string $version_date_time_from
     * @return \StructType\Location
     */
    public function setVersion_date_time_from($version_date_time_from = null)
    {
        // validation for constraint: string
        if (!is_null($version_date_time_from) && !is_string($version_date_time_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version_date_time_from, true), gettype($version_date_time_from)), __LINE__);
        }
        $this->version_date_time_from = $this->{'version-date-time-from'} = $version_date_time_from;
        return $this;
    }
    /**
     * Get version_date_time_to value
     * @return string|null
     */
    public function getVersion_date_time_to()
    {
        return $this->{'version-date-time-to'};
    }
    /**
     * Set version_date_time_to value
     * @param string $version_date_time_to
     * @return \StructType\Location
     */
    public function setVersion_date_time_to($version_date_time_to = null)
    {
        // validation for constraint: string
        if (!is_null($version_date_time_to) && !is_string($version_date_time_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version_date_time_to, true), gettype($version_date_time_to)), __LINE__);
        }
        $this->version_date_time_to = $this->{'version-date-time-to'} = $version_date_time_to;
        return $this;
    }
    /**
     * Get chs_status value
     * @return string|null
     */
    public function getChs_status()
    {
        return $this->{'chs-status'};
    }
    /**
     * Set chs_status value
     * @param string $chs_status
     * @return \StructType\Location
     */
    public function setChs_status($chs_status = null)
    {
        // validation for constraint: string
        if (!is_null($chs_status) && !is_string($chs_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chs_status, true), gettype($chs_status)), __LINE__);
        }
        $this->chs_status = $this->{'chs-status'} = $chs_status;
        return $this;
    }
    /**
     * Get import_date_time_from value
     * @return string|null
     */
    public function getImport_date_time_from()
    {
        return $this->{'import-date-time-from'};
    }
    /**
     * Set import_date_time_from value
     * @param string $import_date_time_from
     * @return \StructType\Location
     */
    public function setImport_date_time_from($import_date_time_from = null)
    {
        // validation for constraint: string
        if (!is_null($import_date_time_from) && !is_string($import_date_time_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($import_date_time_from, true), gettype($import_date_time_from)), __LINE__);
        }
        $this->import_date_time_from = $this->{'import-date-time-from'} = $import_date_time_from;
        return $this;
    }
    /**
     * Get import_date_time_to value
     * @return string|null
     */
    public function getImport_date_time_to()
    {
        return $this->{'import-date-time-to'};
    }
    /**
     * Set import_date_time_to value
     * @param string $import_date_time_to
     * @return \StructType\Location
     */
    public function setImport_date_time_to($import_date_time_to = null)
    {
        // validation for constraint: string
        if (!is_null($import_date_time_to) && !is_string($import_date_time_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($import_date_time_to, true), gettype($import_date_time_to)), __LINE__);
        }
        $this->import_date_time_to = $this->{'import-date-time-to'} = $import_date_time_to;
        return $this;
    }
    /**
     * Get rut_identification value
     * @return string|null
     */
    public function getRut_identification()
    {
        return $this->{'rut-identification'};
    }
    /**
     * Set rut_identification value
     * @param string $rut_identification
     * @return \StructType\Location
     */
    public function setRut_identification($rut_identification = null)
    {
        // validation for constraint: string
        if (!is_null($rut_identification) && !is_string($rut_identification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rut_identification, true), gettype($rut_identification)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($rut_identification) && mb_strlen($rut_identification) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($rut_identification)), __LINE__);
        }
        // validation for constraint: minLength(13)
        if (!is_null($rut_identification) && mb_strlen($rut_identification) < 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 13', mb_strlen($rut_identification)), __LINE__);
        }
        // validation for constraint: pattern(\c{16})
        if (!is_null($rut_identification) && !preg_match('/\\c{16}/', $rut_identification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \c{16}', var_export($rut_identification, true)), __LINE__);
        }
        $this->rut_identification = $this->{'rut-identification'} = $rut_identification;
        return $this;
    }
    /**
     * Get rut_service value
     * @return string|null
     */
    public function getRut_service()
    {
        return $this->{'rut-service'};
    }
    /**
     * Set rut_service value
     * @param string $rut_service
     * @return \StructType\Location
     */
    public function setRut_service($rut_service = null)
    {
        // validation for constraint: string
        if (!is_null($rut_service) && !is_string($rut_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rut_service, true), gettype($rut_service)), __LINE__);
        }
        $this->rut_service = $this->{'rut-service'} = $rut_service;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\Location
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get syst_serv_status value
     * @return string|null
     */
    public function getSyst_serv_status()
    {
        return $this->{'syst-serv-status'};
    }
    /**
     * Set syst_serv_status value
     * @param string $syst_serv_status
     * @return \StructType\Location
     */
    public function setSyst_serv_status($syst_serv_status = null)
    {
        // validation for constraint: string
        if (!is_null($syst_serv_status) && !is_string($syst_serv_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syst_serv_status, true), gettype($syst_serv_status)), __LINE__);
        }
        $this->syst_serv_status = $this->{'syst-serv-status'} = $syst_serv_status;
        return $this;
    }
    /**
     * Get chs_type value
     * @return string|null
     */
    public function getChs_type()
    {
        return $this->{'chs-type'};
    }
    /**
     * Set chs_type value
     * @param string $chs_type
     * @return \StructType\Location
     */
    public function setChs_type($chs_type = null)
    {
        // validation for constraint: string
        if (!is_null($chs_type) && !is_string($chs_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chs_type, true), gettype($chs_type)), __LINE__);
        }
        $this->chs_type = $this->{'chs-type'} = $chs_type;
        return $this;
    }
    /**
     * Get chs_reason value
     * @return string|null
     */
    public function getChs_reason()
    {
        return $this->{'chs-reason'};
    }
    /**
     * Set chs_reason value
     * @param string $chs_reason
     * @return \StructType\Location
     */
    public function setChs_reason($chs_reason = null)
    {
        // validation for constraint: string
        if (!is_null($chs_reason) && !is_string($chs_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chs_reason, true), gettype($chs_reason)), __LINE__);
        }
        $this->chs_reason = $this->{'chs-reason'} = $chs_reason;
        return $this;
    }
}
