<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOfBillingItemsSubTotal StructType
 * Meta information extracted from the WSDL
 * - documentation: Sub-total of billing items | (Mezi)součet za skupinu položek
 * @subpackage Structs
 */
class ListOfBillingItemsSubTotal extends AbstractStructBase
{
    /**
     * The ItemNetValue
     * Meta information extracted from the WSDL
     * - documentation: Value without tax | Hodnota bez daně
     * @var \StructType\Price_Type
     */
    public $ItemNetValue;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: Tax | Daň
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_Type[]
     */
    public $Tax;
    /**
     * The ItemGrossValue
     * Meta information extracted from the WSDL
     * - documentation: Value with tax | Hodnota s daní
     * - minOccurs: 0
     * @var \StructType\Price_Type
     */
    public $ItemGrossValue;
    /**
     * Constructor method for ListOfBillingItemsSubTotal
     * @uses ListOfBillingItemsSubTotal::setItemNetValue()
     * @uses ListOfBillingItemsSubTotal::setTax()
     * @uses ListOfBillingItemsSubTotal::setItemGrossValue()
     * @param \StructType\Price_Type $itemNetValue
     * @param \StructType\Tax_Type[] $tax
     * @param \StructType\Price_Type $itemGrossValue
     */
    public function __construct(\StructType\Price_Type $itemNetValue = null, array $tax = array(), \StructType\Price_Type $itemGrossValue = null)
    {
        $this
            ->setItemNetValue($itemNetValue)
            ->setTax($tax)
            ->setItemGrossValue($itemGrossValue);
    }
    /**
     * Get ItemNetValue value
     * @return \StructType\Price_Type|null
     */
    public function getItemNetValue()
    {
        return $this->ItemNetValue;
    }
    /**
     * Set ItemNetValue value
     * @param \StructType\Price_Type $itemNetValue
     * @return \StructType\ListOfBillingItemsSubTotal
     */
    public function setItemNetValue(\StructType\Price_Type $itemNetValue = null)
    {
        $this->ItemNetValue = $itemNetValue;
        return $this;
    }
    /**
     * Get Tax value
     * @return \StructType\Tax_Type[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listOfBillingItemsSubTotalTaxItem) {
            // validation for constraint: itemType
            if (!$listOfBillingItemsSubTotalTaxItem instanceof \StructType\Tax_Type) {
                $invalidValues[] = is_object($listOfBillingItemsSubTotalTaxItem) ? get_class($listOfBillingItemsSubTotalTaxItem) : sprintf('%s(%s)', gettype($listOfBillingItemsSubTotalTaxItem), var_export($listOfBillingItemsSubTotalTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type \StructType\Tax_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Type[] $tax
     * @return \StructType\ListOfBillingItemsSubTotal
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Type $item
     * @return \StructType\ListOfBillingItemsSubTotal
     */
    public function addToTax(\StructType\Tax_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_Type) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type \StructType\Tax_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get ItemGrossValue value
     * @return \StructType\Price_Type|null
     */
    public function getItemGrossValue()
    {
        return $this->ItemGrossValue;
    }
    /**
     * Set ItemGrossValue value
     * @param \StructType\Price_Type $itemGrossValue
     * @return \StructType\ListOfBillingItemsSubTotal
     */
    public function setItemGrossValue(\StructType\Price_Type $itemGrossValue = null)
    {
        $this->ItemGrossValue = $itemGrossValue;
        return $this;
    }
}
