<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemDates StructType
 * Meta information extracted from the WSDL
 * - documentation: Item dates | Datumy položky
 * @subpackage Structs
 */
class ItemDates extends AbstractStructBase
{
    /**
     * The due_date
     * Meta information extracted from the WSDL
     * - documentation: Due date (for budget billing) | Datum splatnosti (pro zálohy)
     * @var string
     */
    public $due_date;
    /**
     * The billing_period_start
     * Meta information extracted from the WSDL
     * - documentation: Billing period | Zúčtovací období
     * @var string
     */
    public $billing_period_start;
    /**
     * The billing_period_end
     * Meta information extracted from the WSDL
     * - documentation: Billing period | Zúčtovací období
     * @var string
     */
    public $billing_period_end;
    /**
     * The payment_date
     * @var string
     */
    public $payment_date;
    /**
     * Constructor method for ItemDates
     * @uses ItemDates::setDue_date()
     * @uses ItemDates::setBilling_period_start()
     * @uses ItemDates::setBilling_period_end()
     * @uses ItemDates::setPayment_date()
     * @param string $due_date
     * @param string $billing_period_start
     * @param string $billing_period_end
     * @param string $payment_date
     */
    public function __construct($due_date = null, $billing_period_start = null, $billing_period_end = null, $payment_date = null)
    {
        $this
            ->setDue_date($due_date)
            ->setBilling_period_start($billing_period_start)
            ->setBilling_period_end($billing_period_end)
            ->setPayment_date($payment_date);
    }
    /**
     * Get due_date value
     * @return string|null
     */
    public function getDue_date()
    {
        return $this->{'due-date'};
    }
    /**
     * Set due_date value
     * @param string $due_date
     * @return \StructType\ItemDates
     */
    public function setDue_date($due_date = null)
    {
        // validation for constraint: string
        if (!is_null($due_date) && !is_string($due_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_date, true), gettype($due_date)), __LINE__);
        }
        $this->due_date = $this->{'due-date'} = $due_date;
        return $this;
    }
    /**
     * Get billing_period_start value
     * @return string|null
     */
    public function getBilling_period_start()
    {
        return $this->{'billing-period-start'};
    }
    /**
     * Set billing_period_start value
     * @param string $billing_period_start
     * @return \StructType\ItemDates
     */
    public function setBilling_period_start($billing_period_start = null)
    {
        // validation for constraint: string
        if (!is_null($billing_period_start) && !is_string($billing_period_start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billing_period_start, true), gettype($billing_period_start)), __LINE__);
        }
        $this->billing_period_start = $this->{'billing-period-start'} = $billing_period_start;
        return $this;
    }
    /**
     * Get billing_period_end value
     * @return string|null
     */
    public function getBilling_period_end()
    {
        return $this->{'billing-period-end'};
    }
    /**
     * Set billing_period_end value
     * @param string $billing_period_end
     * @return \StructType\ItemDates
     */
    public function setBilling_period_end($billing_period_end = null)
    {
        // validation for constraint: string
        if (!is_null($billing_period_end) && !is_string($billing_period_end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billing_period_end, true), gettype($billing_period_end)), __LINE__);
        }
        $this->billing_period_end = $this->{'billing-period-end'} = $billing_period_end;
        return $this;
    }
    /**
     * Get payment_date value
     * @return string|null
     */
    public function getPayment_date()
    {
        return $this->{'payment-date'};
    }
    /**
     * Set payment_date value
     * @param string $payment_date
     * @return \StructType\ItemDates
     */
    public function setPayment_date($payment_date = null)
    {
        // validation for constraint: string
        if (!is_null($payment_date) && !is_string($payment_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_date, true), gettype($payment_date)), __LINE__);
        }
        $this->payment_date = $this->{'payment-date'} = $payment_date;
        return $this;
    }
}
