<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ereact_type StructType
 * Meta information extracted from the WSDL
 * - documentation: Reactive energy type per PDT | Typ pro jalovou energii za OPM
 * @subpackage Structs
 */
class Ereact_type extends AbstractStructBase
{
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Date and time | Datum a čas
     * - use: optional
     * @var string
     */
    public $date_time;
    /**
     * The qty
     * Meta information extracted from the WSDL
     * - documentation: Quantity | Množství | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $qty;
    /**
     * The tg_fi
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 5
     * - use: optional
     * @var float
     */
    public $tg_fi;
    /**
     * Constructor method for ereact_type
     * @uses Ereact_type::setDate_time()
     * @uses Ereact_type::setQty()
     * @uses Ereact_type::setTg_fi()
     * @param string $date_time
     * @param string $qty
     * @param float $tg_fi
     */
    public function __construct($date_time = null, $qty = null, $tg_fi = null)
    {
        $this
            ->setDate_time($date_time)
            ->setQty($qty)
            ->setTg_fi($tg_fi);
    }
    /**
     * Get date_time value
     * @return string|null
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\Ereact_type
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
    /**
     * Get qty value
     * @return string|null
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param string $qty
     * @return \StructType\Ereact_type
     */
    public function setQty($qty = null)
    {
        // validation for constraint: string
        if (!is_null($qty) && !is_string($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qty) && mb_strlen($qty) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qty)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($qty) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($qty, true)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
    /**
     * Get tg_fi value
     * @return float|null
     */
    public function getTg_fi()
    {
        return $this->{'tg-fi'};
    }
    /**
     * Set tg_fi value
     * @param float $tg_fi
     * @return \StructType\Ereact_type
     */
    public function setTg_fi($tg_fi = null)
    {
        // validation for constraint: float
        if (!is_null($tg_fi) && !(is_float($tg_fi) || is_numeric($tg_fi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tg_fi, true), gettype($tg_fi)), __LINE__);
        }
        // validation for constraint: fractionDigits(5)
        if (!is_null($tg_fi) && mb_strlen(mb_substr($tg_fi, false !== mb_strpos($tg_fi, '.') ? mb_strpos($tg_fi, '.') + 1 : mb_strlen($tg_fi))) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 5 fraction digits, %d given', var_export($tg_fi, true), mb_strlen(mb_substr($tg_fi, mb_strpos($tg_fi, '.') + 1))), __LINE__);
        }
        $this->tg_fi = $this->{'tg-fi'} = $tg_fi;
        return $this;
    }
}
