<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocDetail StructType
 * @subpackage Structs
 */
class DocDetail extends AbstractStructBase
{
    /**
     * The ListOfItems
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ListOfItems[]
     */
    public $ListOfItems;
    /**
     * The ListOfPDTBlocks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ListOfPDTBlocks
     */
    public $ListOfPDTBlocks;
    /**
     * The DocDetailNote
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $DocDetailNote;
    /**
     * Constructor method for DocDetail
     * @uses DocDetail::setListOfItems()
     * @uses DocDetail::setListOfPDTBlocks()
     * @uses DocDetail::setDocDetailNote()
     * @param \StructType\ListOfItems[] $listOfItems
     * @param \StructType\ListOfPDTBlocks $listOfPDTBlocks
     * @param mixed[] $docDetailNote
     */
    public function __construct(array $listOfItems = array(), \StructType\ListOfPDTBlocks $listOfPDTBlocks = null, array $docDetailNote = array())
    {
        $this
            ->setListOfItems($listOfItems)
            ->setListOfPDTBlocks($listOfPDTBlocks)
            ->setDocDetailNote($docDetailNote);
    }
    /**
     * Get ListOfItems value
     * @return \StructType\ListOfItems[]|null
     */
    public function getListOfItems()
    {
        return $this->ListOfItems;
    }
    /**
     * This method is responsible for validating the values passed to the setListOfItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListOfItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListOfItemsForArrayConstraintsFromSetListOfItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docDetailListOfItemsItem) {
            // validation for constraint: itemType
            if (!$docDetailListOfItemsItem instanceof \StructType\ListOfItems) {
                $invalidValues[] = is_object($docDetailListOfItemsItem) ? get_class($docDetailListOfItemsItem) : sprintf('%s(%s)', gettype($docDetailListOfItemsItem), var_export($docDetailListOfItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListOfItems property can only contain items of type \StructType\ListOfItems, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ListOfItems value
     * @throws \InvalidArgumentException
     * @param \StructType\ListOfItems[] $listOfItems
     * @return \StructType\DocDetail
     */
    public function setListOfItems(array $listOfItems = array())
    {
        // validation for constraint: array
        if ('' !== ($listOfItemsArrayErrorMessage = self::validateListOfItemsForArrayConstraintsFromSetListOfItems($listOfItems))) {
            throw new \InvalidArgumentException($listOfItemsArrayErrorMessage, __LINE__);
        }
        $this->ListOfItems = $listOfItems;
        return $this;
    }
    /**
     * Add item to ListOfItems value
     * @throws \InvalidArgumentException
     * @param \StructType\ListOfItems $item
     * @return \StructType\DocDetail
     */
    public function addToListOfItems(\StructType\ListOfItems $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ListOfItems) {
            throw new \InvalidArgumentException(sprintf('The ListOfItems property can only contain items of type \StructType\ListOfItems, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ListOfItems[] = $item;
        return $this;
    }
    /**
     * Get ListOfPDTBlocks value
     * @return \StructType\ListOfPDTBlocks|null
     */
    public function getListOfPDTBlocks()
    {
        return $this->ListOfPDTBlocks;
    }
    /**
     * Set ListOfPDTBlocks value
     * @param \StructType\ListOfPDTBlocks $listOfPDTBlocks
     * @return \StructType\DocDetail
     */
    public function setListOfPDTBlocks(\StructType\ListOfPDTBlocks $listOfPDTBlocks = null)
    {
        $this->ListOfPDTBlocks = $listOfPDTBlocks;
        return $this;
    }
    /**
     * Get DocDetailNote value
     * @return mixed[]|null
     */
    public function getDocDetailNote()
    {
        return $this->DocDetailNote;
    }
    /**
     * This method is responsible for validating the values passed to the setDocDetailNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocDetailNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocDetailNoteForArrayConstraintsFromSetDocDetailNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docDetailDocDetailNoteItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($docDetailDocDetailNoteItem) ? get_class($docDetailDocDetailNoteItem) : sprintf('%s(%s)', gettype($docDetailDocDetailNoteItem), var_export($docDetailDocDetailNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocDetailNote property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocDetailNote value
     * @throws \InvalidArgumentException
     * @param mixed[] $docDetailNote
     * @return \StructType\DocDetail
     */
    public function setDocDetailNote(array $docDetailNote = array())
    {
        // validation for constraint: array
        if ('' !== ($docDetailNoteArrayErrorMessage = self::validateDocDetailNoteForArrayConstraintsFromSetDocDetailNote($docDetailNote))) {
            throw new \InvalidArgumentException($docDetailNoteArrayErrorMessage, __LINE__);
        }
        $this->DocDetailNote = $docDetailNote;
        return $this;
    }
    /**
     * Add item to DocDetailNote value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\DocDetail
     */
    public function addToDocDetailNote($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The DocDetailNote property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocDetailNote[] = $item;
        return $this;
    }
}
