<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Communication StructType
 * Meta information extracted from the WSDL
 * - documentation: Communication chanels | Komunikace
 * @subpackage Structs
 */
class Communication extends AbstractStructBase
{
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The www
     * @var string
     */
    public $www;
    /**
     * Constructor method for Communication
     * @uses Communication::setEmail()
     * @uses Communication::setWww()
     * @param string $email
     * @param string $www
     */
    public function __construct($email = null, $www = null)
    {
        $this
            ->setEmail($email)
            ->setWww($www);
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Communication
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get www value
     * @return string|null
     */
    public function getWww()
    {
        return $this->www;
    }
    /**
     * Set www value
     * @param string $www
     * @return \StructType\Communication
     */
    public function setWww($www = null)
    {
        // validation for constraint: string
        if (!is_null($www) && !is_string($www)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($www, true), gettype($www)), __LINE__);
        }
        $this->www = $www;
        return $this;
    }
}
