<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CDSINVOICE StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element containing basic message data | Rootovský element obsahující základní údaje o zprávě
 * @subpackage Structs
 */
class CDSINVOICE extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Message identification | Identifikátor zprávy | Typ pro číslo zprávy | Message number type
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The message_code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $message_code;
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Date and time of message | Datum a čas zprávy
     * - use: required
     * @var string
     */
    public $date_time;
    /**
     * The dtd_version
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions. So far a constant '1' | Rezervováno pro příští verze, zatím konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_version;
    /**
     * The dtd_release
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions. So far a constant '1' | Rezervováno pro příští verze, zatím konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_release;
    /**
     * The answer_required
     * Meta information extracted from the WSDL
     * - documentation: Indication of request for response (1=YES, 0=NO) | Indikace požadavku na odpověď (1=ANO, 0=NE)
     * - use: required
     * @var bool
     */
    public $answer_required;
    /**
     * The SenderIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message sender identification - for electronic invoice the invoice sender - distributor. | Identifikace odesílatele zprávy. Pro elektronickou fakturu - odesílatel faktury - PDS
     * @var \StructType\SenderIdentificationType
     */
    public $SenderIdentification;
    /**
     * The ReceiverIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message receiver identification. For electronic invoice the invoice receiver - the supplier. | Identifikace příjemce zprávy. Pro elektronickou fakturu příjemce faktury - obchodník.
     * @var \StructType\ReceiverIdentificationType
     */
    public $ReceiverIdentification;
    /**
     * The DataProvider
     * Meta information extracted from the WSDL
     * - documentation: Data provider identification. For electronic invoice - Market Operator (OTE) | Identifikace poskytovatele dat. Pro elektronickou fakturu vždy Operátor trhu.
     * @var \StructType\DataProviderType
     */
    public $DataProvider;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the previous message | Reference na předešlou zprávu
     * - minOccurs: 0
     * @var \StructType\ReferenceType
     */
    public $Reference;
    /**
     * The DocumentEnvelope
     * @var \StructType\DocumentEnvelope
     */
    public $DocumentEnvelope;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType
     */
    public $Signature;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 2
     * - use: optional
     * @var string
     */
    public $language;
    /**
     * The interval
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?/\d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?
     * - use: optional
     * @var string
     */
    public $interval;
    /**
     * The time_offset
     * @var string
     */
    public $time_offset;
    /**
     * Constructor method for CDSINVOICE
     * @uses CDSINVOICE::setId()
     * @uses CDSINVOICE::setMessage_code()
     * @uses CDSINVOICE::setDate_time()
     * @uses CDSINVOICE::setDtd_version()
     * @uses CDSINVOICE::setDtd_release()
     * @uses CDSINVOICE::setAnswer_required()
     * @uses CDSINVOICE::setSenderIdentification()
     * @uses CDSINVOICE::setReceiverIdentification()
     * @uses CDSINVOICE::setDataProvider()
     * @uses CDSINVOICE::setReference()
     * @uses CDSINVOICE::setDocumentEnvelope()
     * @uses CDSINVOICE::setSignature()
     * @uses CDSINVOICE::setLanguage()
     * @uses CDSINVOICE::setInterval()
     * @uses CDSINVOICE::setTime_offset()
     * @param string $id
     * @param string $message_code
     * @param string $date_time
     * @param string $dtd_version
     * @param string $dtd_release
     * @param bool $answer_required
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @param \StructType\DataProviderType $dataProvider
     * @param \StructType\ReferenceType $reference
     * @param \StructType\DocumentEnvelope $documentEnvelope
     * @param \StructType\SignatureType $signature
     * @param string $language
     * @param string $interval
     * @param string $time_offset
     */
    public function __construct($id = null, $message_code = null, $date_time = null, $dtd_version = null, $dtd_release = null, $answer_required = null, \StructType\SenderIdentificationType $senderIdentification = null, \StructType\ReceiverIdentificationType $receiverIdentification = null, \StructType\DataProviderType $dataProvider = null, \StructType\ReferenceType $reference = null, \StructType\DocumentEnvelope $documentEnvelope = null, \StructType\SignatureType $signature = null, $language = null, $interval = null, $time_offset = null)
    {
        $this
            ->setId($id)
            ->setMessage_code($message_code)
            ->setDate_time($date_time)
            ->setDtd_version($dtd_version)
            ->setDtd_release($dtd_release)
            ->setAnswer_required($answer_required)
            ->setSenderIdentification($senderIdentification)
            ->setReceiverIdentification($receiverIdentification)
            ->setDataProvider($dataProvider)
            ->setReference($reference)
            ->setDocumentEnvelope($documentEnvelope)
            ->setSignature($signature)
            ->setLanguage($language)
            ->setInterval($interval)
            ->setTime_offset($time_offset);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\CDSINVOICE
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($id) && mb_strlen($id) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get message_code value
     * @return string
     */
    public function getMessage_code()
    {
        return $this->{'message-code'};
    }
    /**
     * Set message_code value
     * @param string $message_code
     * @return \StructType\CDSINVOICE
     */
    public function setMessage_code($message_code = null)
    {
        // validation for constraint: string
        if (!is_null($message_code) && !is_string($message_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message_code, true), gettype($message_code)), __LINE__);
        }
        $this->message_code = $this->{'message-code'} = $message_code;
        return $this;
    }
    /**
     * Get date_time value
     * @return string
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\CDSINVOICE
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
    /**
     * Get dtd_version value
     * @return string
     */
    public function getDtd_version()
    {
        return $this->{'dtd-version'};
    }
    /**
     * Set dtd_version value
     * @param string $dtd_version
     * @return \StructType\CDSINVOICE
     */
    public function setDtd_version($dtd_version = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_version) && !is_string($dtd_version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_version, true), gettype($dtd_version)), __LINE__);
        }
        $this->dtd_version = $this->{'dtd-version'} = $dtd_version;
        return $this;
    }
    /**
     * Get dtd_release value
     * @return string
     */
    public function getDtd_release()
    {
        return $this->{'dtd-release'};
    }
    /**
     * Set dtd_release value
     * @param string $dtd_release
     * @return \StructType\CDSINVOICE
     */
    public function setDtd_release($dtd_release = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_release) && !is_string($dtd_release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_release, true), gettype($dtd_release)), __LINE__);
        }
        $this->dtd_release = $this->{'dtd-release'} = $dtd_release;
        return $this;
    }
    /**
     * Get answer_required value
     * @return bool
     */
    public function getAnswer_required()
    {
        return $this->{'answer-required'};
    }
    /**
     * Set answer_required value
     * @param bool $answer_required
     * @return \StructType\CDSINVOICE
     */
    public function setAnswer_required($answer_required = null)
    {
        // validation for constraint: boolean
        if (!is_null($answer_required) && !is_bool($answer_required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($answer_required, true), gettype($answer_required)), __LINE__);
        }
        $this->answer_required = $this->{'answer-required'} = $answer_required;
        return $this;
    }
    /**
     * Get SenderIdentification value
     * @return \StructType\SenderIdentificationType|null
     */
    public function getSenderIdentification()
    {
        return $this->SenderIdentification;
    }
    /**
     * Set SenderIdentification value
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @return \StructType\CDSINVOICE
     */
    public function setSenderIdentification(\StructType\SenderIdentificationType $senderIdentification = null)
    {
        $this->SenderIdentification = $senderIdentification;
        return $this;
    }
    /**
     * Get ReceiverIdentification value
     * @return \StructType\ReceiverIdentificationType|null
     */
    public function getReceiverIdentification()
    {
        return $this->ReceiverIdentification;
    }
    /**
     * Set ReceiverIdentification value
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @return \StructType\CDSINVOICE
     */
    public function setReceiverIdentification(\StructType\ReceiverIdentificationType $receiverIdentification = null)
    {
        $this->ReceiverIdentification = $receiverIdentification;
        return $this;
    }
    /**
     * Get DataProvider value
     * @return \StructType\DataProviderType|null
     */
    public function getDataProvider()
    {
        return $this->DataProvider;
    }
    /**
     * Set DataProvider value
     * @param \StructType\DataProviderType $dataProvider
     * @return \StructType\CDSINVOICE
     */
    public function setDataProvider(\StructType\DataProviderType $dataProvider = null)
    {
        $this->DataProvider = $dataProvider;
        return $this;
    }
    /**
     * Get Reference value
     * @return \StructType\ReferenceType|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \StructType\ReferenceType $reference
     * @return \StructType\CDSINVOICE
     */
    public function setReference(\StructType\ReferenceType $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get DocumentEnvelope value
     * @return \StructType\DocumentEnvelope|null
     */
    public function getDocumentEnvelope()
    {
        return $this->DocumentEnvelope;
    }
    /**
     * Set DocumentEnvelope value
     * @param \StructType\DocumentEnvelope $documentEnvelope
     * @return \StructType\CDSINVOICE
     */
    public function setDocumentEnvelope(\StructType\DocumentEnvelope $documentEnvelope = null)
    {
        $this->DocumentEnvelope = $documentEnvelope;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \StructType\SignatureType $signature
     * @return \StructType\CDSINVOICE
     */
    public function setSignature(\StructType\SignatureType $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\CDSINVOICE
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($language) && mb_strlen($language) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get interval value
     * @return string|null
     */
    public function getInterval()
    {
        return $this->interval;
    }
    /**
     * Set interval value
     * @param string $interval
     * @return \StructType\CDSINVOICE
     */
    public function setInterval($interval = null)
    {
        // validation for constraint: string
        if (!is_null($interval) && !is_string($interval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interval, true), gettype($interval)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?/\d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?)
        if (!is_null($interval) && !preg_match('/\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d(:\\d\\d)?\/\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d(:\\d\\d)?/', $interval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?/\d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?', var_export($interval, true)), __LINE__);
        }
        $this->interval = $interval;
        return $this;
    }
    /**
     * Get time_offset value
     * @return string|null
     */
    public function getTime_offset()
    {
        return $this->{'time-offset'};
    }
    /**
     * Set time_offset value
     * @param string $time_offset
     * @return \StructType\CDSINVOICE
     */
    public function setTime_offset($time_offset = null)
    {
        // validation for constraint: string
        if (!is_null($time_offset) && !is_string($time_offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time_offset, true), gettype($time_offset)), __LINE__);
        }
        $this->time_offset = $this->{'time-offset'} = $time_offset;
        return $this;
    }
}
