<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CDSCLAIM StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element containing basic message data | Rootovský element obsahující základní údaje o zprávě
 * @subpackage Structs
 */
class CDSCLAIM extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Unique message identification | Jednoznačný identifikátor zprávy | Typ pro číslo zprávy | Message number type
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The message_code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $message_code;
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Date and time of message | Datum a čas zprávy
     * - use: required
     * @var string
     */
    public $date_time;
    /**
     * The dtd_version
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions. So far a constant '1' | Rezervováno pro pozdější verze. Nyní konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_version;
    /**
     * The dtd_release
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions. So far a constant '1' | Rezervováno pro pozdější verze. Nyní konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_release;
    /**
     * The SenderIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message sender identification | Identifikace odesílatele zprávy
     * @var \StructType\SenderIdentificationType
     */
    public $SenderIdentification;
    /**
     * The ReceiverIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message receiver identification | Identifikace příjemce zprávy
     * @var \StructType\ReceiverIdentificationType
     */
    public $ReceiverIdentification;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the previous message | Reference na předešlou zprávu
     * - minOccurs: 0
     * @var \StructType\ReferenceType
     */
    public $Reference;
    /**
     * The CLAIM
     * @var \StructType\CLAIM
     */
    public $CLAIM;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType
     */
    public $Signature;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - documentation: Message language | Jazyk zprávy
     * - use: optional
     * @var string
     */
    public $language;
    /**
     * The split_counter
     * Meta information extracted from the WSDL
     * - documentation: Message order within response | Pořadí zprávy v rámci odpovědi
     * - use: optional
     * @var int
     */
    public $split_counter;
    /**
     * The split_last
     * Meta information extracted from the WSDL
     * - documentation: Last message | Poslední zpráva
     * - use: optional
     * @var bool
     */
    public $split_last;
    /**
     * Constructor method for CDSCLAIM
     * @uses CDSCLAIM::setId()
     * @uses CDSCLAIM::setMessage_code()
     * @uses CDSCLAIM::setDate_time()
     * @uses CDSCLAIM::setDtd_version()
     * @uses CDSCLAIM::setDtd_release()
     * @uses CDSCLAIM::setSenderIdentification()
     * @uses CDSCLAIM::setReceiverIdentification()
     * @uses CDSCLAIM::setReference()
     * @uses CDSCLAIM::setCLAIM()
     * @uses CDSCLAIM::setSignature()
     * @uses CDSCLAIM::setLanguage()
     * @uses CDSCLAIM::setSplit_counter()
     * @uses CDSCLAIM::setSplit_last()
     * @param string $id
     * @param string $message_code
     * @param string $date_time
     * @param string $dtd_version
     * @param string $dtd_release
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @param \StructType\ReferenceType $reference
     * @param \StructType\CLAIM $cLAIM
     * @param \StructType\SignatureType $signature
     * @param string $language
     * @param int $split_counter
     * @param bool $split_last
     */
    public function __construct($id = null, $message_code = null, $date_time = null, $dtd_version = null, $dtd_release = null, \StructType\SenderIdentificationType $senderIdentification = null, \StructType\ReceiverIdentificationType $receiverIdentification = null, \StructType\ReferenceType $reference = null, \StructType\CLAIM $cLAIM = null, \StructType\SignatureType $signature = null, $language = null, $split_counter = null, $split_last = null)
    {
        $this
            ->setId($id)
            ->setMessage_code($message_code)
            ->setDate_time($date_time)
            ->setDtd_version($dtd_version)
            ->setDtd_release($dtd_release)
            ->setSenderIdentification($senderIdentification)
            ->setReceiverIdentification($receiverIdentification)
            ->setReference($reference)
            ->setCLAIM($cLAIM)
            ->setSignature($signature)
            ->setLanguage($language)
            ->setSplit_counter($split_counter)
            ->setSplit_last($split_last);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\CDSCLAIM
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($id) && mb_strlen($id) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get message_code value
     * @return string
     */
    public function getMessage_code()
    {
        return $this->{'message-code'};
    }
    /**
     * Set message_code value
     * @param string $message_code
     * @return \StructType\CDSCLAIM
     */
    public function setMessage_code($message_code = null)
    {
        // validation for constraint: string
        if (!is_null($message_code) && !is_string($message_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message_code, true), gettype($message_code)), __LINE__);
        }
        $this->message_code = $this->{'message-code'} = $message_code;
        return $this;
    }
    /**
     * Get date_time value
     * @return string
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\CDSCLAIM
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
    /**
     * Get dtd_version value
     * @return string
     */
    public function getDtd_version()
    {
        return $this->{'dtd-version'};
    }
    /**
     * Set dtd_version value
     * @param string $dtd_version
     * @return \StructType\CDSCLAIM
     */
    public function setDtd_version($dtd_version = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_version) && !is_string($dtd_version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_version, true), gettype($dtd_version)), __LINE__);
        }
        $this->dtd_version = $this->{'dtd-version'} = $dtd_version;
        return $this;
    }
    /**
     * Get dtd_release value
     * @return string
     */
    public function getDtd_release()
    {
        return $this->{'dtd-release'};
    }
    /**
     * Set dtd_release value
     * @param string $dtd_release
     * @return \StructType\CDSCLAIM
     */
    public function setDtd_release($dtd_release = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_release) && !is_string($dtd_release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_release, true), gettype($dtd_release)), __LINE__);
        }
        $this->dtd_release = $this->{'dtd-release'} = $dtd_release;
        return $this;
    }
    /**
     * Get SenderIdentification value
     * @return \StructType\SenderIdentificationType|null
     */
    public function getSenderIdentification()
    {
        return $this->SenderIdentification;
    }
    /**
     * Set SenderIdentification value
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @return \StructType\CDSCLAIM
     */
    public function setSenderIdentification(\StructType\SenderIdentificationType $senderIdentification = null)
    {
        $this->SenderIdentification = $senderIdentification;
        return $this;
    }
    /**
     * Get ReceiverIdentification value
     * @return \StructType\ReceiverIdentificationType|null
     */
    public function getReceiverIdentification()
    {
        return $this->ReceiverIdentification;
    }
    /**
     * Set ReceiverIdentification value
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @return \StructType\CDSCLAIM
     */
    public function setReceiverIdentification(\StructType\ReceiverIdentificationType $receiverIdentification = null)
    {
        $this->ReceiverIdentification = $receiverIdentification;
        return $this;
    }
    /**
     * Get Reference value
     * @return \StructType\ReferenceType|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \StructType\ReferenceType $reference
     * @return \StructType\CDSCLAIM
     */
    public function setReference(\StructType\ReferenceType $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get CLAIM value
     * @return \StructType\CLAIM|null
     */
    public function getCLAIM()
    {
        return $this->CLAIM;
    }
    /**
     * Set CLAIM value
     * @param \StructType\CLAIM $cLAIM
     * @return \StructType\CDSCLAIM
     */
    public function setCLAIM(\StructType\CLAIM $cLAIM = null)
    {
        $this->CLAIM = $cLAIM;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \StructType\SignatureType $signature
     * @return \StructType\CDSCLAIM
     */
    public function setSignature(\StructType\SignatureType $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\CDSCLAIM
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get split_counter value
     * @return int|null
     */
    public function getSplit_counter()
    {
        return $this->{'split-counter'};
    }
    /**
     * Set split_counter value
     * @param int $split_counter
     * @return \StructType\CDSCLAIM
     */
    public function setSplit_counter($split_counter = null)
    {
        // validation for constraint: int
        if (!is_null($split_counter) && !(is_int($split_counter) || ctype_digit($split_counter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($split_counter, true), gettype($split_counter)), __LINE__);
        }
        $this->split_counter = $this->{'split-counter'} = $split_counter;
        return $this;
    }
    /**
     * Get split_last value
     * @return bool|null
     */
    public function getSplit_last()
    {
        return $this->{'split-last'};
    }
    /**
     * Set split_last value
     * @param bool $split_last
     * @return \StructType\CDSCLAIM
     */
    public function setSplit_last($split_last = null)
    {
        // validation for constraint: boolean
        if (!is_null($split_last) && !is_bool($split_last)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($split_last, true), gettype($split_last)), __LINE__);
        }
        $this->split_last = $this->{'split-last'} = $split_last;
        return $this;
    }
}
