<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseItemDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Base date of item | Základní údaje položky
 * @subpackage Structs
 */
class BaseItemDetail extends AbstractStructBase
{
    /**
     * The item_id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4
     * @var string
     */
    public $item_id;
    /**
     * The item_text
     * @var string
     */
    public $item_text;
    /**
     * The quantity
     * @var string
     */
    public $quantity;
    /**
     * The unit
     * @var string
     */
    public $unit;
    /**
     * Constructor method for BaseItemDetail
     * @uses BaseItemDetail::setItem_id()
     * @uses BaseItemDetail::setItem_text()
     * @uses BaseItemDetail::setQuantity()
     * @uses BaseItemDetail::setUnit()
     * @param string $item_id
     * @param string $item_text
     * @param string $quantity
     * @param string $unit
     */
    public function __construct($item_id = null, $item_text = null, $quantity = null, $unit = null)
    {
        $this
            ->setItem_id($item_id)
            ->setItem_text($item_text)
            ->setQuantity($quantity)
            ->setUnit($unit);
    }
    /**
     * Get item_id value
     * @return string|null
     */
    public function getItem_id()
    {
        return $this->{'item-id'};
    }
    /**
     * Set item_id value
     * @param string $item_id
     * @return \StructType\BaseItemDetail
     */
    public function setItem_id($item_id = null)
    {
        // validation for constraint: string
        if (!is_null($item_id) && !is_string($item_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_id, true), gettype($item_id)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($item_id) && mb_strlen($item_id) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($item_id)), __LINE__);
        }
        $this->item_id = $this->{'item-id'} = $item_id;
        return $this;
    }
    /**
     * Get item_text value
     * @return string|null
     */
    public function getItem_text()
    {
        return $this->{'item-text'};
    }
    /**
     * Set item_text value
     * @param string $item_text
     * @return \StructType\BaseItemDetail
     */
    public function setItem_text($item_text = null)
    {
        // validation for constraint: string
        if (!is_null($item_text) && !is_string($item_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_text, true), gettype($item_text)), __LINE__);
        }
        $this->item_text = $this->{'item-text'} = $item_text;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\BaseItemDetail
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param string $unit
     * @return \StructType\BaseItemDetail
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unit, true), gettype($unit)), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
}
