<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for X509DataType StructType
 * @subpackage Structs
 */
class X509DataType extends AbstractStructBase
{
    /**
     * The X509IssuerSerial
     * Meta information extracted from the WSDL
     * - choice: X509IssuerSerial | X509SKI | X509SubjectName | X509Certificate | X509CRL |
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\X509IssuerSerialType
     */
    public $X509IssuerSerial;
    /**
     * The X509SKI
     * Meta information extracted from the WSDL
     * - choice: X509IssuerSerial | X509SKI | X509SubjectName | X509Certificate | X509CRL |
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $X509SKI;
    /**
     * The X509SubjectName
     * Meta information extracted from the WSDL
     * - choice: X509IssuerSerial | X509SKI | X509SubjectName | X509Certificate | X509CRL |
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $X509SubjectName;
    /**
     * The X509Certificate
     * Meta information extracted from the WSDL
     * - choice: X509IssuerSerial | X509SKI | X509SubjectName | X509Certificate | X509CRL |
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $X509Certificate;
    /**
     * The X509CRL
     * Meta information extracted from the WSDL
     * - choice: X509IssuerSerial | X509SKI | X509SubjectName | X509Certificate | X509CRL |
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $X509CRL;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for X509DataType
     * @uses X509DataType::setX509IssuerSerial()
     * @uses X509DataType::setX509SKI()
     * @uses X509DataType::setX509SubjectName()
     * @uses X509DataType::setX509Certificate()
     * @uses X509DataType::setX509CRL()
     * @uses X509DataType::setAny()
     * @param \StructType\X509IssuerSerialType $x509IssuerSerial
     * @param string $x509SKI
     * @param string $x509SubjectName
     * @param string $x509Certificate
     * @param string $x509CRL
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\X509IssuerSerialType $x509IssuerSerial = null, $x509SKI = null, $x509SubjectName = null, $x509Certificate = null, $x509CRL = null, \DOMDocument $any = null)
    {
        $this
            ->setX509IssuerSerial($x509IssuerSerial)
            ->setX509SKI($x509SKI)
            ->setX509SubjectName($x509SubjectName)
            ->setX509Certificate($x509Certificate)
            ->setX509CRL($x509CRL)
            ->setAny($any);
    }
    /**
     * Get X509IssuerSerial value
     * @return \StructType\X509IssuerSerialType|null
     */
    public function getX509IssuerSerial()
    {
        return isset($this->X509IssuerSerial) ? $this->X509IssuerSerial : null;
    }
    /**
     * This method is responsible for validating the value passed to the setX509IssuerSerial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509IssuerSerial method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509IssuerSerialForChoiceConstraintsFromSetX509IssuerSerial($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509SKI',
            'X509SubjectName',
            'X509Certificate',
            'X509CRL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property X509IssuerSerial can\'t be set as the property %s is already set. Only one property must be set among these properties: X509IssuerSerial, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set X509IssuerSerial value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\X509IssuerSerialType $x509IssuerSerial
     * @return \StructType\X509DataType
     */
    public function setX509IssuerSerial(\StructType\X509IssuerSerialType $x509IssuerSerial = null)
    {
        // validation for constraint: choice(X509IssuerSerial, X509SKI, X509SubjectName, X509Certificate, X509CRL, )
        if ('' !== ($x509IssuerSerialChoiceErrorMessage = self::validateX509IssuerSerialForChoiceConstraintsFromSetX509IssuerSerial($x509IssuerSerial))) {
            throw new \InvalidArgumentException($x509IssuerSerialChoiceErrorMessage, __LINE__);
        }
        if (is_null($x509IssuerSerial) || (is_array($x509IssuerSerial) && empty($x509IssuerSerial))) {
            unset($this->X509IssuerSerial);
        } else {
            $this->X509IssuerSerial = $x509IssuerSerial;
        }
        return $this;
    }
    /**
     * Get X509SKI value
     * @return string|null
     */
    public function getX509SKI()
    {
        return isset($this->X509SKI) ? $this->X509SKI : null;
    }
    /**
     * This method is responsible for validating the value passed to the setX509SKI method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509SKI method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509SKIForChoiceConstraintsFromSetX509SKI($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509IssuerSerial',
            'X509SubjectName',
            'X509Certificate',
            'X509CRL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property X509SKI can\'t be set as the property %s is already set. Only one property must be set among these properties: X509SKI, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set X509SKI value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $x509SKI
     * @return \StructType\X509DataType
     */
    public function setX509SKI($x509SKI = null)
    {
        // validation for constraint: string
        if (!is_null($x509SKI) && !is_string($x509SKI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($x509SKI, true), gettype($x509SKI)), __LINE__);
        }
        // validation for constraint: choice(X509IssuerSerial, X509SKI, X509SubjectName, X509Certificate, X509CRL, )
        if ('' !== ($x509SKIChoiceErrorMessage = self::validateX509SKIForChoiceConstraintsFromSetX509SKI($x509SKI))) {
            throw new \InvalidArgumentException($x509SKIChoiceErrorMessage, __LINE__);
        }
        if (is_null($x509SKI) || (is_array($x509SKI) && empty($x509SKI))) {
            unset($this->X509SKI);
        } else {
            $this->X509SKI = $x509SKI;
        }
        return $this;
    }
    /**
     * Get X509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return isset($this->X509SubjectName) ? $this->X509SubjectName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setX509SubjectName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509SubjectName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509SubjectNameForChoiceConstraintsFromSetX509SubjectName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509IssuerSerial',
            'X509SKI',
            'X509Certificate',
            'X509CRL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property X509SubjectName can\'t be set as the property %s is already set. Only one property must be set among these properties: X509SubjectName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set X509SubjectName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $x509SubjectName
     * @return \StructType\X509DataType
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        // validation for constraint: string
        if (!is_null($x509SubjectName) && !is_string($x509SubjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($x509SubjectName, true), gettype($x509SubjectName)), __LINE__);
        }
        // validation for constraint: choice(X509IssuerSerial, X509SKI, X509SubjectName, X509Certificate, X509CRL, )
        if ('' !== ($x509SubjectNameChoiceErrorMessage = self::validateX509SubjectNameForChoiceConstraintsFromSetX509SubjectName($x509SubjectName))) {
            throw new \InvalidArgumentException($x509SubjectNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($x509SubjectName) || (is_array($x509SubjectName) && empty($x509SubjectName))) {
            unset($this->X509SubjectName);
        } else {
            $this->X509SubjectName = $x509SubjectName;
        }
        return $this;
    }
    /**
     * Get X509Certificate value
     * @return string|null
     */
    public function getX509Certificate()
    {
        return isset($this->X509Certificate) ? $this->X509Certificate : null;
    }
    /**
     * This method is responsible for validating the value passed to the setX509Certificate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509Certificate method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509CertificateForChoiceConstraintsFromSetX509Certificate($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509IssuerSerial',
            'X509SKI',
            'X509SubjectName',
            'X509CRL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property X509Certificate can\'t be set as the property %s is already set. Only one property must be set among these properties: X509Certificate, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set X509Certificate value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $x509Certificate
     * @return \StructType\X509DataType
     */
    public function setX509Certificate($x509Certificate = null)
    {
        // validation for constraint: string
        if (!is_null($x509Certificate) && !is_string($x509Certificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($x509Certificate, true), gettype($x509Certificate)), __LINE__);
        }
        // validation for constraint: choice(X509IssuerSerial, X509SKI, X509SubjectName, X509Certificate, X509CRL, )
        if ('' !== ($x509CertificateChoiceErrorMessage = self::validateX509CertificateForChoiceConstraintsFromSetX509Certificate($x509Certificate))) {
            throw new \InvalidArgumentException($x509CertificateChoiceErrorMessage, __LINE__);
        }
        if (is_null($x509Certificate) || (is_array($x509Certificate) && empty($x509Certificate))) {
            unset($this->X509Certificate);
        } else {
            $this->X509Certificate = $x509Certificate;
        }
        return $this;
    }
    /**
     * Get X509CRL value
     * @return string|null
     */
    public function getX509CRL()
    {
        return isset($this->X509CRL) ? $this->X509CRL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setX509CRL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509CRL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509CRLForChoiceConstraintsFromSetX509CRL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'X509IssuerSerial',
            'X509SKI',
            'X509SubjectName',
            'X509Certificate',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property X509CRL can\'t be set as the property %s is already set. Only one property must be set among these properties: X509CRL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set X509CRL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $x509CRL
     * @return \StructType\X509DataType
     */
    public function setX509CRL($x509CRL = null)
    {
        // validation for constraint: string
        if (!is_null($x509CRL) && !is_string($x509CRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($x509CRL, true), gettype($x509CRL)), __LINE__);
        }
        // validation for constraint: choice(X509IssuerSerial, X509SKI, X509SubjectName, X509Certificate, X509CRL, )
        if ('' !== ($x509CRLChoiceErrorMessage = self::validateX509CRLForChoiceConstraintsFromSetX509CRL($x509CRL))) {
            throw new \InvalidArgumentException($x509CRLChoiceErrorMessage, __LINE__);
        }
        if (is_null($x509CRL) || (is_array($x509CRL) && empty($x509CRL))) {
            unset($this->X509CRL);
        } else {
            $this->X509CRL = $x509CRL;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\X509DataType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
