<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TddProfile StructType
 * Meta information extracted from the WSDL
 * - documentation: Profile identification | Identifikace profilu
 * @subpackage Structs
 */
class TddProfile extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The temp_area
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - use: required
     * @var string
     */
    public $temp_area;
    /**
     * The tdd_class
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - use: required
     * @var string
     */
    public $tdd_class;
    /**
     * The TddData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TddData[]
     */
    public $TddData;
    /**
     * Constructor method for TddProfile
     * @uses TddProfile::setId()
     * @uses TddProfile::setTemp_area()
     * @uses TddProfile::setTdd_class()
     * @uses TddProfile::setTddData()
     * @param string $id
     * @param string $temp_area
     * @param string $tdd_class
     * @param \StructType\TddData[] $tddData
     */
    public function __construct($id = null, $temp_area = null, $tdd_class = null, array $tddData = array())
    {
        $this
            ->setId($id)
            ->setTemp_area($temp_area)
            ->setTdd_class($tdd_class)
            ->setTddData($tddData);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\TddProfile
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($id) && mb_strlen($id) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get temp_area value
     * @return string
     */
    public function getTemp_area()
    {
        return $this->{'temp-area'};
    }
    /**
     * Set temp_area value
     * @param string $temp_area
     * @return \StructType\TddProfile
     */
    public function setTemp_area($temp_area = null)
    {
        // validation for constraint: string
        if (!is_null($temp_area) && !is_string($temp_area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temp_area, true), gettype($temp_area)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($temp_area) && mb_strlen($temp_area) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($temp_area)), __LINE__);
        }
        $this->temp_area = $this->{'temp-area'} = $temp_area;
        return $this;
    }
    /**
     * Get tdd_class value
     * @return string
     */
    public function getTdd_class()
    {
        return $this->{'tdd-class'};
    }
    /**
     * Set tdd_class value
     * @param string $tdd_class
     * @return \StructType\TddProfile
     */
    public function setTdd_class($tdd_class = null)
    {
        // validation for constraint: string
        if (!is_null($tdd_class) && !is_string($tdd_class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tdd_class, true), gettype($tdd_class)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($tdd_class) && mb_strlen($tdd_class) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($tdd_class)), __LINE__);
        }
        $this->tdd_class = $this->{'tdd-class'} = $tdd_class;
        return $this;
    }
    /**
     * Get TddData value
     * @return \StructType\TddData[]|null
     */
    public function getTddData()
    {
        return $this->TddData;
    }
    /**
     * This method is responsible for validating the values passed to the setTddData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTddData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTddDataForArrayConstraintsFromSetTddData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tddProfileTddDataItem) {
            // validation for constraint: itemType
            if (!$tddProfileTddDataItem instanceof \StructType\TddData) {
                $invalidValues[] = is_object($tddProfileTddDataItem) ? get_class($tddProfileTddDataItem) : sprintf('%s(%s)', gettype($tddProfileTddDataItem), var_export($tddProfileTddDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TddData property can only contain items of type \StructType\TddData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TddData value
     * @throws \InvalidArgumentException
     * @param \StructType\TddData[] $tddData
     * @return \StructType\TddProfile
     */
    public function setTddData(array $tddData = array())
    {
        // validation for constraint: array
        if ('' !== ($tddDataArrayErrorMessage = self::validateTddDataForArrayConstraintsFromSetTddData($tddData))) {
            throw new \InvalidArgumentException($tddDataArrayErrorMessage, __LINE__);
        }
        $this->TddData = $tddData;
        return $this;
    }
    /**
     * Add item to TddData value
     * @throws \InvalidArgumentException
     * @param \StructType\TddData $item
     * @return \StructType\TddProfile
     */
    public function addToTddData(\StructType\TddData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TddData) {
            throw new \InvalidArgumentException(sprintf('The TddData property can only contain items of type \StructType\TddData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TddData[] = $item;
        return $this;
    }
}
