<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TddData StructType
 * Meta information extracted from the WSDL
 * - documentation: Diagram values | Hodnoty diagramu
 * @subpackage Structs
 */
class TddData extends AbstractStructBase
{
    /**
     * The date_time_from
     * Meta information extracted from the WSDL
     * - documentation: Date and time from | Platnost hodnoty od
     * - use: required
     * @var string
     */
    public $date_time_from;
    /**
     * The date_time_to
     * Meta information extracted from the WSDL
     * - documentation: Date and time to | Platnost hodnoty do
     * - use: required
     * @var string
     */
    public $date_time_to;
    /**
     * The qty
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * - pattern: -?\d+(\.\d+)?
     * - use: required
     * @var string
     */
    public $qty;
    /**
     * Constructor method for TddData
     * @uses TddData::setDate_time_from()
     * @uses TddData::setDate_time_to()
     * @uses TddData::setQty()
     * @param string $date_time_from
     * @param string $date_time_to
     * @param string $qty
     */
    public function __construct($date_time_from = null, $date_time_to = null, $qty = null)
    {
        $this
            ->setDate_time_from($date_time_from)
            ->setDate_time_to($date_time_to)
            ->setQty($qty);
    }
    /**
     * Get date_time_from value
     * @return string
     */
    public function getDate_time_from()
    {
        return $this->{'date-time-from'};
    }
    /**
     * Set date_time_from value
     * @param string $date_time_from
     * @return \StructType\TddData
     */
    public function setDate_time_from($date_time_from = null)
    {
        // validation for constraint: string
        if (!is_null($date_time_from) && !is_string($date_time_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time_from, true), gettype($date_time_from)), __LINE__);
        }
        $this->date_time_from = $this->{'date-time-from'} = $date_time_from;
        return $this;
    }
    /**
     * Get date_time_to value
     * @return string
     */
    public function getDate_time_to()
    {
        return $this->{'date-time-to'};
    }
    /**
     * Set date_time_to value
     * @param string $date_time_to
     * @return \StructType\TddData
     */
    public function setDate_time_to($date_time_to = null)
    {
        // validation for constraint: string
        if (!is_null($date_time_to) && !is_string($date_time_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time_to, true), gettype($date_time_to)), __LINE__);
        }
        $this->date_time_to = $this->{'date-time-to'} = $date_time_to;
        return $this;
    }
    /**
     * Get qty value
     * @return string
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param string $qty
     * @return \StructType\TddData
     */
    public function setQty($qty = null)
    {
        // validation for constraint: string
        if (!is_null($qty) && !is_string($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($qty) && mb_strlen($qty) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($qty)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d+)?)
        if (!is_null($qty) && !preg_match('/-?\\d+(\\.\\d+)?/', $qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d+)?', var_export($qty, true)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
}
