<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Typ pro element daň
 * @subpackage Structs
 */
class Tax_Type extends AbstractStructBase
{
    /**
     * The tax_type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $tax_type;
    /**
     * The tax_percent
     * Meta information extracted from the WSDL
     * - documentation: Tax percent | Procento daně | Typ pro procento
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - totalDigits: 2
     * - use: required
     * @var float
     */
    public $tax_percent;
    /**
     * The tax_value
     * Meta information extracted from the WSDL
     * - documentation: Tax value | Hodnota daně | Typ pro hodnotu ceny
     * - base: xsd:decimal
     * - fractionDigits: 14
     * - totalDigits: 31
     * - use: required
     * @var float
     */
    public $tax_value;
    /**
     * The tax_value_currency
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $tax_value_currency;
    /**
     * Constructor method for Tax_Type
     * @uses Tax_Type::setTax_type()
     * @uses Tax_Type::setTax_percent()
     * @uses Tax_Type::setTax_value()
     * @uses Tax_Type::setTax_value_currency()
     * @param string $tax_type
     * @param float $tax_percent
     * @param float $tax_value
     * @param string $tax_value_currency
     */
    public function __construct($tax_type = null, $tax_percent = null, $tax_value = null, $tax_value_currency = null)
    {
        $this
            ->setTax_type($tax_type)
            ->setTax_percent($tax_percent)
            ->setTax_value($tax_value)
            ->setTax_value_currency($tax_value_currency);
    }
    /**
     * Get tax_type value
     * @return string
     */
    public function getTax_type()
    {
        return $this->{'tax-type'};
    }
    /**
     * Set tax_type value
     * @param string $tax_type
     * @return \StructType\Tax_Type
     */
    public function setTax_type($tax_type = null)
    {
        // validation for constraint: string
        if (!is_null($tax_type) && !is_string($tax_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax_type, true), gettype($tax_type)), __LINE__);
        }
        $this->tax_type = $this->{'tax-type'} = $tax_type;
        return $this;
    }
    /**
     * Get tax_percent value
     * @return float
     */
    public function getTax_percent()
    {
        return $this->{'tax-percent'};
    }
    /**
     * Set tax_percent value
     * @param float $tax_percent
     * @return \StructType\Tax_Type
     */
    public function setTax_percent($tax_percent = null)
    {
        // validation for constraint: float
        if (!is_null($tax_percent) && !(is_float($tax_percent) || is_numeric($tax_percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_percent, true), gettype($tax_percent)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($tax_percent) && mb_strlen(mb_substr($tax_percent, false !== mb_strpos($tax_percent, '.') ? mb_strpos($tax_percent, '.') + 1 : mb_strlen($tax_percent))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($tax_percent, true), mb_strlen(mb_substr($tax_percent, mb_strpos($tax_percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($tax_percent) && mb_strlen(preg_replace('/(\D)/', '', $tax_percent)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($tax_percent, true), mb_strlen(preg_replace('/(\D)/', '', $tax_percent))), __LINE__);
        }
        $this->tax_percent = $this->{'tax-percent'} = $tax_percent;
        return $this;
    }
    /**
     * Get tax_value value
     * @return float
     */
    public function getTax_value()
    {
        return $this->{'tax-value'};
    }
    /**
     * Set tax_value value
     * @param float $tax_value
     * @return \StructType\Tax_Type
     */
    public function setTax_value($tax_value = null)
    {
        // validation for constraint: float
        if (!is_null($tax_value) && !(is_float($tax_value) || is_numeric($tax_value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_value, true), gettype($tax_value)), __LINE__);
        }
        // validation for constraint: fractionDigits(14)
        if (!is_null($tax_value) && mb_strlen(mb_substr($tax_value, false !== mb_strpos($tax_value, '.') ? mb_strpos($tax_value, '.') + 1 : mb_strlen($tax_value))) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 14 fraction digits, %d given', var_export($tax_value, true), mb_strlen(mb_substr($tax_value, mb_strpos($tax_value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(31)
        if (!is_null($tax_value) && mb_strlen(preg_replace('/(\D)/', '', $tax_value)) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 31 digits, "%d" given', var_export($tax_value, true), mb_strlen(preg_replace('/(\D)/', '', $tax_value))), __LINE__);
        }
        $this->tax_value = $this->{'tax-value'} = $tax_value;
        return $this;
    }
    /**
     * Get tax_value_currency value
     * @return string
     */
    public function getTax_value_currency()
    {
        return $this->{'tax-value-currency'};
    }
    /**
     * Set tax_value_currency value
     * @param string $tax_value_currency
     * @return \StructType\Tax_Type
     */
    public function setTax_value_currency($tax_value_currency = null)
    {
        // validation for constraint: string
        if (!is_null($tax_value_currency) && !is_string($tax_value_currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax_value_currency, true), gettype($tax_value_currency)), __LINE__);
        }
        $this->tax_value_currency = $this->{'tax-value-currency'} = $tax_value_currency;
        return $this;
    }
}
