<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferencePartyID StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference partner ID (e.g. in the seller IS) | Referenční číslo partnera (např. v systému dodavatele)
 * @subpackage Structs
 */
class ReferencePartyID extends AbstractStructBase
{
    /**
     * The CustomerID
     * @var string
     */
    public $CustomerID;
    /**
     * The ContractAccountID
     * @var string
     */
    public $ContractAccountID;
    /**
     * Constructor method for ReferencePartyID
     * @uses ReferencePartyID::setCustomerID()
     * @uses ReferencePartyID::setContractAccountID()
     * @param string $customerID
     * @param string $contractAccountID
     */
    public function __construct($customerID = null, $contractAccountID = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setContractAccountID($contractAccountID);
    }
    /**
     * Get CustomerID value
     * @return string|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \StructType\ReferencePartyID
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get ContractAccountID value
     * @return string|null
     */
    public function getContractAccountID()
    {
        return $this->ContractAccountID;
    }
    /**
     * Set ContractAccountID value
     * @param string $contractAccountID
     * @return \StructType\ReferencePartyID
     */
    public function setContractAccountID($contractAccountID = null)
    {
        // validation for constraint: string
        if (!is_null($contractAccountID) && !is_string($contractAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractAccountID, true), gettype($contractAccountID)), __LINE__);
        }
        $this->ContractAccountID = $contractAccountID;
        return $this;
    }
}
