<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Pricing detail | Detail ocenění
 * @subpackage Structs
 */
class PricingDetail extends AbstractStructBase
{
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - documentation: Unit price | Jednotková cena
     * - minOccurs: 0
     * @var \StructType\Price_Type
     */
    public $UnitPrice;
    /**
     * The ItemNetValue
     * Meta information extracted from the WSDL
     * - documentation: Value without tax | Hodnota bez daně
     * @var \StructType\Price_Type
     */
    public $ItemNetValue;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: Tax | Daň
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_Type[]
     */
    public $Tax;
    /**
     * The ItemGrossValue
     * Meta information extracted from the WSDL
     * - documentation: Value with tax | Hodnota s daní
     * - minOccurs: 0
     * @var \StructType\Price_Type
     */
    public $ItemGrossValue;
    /**
     * The NetValue
     * @var \StructType\Price_Type
     */
    public $NetValue;
    /**
     * The GrossValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Price_Type
     */
    public $GrossValue;
    /**
     * Constructor method for PricingDetail
     * @uses PricingDetail::setUnitPrice()
     * @uses PricingDetail::setItemNetValue()
     * @uses PricingDetail::setTax()
     * @uses PricingDetail::setItemGrossValue()
     * @uses PricingDetail::setNetValue()
     * @uses PricingDetail::setGrossValue()
     * @param \StructType\Price_Type $unitPrice
     * @param \StructType\Price_Type $itemNetValue
     * @param \StructType\Tax_Type[] $tax
     * @param \StructType\Price_Type $itemGrossValue
     * @param \StructType\Price_Type $netValue
     * @param \StructType\Price_Type $grossValue
     */
    public function __construct(\StructType\Price_Type $unitPrice = null, \StructType\Price_Type $itemNetValue = null, array $tax = array(), \StructType\Price_Type $itemGrossValue = null, \StructType\Price_Type $netValue = null, \StructType\Price_Type $grossValue = null)
    {
        $this
            ->setUnitPrice($unitPrice)
            ->setItemNetValue($itemNetValue)
            ->setTax($tax)
            ->setItemGrossValue($itemGrossValue)
            ->setNetValue($netValue)
            ->setGrossValue($grossValue);
    }
    /**
     * Get UnitPrice value
     * @return \StructType\Price_Type|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param \StructType\Price_Type $unitPrice
     * @return \StructType\PricingDetail
     */
    public function setUnitPrice(\StructType\Price_Type $unitPrice = null)
    {
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get ItemNetValue value
     * @return \StructType\Price_Type|null
     */
    public function getItemNetValue()
    {
        return $this->ItemNetValue;
    }
    /**
     * Set ItemNetValue value
     * @param \StructType\Price_Type $itemNetValue
     * @return \StructType\PricingDetail
     */
    public function setItemNetValue(\StructType\Price_Type $itemNetValue = null)
    {
        $this->ItemNetValue = $itemNetValue;
        return $this;
    }
    /**
     * Get Tax value
     * @return \StructType\Tax_Type[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingDetailTaxItem) {
            // validation for constraint: itemType
            if (!$pricingDetailTaxItem instanceof \StructType\Tax_Type) {
                $invalidValues[] = is_object($pricingDetailTaxItem) ? get_class($pricingDetailTaxItem) : sprintf('%s(%s)', gettype($pricingDetailTaxItem), var_export($pricingDetailTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type \StructType\Tax_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Type[] $tax
     * @return \StructType\PricingDetail
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Type $item
     * @return \StructType\PricingDetail
     */
    public function addToTax(\StructType\Tax_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_Type) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type \StructType\Tax_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get ItemGrossValue value
     * @return \StructType\Price_Type|null
     */
    public function getItemGrossValue()
    {
        return $this->ItemGrossValue;
    }
    /**
     * Set ItemGrossValue value
     * @param \StructType\Price_Type $itemGrossValue
     * @return \StructType\PricingDetail
     */
    public function setItemGrossValue(\StructType\Price_Type $itemGrossValue = null)
    {
        $this->ItemGrossValue = $itemGrossValue;
        return $this;
    }
    /**
     * Get NetValue value
     * @return \StructType\Price_Type|null
     */
    public function getNetValue()
    {
        return $this->NetValue;
    }
    /**
     * Set NetValue value
     * @param \StructType\Price_Type $netValue
     * @return \StructType\PricingDetail
     */
    public function setNetValue(\StructType\Price_Type $netValue = null)
    {
        $this->NetValue = $netValue;
        return $this;
    }
    /**
     * Get GrossValue value
     * @return \StructType\Price_Type|null
     */
    public function getGrossValue()
    {
        return $this->GrossValue;
    }
    /**
     * Set GrossValue value
     * @param \StructType\Price_Type $grossValue
     * @return \StructType\PricingDetail
     */
    public function setGrossValue(\StructType\Price_Type $grossValue = null)
    {
        $this->GrossValue = $grossValue;
        return $this;
    }
}
