<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PDTblock StructType
 * Meta information extracted from the WSDL
 * - documentation: Point of delivery / transfer data block | Blok dat odběrného / předávacího místa
 * @subpackage Structs
 */
class PDTblock extends AbstractStructBase
{
    /**
     * The PDT_id
     * Meta information extracted from the WSDL
     * - documentation: PDT identifier (EAN18) | ID OPM (EAN18) | Typ pro EAN 13 - 18 znaků | EAN 13 - 18 type
     * - base: xsd:string
     * - pattern: \d{13}(\d{5})?
     * - use: required
     * @var string
     */
    public $PDT_id;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $rate;
    /**
     * The DGI_id
     * Meta information extracted from the WSDL
     * - documentation: DGI id - msg id reference | DÚF ID - reference msg id | Typ pro číslo zprávy | Message number type
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $DGI_id;
    /**
     * The Address
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The ListOfBillingItems
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ListOfBillingItems[]
     */
    public $ListOfBillingItems;
    /**
     * The Party
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Party
     */
    public $Party;
    /**
     * The PDTblockNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $PDTblockNote;
    /**
     * The premise_id
     * @var string
     */
    public $premise_id;
    /**
     * Constructor method for PDTblock
     * @uses PDTblock::setPDT_id()
     * @uses PDTblock::setRate()
     * @uses PDTblock::setDGI_id()
     * @uses PDTblock::setAddress()
     * @uses PDTblock::setListOfBillingItems()
     * @uses PDTblock::setParty()
     * @uses PDTblock::setPDTblockNote()
     * @uses PDTblock::setPremise_id()
     * @param string $pDT_id
     * @param string $rate
     * @param string $dGI_id
     * @param \StructType\Address $address
     * @param \StructType\ListOfBillingItems[] $listOfBillingItems
     * @param \StructType\Party $party
     * @param mixed $pDTblockNote
     * @param string $premise_id
     */
    public function __construct($pDT_id = null, $rate = null, $dGI_id = null, \StructType\Address $address = null, array $listOfBillingItems = array(), \StructType\Party $party = null, $pDTblockNote = null, $premise_id = null)
    {
        $this
            ->setPDT_id($pDT_id)
            ->setRate($rate)
            ->setDGI_id($dGI_id)
            ->setAddress($address)
            ->setListOfBillingItems($listOfBillingItems)
            ->setParty($party)
            ->setPDTblockNote($pDTblockNote)
            ->setPremise_id($premise_id);
    }
    /**
     * Get PDT_id value
     * @return string
     */
    public function getPDT_id()
    {
        return $this->{'PDT-id'};
    }
    /**
     * Set PDT_id value
     * @param string $pDT_id
     * @return \StructType\PDTblock
     */
    public function setPDT_id($pDT_id = null)
    {
        // validation for constraint: string
        if (!is_null($pDT_id) && !is_string($pDT_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDT_id, true), gettype($pDT_id)), __LINE__);
        }
        // validation for constraint: pattern(\d{13}(\d{5})?)
        if (!is_null($pDT_id) && !preg_match('/\\d{13}(\\d{5})?/', $pDT_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{13}(\d{5})?', var_export($pDT_id, true)), __LINE__);
        }
        $this->PDT_id = $this->{'PDT-id'} = $pDT_id;
        return $this;
    }
    /**
     * Get rate value
     * @return string
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\PDTblock
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get DGI_id value
     * @return string
     */
    public function getDGI_id()
    {
        return $this->{'DGI-id'};
    }
    /**
     * Set DGI_id value
     * @param string $dGI_id
     * @return \StructType\PDTblock
     */
    public function setDGI_id($dGI_id = null)
    {
        // validation for constraint: string
        if (!is_null($dGI_id) && !is_string($dGI_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dGI_id, true), gettype($dGI_id)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($dGI_id) && mb_strlen($dGI_id) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($dGI_id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($dGI_id) && mb_strlen($dGI_id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($dGI_id)), __LINE__);
        }
        $this->DGI_id = $this->{'DGI-id'} = $dGI_id;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\PDTblock
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ListOfBillingItems value
     * @return \StructType\ListOfBillingItems[]|null
     */
    public function getListOfBillingItems()
    {
        return $this->ListOfBillingItems;
    }
    /**
     * This method is responsible for validating the values passed to the setListOfBillingItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListOfBillingItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListOfBillingItemsForArrayConstraintsFromSetListOfBillingItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pDTblockListOfBillingItemsItem) {
            // validation for constraint: itemType
            if (!$pDTblockListOfBillingItemsItem instanceof \StructType\ListOfBillingItems) {
                $invalidValues[] = is_object($pDTblockListOfBillingItemsItem) ? get_class($pDTblockListOfBillingItemsItem) : sprintf('%s(%s)', gettype($pDTblockListOfBillingItemsItem), var_export($pDTblockListOfBillingItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListOfBillingItems property can only contain items of type \StructType\ListOfBillingItems, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ListOfBillingItems value
     * @throws \InvalidArgumentException
     * @param \StructType\ListOfBillingItems[] $listOfBillingItems
     * @return \StructType\PDTblock
     */
    public function setListOfBillingItems(array $listOfBillingItems = array())
    {
        // validation for constraint: array
        if ('' !== ($listOfBillingItemsArrayErrorMessage = self::validateListOfBillingItemsForArrayConstraintsFromSetListOfBillingItems($listOfBillingItems))) {
            throw new \InvalidArgumentException($listOfBillingItemsArrayErrorMessage, __LINE__);
        }
        $this->ListOfBillingItems = $listOfBillingItems;
        return $this;
    }
    /**
     * Add item to ListOfBillingItems value
     * @throws \InvalidArgumentException
     * @param \StructType\ListOfBillingItems $item
     * @return \StructType\PDTblock
     */
    public function addToListOfBillingItems(\StructType\ListOfBillingItems $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ListOfBillingItems) {
            throw new \InvalidArgumentException(sprintf('The ListOfBillingItems property can only contain items of type \StructType\ListOfBillingItems, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ListOfBillingItems[] = $item;
        return $this;
    }
    /**
     * Get Party value
     * @return \StructType\Party|null
     */
    public function getParty()
    {
        return $this->Party;
    }
    /**
     * Set Party value
     * @param \StructType\Party $party
     * @return \StructType\PDTblock
     */
    public function setParty(\StructType\Party $party = null)
    {
        $this->Party = $party;
        return $this;
    }
    /**
     * Get PDTblockNote value
     * @return mixed|null
     */
    public function getPDTblockNote()
    {
        return $this->PDTblockNote;
    }
    /**
     * Set PDTblockNote value
     * @param mixed $pDTblockNote
     * @return \StructType\PDTblock
     */
    public function setPDTblockNote($pDTblockNote = null)
    {
        $this->PDTblockNote = $pDTblockNote;
        return $this;
    }
    /**
     * Get premise_id value
     * @return string|null
     */
    public function getPremise_id()
    {
        return $this->{'premise-id'};
    }
    /**
     * Set premise_id value
     * @param string $premise_id
     * @return \StructType\PDTblock
     */
    public function setPremise_id($premise_id = null)
    {
        // validation for constraint: string
        if (!is_null($premise_id) && !is_string($premise_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premise_id, true), gettype($premise_id)), __LINE__);
        }
        $this->premise_id = $this->{'premise-id'} = $premise_id;
        return $this;
    }
}
