<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentEnvelope StructType
 * Meta information extracted from the WSDL
 * - documentation: Group of documents | Skupina souvisejících dokladů
 * @subpackage Structs
 */
class DocumentEnvelope extends AbstractStructBase
{
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Document[]
     */
    public $Document;
    /**
     * Constructor method for DocumentEnvelope
     * @uses DocumentEnvelope::setDocument()
     * @param \StructType\Document[] $document
     */
    public function __construct(array $document = array())
    {
        $this
            ->setDocument($document);
    }
    /**
     * Get Document value
     * @return \StructType\Document[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentEnvelopeDocumentItem) {
            // validation for constraint: itemType
            if (!$documentEnvelopeDocumentItem instanceof \StructType\Document) {
                $invalidValues[] = is_object($documentEnvelopeDocumentItem) ? get_class($documentEnvelopeDocumentItem) : sprintf('%s(%s)', gettype($documentEnvelopeDocumentItem), var_export($documentEnvelopeDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \StructType\Document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \StructType\Document[] $document
     * @return \StructType\DocumentEnvelope
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \StructType\Document $item
     * @return \StructType\DocumentEnvelope
     */
    public function addToDocument(\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \StructType\Document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
}
