<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocDates StructType
 * Meta information extracted from the WSDL
 * - documentation: Document dates | Datumy dokladu
 * @subpackage Structs
 */
class DocDates extends AbstractStructBase
{
    /**
     * The due_date
     * Meta information extracted from the WSDL
     * - documentation: Due date | Datum splatnosti
     * - use: required
     * @var string
     */
    public $due_date;
    /**
     * The doc_issue_date
     * Meta information extracted from the WSDL
     * - documentation: Document date | Datum dokladu
     * - use: required
     * @var string
     */
    public $doc_issue_date;
    /**
     * The tax_point_date
     * Meta information extracted from the WSDL
     * - documentation: Tax date | Datum zdanitelného plnění
     * - use: required
     * @var string
     */
    public $tax_point_date;
    /**
     * The invoicing_period_start
     * Meta information extracted from the WSDL
     * - documentation: Start of invoicing period | Začátek fakturačního období
     * @var string
     */
    public $invoicing_period_start;
    /**
     * The invoicing_period_end
     * Meta information extracted from the WSDL
     * - documentation: End of invoicing period | Konec fakturačního období
     * @var string
     */
    public $invoicing_period_end;
    /**
     * Constructor method for DocDates
     * @uses DocDates::setDue_date()
     * @uses DocDates::setDoc_issue_date()
     * @uses DocDates::setTax_point_date()
     * @uses DocDates::setInvoicing_period_start()
     * @uses DocDates::setInvoicing_period_end()
     * @param string $due_date
     * @param string $doc_issue_date
     * @param string $tax_point_date
     * @param string $invoicing_period_start
     * @param string $invoicing_period_end
     */
    public function __construct($due_date = null, $doc_issue_date = null, $tax_point_date = null, $invoicing_period_start = null, $invoicing_period_end = null)
    {
        $this
            ->setDue_date($due_date)
            ->setDoc_issue_date($doc_issue_date)
            ->setTax_point_date($tax_point_date)
            ->setInvoicing_period_start($invoicing_period_start)
            ->setInvoicing_period_end($invoicing_period_end);
    }
    /**
     * Get due_date value
     * @return string
     */
    public function getDue_date()
    {
        return $this->{'due-date'};
    }
    /**
     * Set due_date value
     * @param string $due_date
     * @return \StructType\DocDates
     */
    public function setDue_date($due_date = null)
    {
        // validation for constraint: string
        if (!is_null($due_date) && !is_string($due_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_date, true), gettype($due_date)), __LINE__);
        }
        $this->due_date = $this->{'due-date'} = $due_date;
        return $this;
    }
    /**
     * Get doc_issue_date value
     * @return string
     */
    public function getDoc_issue_date()
    {
        return $this->{'doc-issue-date'};
    }
    /**
     * Set doc_issue_date value
     * @param string $doc_issue_date
     * @return \StructType\DocDates
     */
    public function setDoc_issue_date($doc_issue_date = null)
    {
        // validation for constraint: string
        if (!is_null($doc_issue_date) && !is_string($doc_issue_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_issue_date, true), gettype($doc_issue_date)), __LINE__);
        }
        $this->doc_issue_date = $this->{'doc-issue-date'} = $doc_issue_date;
        return $this;
    }
    /**
     * Get tax_point_date value
     * @return string
     */
    public function getTax_point_date()
    {
        return $this->{'tax-point-date'};
    }
    /**
     * Set tax_point_date value
     * @param string $tax_point_date
     * @return \StructType\DocDates
     */
    public function setTax_point_date($tax_point_date = null)
    {
        // validation for constraint: string
        if (!is_null($tax_point_date) && !is_string($tax_point_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax_point_date, true), gettype($tax_point_date)), __LINE__);
        }
        $this->tax_point_date = $this->{'tax-point-date'} = $tax_point_date;
        return $this;
    }
    /**
     * Get invoicing_period_start value
     * @return string|null
     */
    public function getInvoicing_period_start()
    {
        return $this->{'invoicing-period-start'};
    }
    /**
     * Set invoicing_period_start value
     * @param string $invoicing_period_start
     * @return \StructType\DocDates
     */
    public function setInvoicing_period_start($invoicing_period_start = null)
    {
        // validation for constraint: string
        if (!is_null($invoicing_period_start) && !is_string($invoicing_period_start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicing_period_start, true), gettype($invoicing_period_start)), __LINE__);
        }
        $this->invoicing_period_start = $this->{'invoicing-period-start'} = $invoicing_period_start;
        return $this;
    }
    /**
     * Get invoicing_period_end value
     * @return string|null
     */
    public function getInvoicing_period_end()
    {
        return $this->{'invoicing-period-end'};
    }
    /**
     * Set invoicing_period_end value
     * @param string $invoicing_period_end
     * @return \StructType\DocDates
     */
    public function setInvoicing_period_end($invoicing_period_end = null)
    {
        // validation for constraint: string
        if (!is_null($invoicing_period_end) && !is_string($invoicing_period_end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicing_period_end, true), gettype($invoicing_period_end)), __LINE__);
        }
        $this->invoicing_period_end = $this->{'invoicing-period-end'} = $invoicing_period_end;
        return $this;
    }
}
