<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataMO StructType
 * Meta information extracted from the WSDL
 * - documentation: Data of PDT for DGI RCS | Data OPM pro DUF MO
 * @subpackage Structs
 */
class DataMO extends AbstractStructBase
{
    /**
     * The am_enVT
     * Meta information extracted from the WSDL
     * - documentation: Payment for PDT - HT | Platba za OPM VT | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $am_enVT;
    /**
     * The am_rescap
     * Meta information extracted from the WSDL
     * - documentation: Total payment for reserved capacity in Kč excluding VAT (circuit breaker) | Celková platba za rezervovanou kapacitu v Kč bez DPH (jistič) | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number -
     * max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $am_rescap;
    /**
     * The am_renresource
     * Meta information extracted from the WSDL
     * - documentation: Renewable resources payment (Kč) | Platba za obnovitelné zdroje (Kč) | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $am_renresource;
    /**
     * The am_distservice
     * Meta information extracted from the WSDL
     * - documentation: Total payment for distribution [Kč excluding VAT] | Celková platba za distribuci[Kč bez DPH] | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $am_distservice;
    /**
     * The am_sysservice
     * Meta information extracted from the WSDL
     * - documentation: System services payment [Kč excluding VAT] | Platba za systémové služby[Kč bez DPH] | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $am_sysservice;
    /**
     * The am_oteservice
     * Meta information extracted from the WSDL
     * - documentation: Decimal number - max. 2 decimal places (not an exponential form) | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar)
     * - base: qty_type_2
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $am_oteservice;
    /**
     * The am_mrdservice
     * Meta information extracted from the WSDL
     * - documentation: Meter reading payment [Kč excluding VAT] | Poplatek za odečet [Kč bez DPH] | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $am_mrdservice;
    /**
     * The inv_id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - use: optional
     * @var string
     */
    public $inv_id;
    /**
     * The qty_VT
     * Meta information extracted from the WSDL
     * - documentation: Sum of energy in HT [kWh] (use to 31.12.2015) | Suma práce ve VT [kWh] (používané do 31.12.2015) | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential
     * form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $qty_VT;
    /**
     * The qty_NT
     * Meta information extracted from the WSDL
     * - documentation: Sum of energy in LT [kWh] (use to 31.12.2015) | Suma práce ve NT [kWh] (používané do 31.12.2015) | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential
     * form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $qty_NT;
    /**
     * The cir_breaker
     * Meta information extracted from the WSDL
     * - documentation: Main circuit breaker value [A], since 2016 not used | Hodnota hlavního jističe [A], od 2016 nepoužívané | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an
     * exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $cir_breaker;
    /**
     * The am_enNT
     * Meta information extracted from the WSDL
     * - documentation: Payment for PDT - LT, since 2016 required | Platba za OPM NT, od 2016 povinný | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $am_enNT;
    /**
     * The am_comresource
     * Meta information extracted from the WSDL
     * - documentation: Combined heat generation payment (Kč) | Platba za kombinovanou výrobu tepla (Kč) | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $am_comresource;
    /**
     * The num_phase
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $num_phase;
    /**
     * The qty_prod
     * Meta information extracted from the WSDL
     * - documentation: Production [kWh] | Výroba [kWh] | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $qty_prod;
    /**
     * Constructor method for DataMO
     * @uses DataMO::setAm_enVT()
     * @uses DataMO::setAm_rescap()
     * @uses DataMO::setAm_renresource()
     * @uses DataMO::setAm_distservice()
     * @uses DataMO::setAm_sysservice()
     * @uses DataMO::setAm_oteservice()
     * @uses DataMO::setAm_mrdservice()
     * @uses DataMO::setInv_id()
     * @uses DataMO::setQty_VT()
     * @uses DataMO::setQty_NT()
     * @uses DataMO::setCir_breaker()
     * @uses DataMO::setAm_enNT()
     * @uses DataMO::setAm_comresource()
     * @uses DataMO::setNum_phase()
     * @uses DataMO::setQty_prod()
     * @param string $am_enVT
     * @param string $am_rescap
     * @param string $am_renresource
     * @param string $am_distservice
     * @param string $am_sysservice
     * @param string $am_oteservice
     * @param string $am_mrdservice
     * @param string $inv_id
     * @param string $qty_VT
     * @param string $qty_NT
     * @param string $cir_breaker
     * @param string $am_enNT
     * @param string $am_comresource
     * @param string $num_phase
     * @param string $qty_prod
     */
    public function __construct($am_enVT = null, $am_rescap = null, $am_renresource = null, $am_distservice = null, $am_sysservice = null, $am_oteservice = null, $am_mrdservice = null, $inv_id = null, $qty_VT = null, $qty_NT = null, $cir_breaker = null, $am_enNT = null, $am_comresource = null, $num_phase = null, $qty_prod = null)
    {
        $this
            ->setAm_enVT($am_enVT)
            ->setAm_rescap($am_rescap)
            ->setAm_renresource($am_renresource)
            ->setAm_distservice($am_distservice)
            ->setAm_sysservice($am_sysservice)
            ->setAm_oteservice($am_oteservice)
            ->setAm_mrdservice($am_mrdservice)
            ->setInv_id($inv_id)
            ->setQty_VT($qty_VT)
            ->setQty_NT($qty_NT)
            ->setCir_breaker($cir_breaker)
            ->setAm_enNT($am_enNT)
            ->setAm_comresource($am_comresource)
            ->setNum_phase($num_phase)
            ->setQty_prod($qty_prod);
    }
    /**
     * Get am_enVT value
     * @return string
     */
    public function getAm_enVT()
    {
        return $this->{'am-enVT'};
    }
    /**
     * Set am_enVT value
     * @param string $am_enVT
     * @return \StructType\DataMO
     */
    public function setAm_enVT($am_enVT = null)
    {
        // validation for constraint: string
        if (!is_null($am_enVT) && !is_string($am_enVT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($am_enVT, true), gettype($am_enVT)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($am_enVT) && mb_strlen($am_enVT) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($am_enVT)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($am_enVT) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $am_enVT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($am_enVT, true)), __LINE__);
        }
        $this->am_enVT = $this->{'am-enVT'} = $am_enVT;
        return $this;
    }
    /**
     * Get am_rescap value
     * @return string
     */
    public function getAm_rescap()
    {
        return $this->{'am-rescap'};
    }
    /**
     * Set am_rescap value
     * @param string $am_rescap
     * @return \StructType\DataMO
     */
    public function setAm_rescap($am_rescap = null)
    {
        // validation for constraint: string
        if (!is_null($am_rescap) && !is_string($am_rescap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($am_rescap, true), gettype($am_rescap)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($am_rescap) && mb_strlen($am_rescap) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($am_rescap)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($am_rescap) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $am_rescap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($am_rescap, true)), __LINE__);
        }
        $this->am_rescap = $this->{'am-rescap'} = $am_rescap;
        return $this;
    }
    /**
     * Get am_renresource value
     * @return string
     */
    public function getAm_renresource()
    {
        return $this->{'am-renresource'};
    }
    /**
     * Set am_renresource value
     * @param string $am_renresource
     * @return \StructType\DataMO
     */
    public function setAm_renresource($am_renresource = null)
    {
        // validation for constraint: string
        if (!is_null($am_renresource) && !is_string($am_renresource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($am_renresource, true), gettype($am_renresource)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($am_renresource) && mb_strlen($am_renresource) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($am_renresource)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($am_renresource) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $am_renresource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($am_renresource, true)), __LINE__);
        }
        $this->am_renresource = $this->{'am-renresource'} = $am_renresource;
        return $this;
    }
    /**
     * Get am_distservice value
     * @return string
     */
    public function getAm_distservice()
    {
        return $this->{'am-distservice'};
    }
    /**
     * Set am_distservice value
     * @param string $am_distservice
     * @return \StructType\DataMO
     */
    public function setAm_distservice($am_distservice = null)
    {
        // validation for constraint: string
        if (!is_null($am_distservice) && !is_string($am_distservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($am_distservice, true), gettype($am_distservice)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($am_distservice) && mb_strlen($am_distservice) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($am_distservice)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($am_distservice) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $am_distservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($am_distservice, true)), __LINE__);
        }
        $this->am_distservice = $this->{'am-distservice'} = $am_distservice;
        return $this;
    }
    /**
     * Get am_sysservice value
     * @return string
     */
    public function getAm_sysservice()
    {
        return $this->{'am-sysservice'};
    }
    /**
     * Set am_sysservice value
     * @param string $am_sysservice
     * @return \StructType\DataMO
     */
    public function setAm_sysservice($am_sysservice = null)
    {
        // validation for constraint: string
        if (!is_null($am_sysservice) && !is_string($am_sysservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($am_sysservice, true), gettype($am_sysservice)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($am_sysservice) && mb_strlen($am_sysservice) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($am_sysservice)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($am_sysservice) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $am_sysservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($am_sysservice, true)), __LINE__);
        }
        $this->am_sysservice = $this->{'am-sysservice'} = $am_sysservice;
        return $this;
    }
    /**
     * Get am_oteservice value
     * @return string
     */
    public function getAm_oteservice()
    {
        return $this->{'am-oteservice'};
    }
    /**
     * Set am_oteservice value
     * @param string $am_oteservice
     * @return \StructType\DataMO
     */
    public function setAm_oteservice($am_oteservice = null)
    {
        // validation for constraint: string
        if (!is_null($am_oteservice) && !is_string($am_oteservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($am_oteservice, true), gettype($am_oteservice)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($am_oteservice) && mb_strlen($am_oteservice) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($am_oteservice)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($am_oteservice) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $am_oteservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($am_oteservice, true)), __LINE__);
        }
        $this->am_oteservice = $this->{'am-oteservice'} = $am_oteservice;
        return $this;
    }
    /**
     * Get am_mrdservice value
     * @return string
     */
    public function getAm_mrdservice()
    {
        return $this->{'am-mrdservice'};
    }
    /**
     * Set am_mrdservice value
     * @param string $am_mrdservice
     * @return \StructType\DataMO
     */
    public function setAm_mrdservice($am_mrdservice = null)
    {
        // validation for constraint: string
        if (!is_null($am_mrdservice) && !is_string($am_mrdservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($am_mrdservice, true), gettype($am_mrdservice)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($am_mrdservice) && mb_strlen($am_mrdservice) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($am_mrdservice)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($am_mrdservice) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $am_mrdservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($am_mrdservice, true)), __LINE__);
        }
        $this->am_mrdservice = $this->{'am-mrdservice'} = $am_mrdservice;
        return $this;
    }
    /**
     * Get inv_id value
     * @return string|null
     */
    public function getInv_id()
    {
        return $this->inv_id;
    }
    /**
     * Set inv_id value
     * @param string $inv_id
     * @return \StructType\DataMO
     */
    public function setInv_id($inv_id = null)
    {
        // validation for constraint: string
        if (!is_null($inv_id) && !is_string($inv_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_id, true), gettype($inv_id)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($inv_id) && mb_strlen($inv_id) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($inv_id)), __LINE__);
        }
        $this->inv_id = $inv_id;
        return $this;
    }
    /**
     * Get qty_VT value
     * @return string|null
     */
    public function getQty_VT()
    {
        return $this->{'qty-VT'};
    }
    /**
     * Set qty_VT value
     * @param string $qty_VT
     * @return \StructType\DataMO
     */
    public function setQty_VT($qty_VT = null)
    {
        // validation for constraint: string
        if (!is_null($qty_VT) && !is_string($qty_VT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty_VT, true), gettype($qty_VT)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qty_VT) && mb_strlen($qty_VT) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qty_VT)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($qty_VT) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $qty_VT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($qty_VT, true)), __LINE__);
        }
        $this->qty_VT = $this->{'qty-VT'} = $qty_VT;
        return $this;
    }
    /**
     * Get qty_NT value
     * @return string|null
     */
    public function getQty_NT()
    {
        return $this->{'qty-NT'};
    }
    /**
     * Set qty_NT value
     * @param string $qty_NT
     * @return \StructType\DataMO
     */
    public function setQty_NT($qty_NT = null)
    {
        // validation for constraint: string
        if (!is_null($qty_NT) && !is_string($qty_NT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty_NT, true), gettype($qty_NT)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qty_NT) && mb_strlen($qty_NT) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qty_NT)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($qty_NT) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $qty_NT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($qty_NT, true)), __LINE__);
        }
        $this->qty_NT = $this->{'qty-NT'} = $qty_NT;
        return $this;
    }
    /**
     * Get cir_breaker value
     * @return string|null
     */
    public function getCir_breaker()
    {
        return $this->{'cir-breaker'};
    }
    /**
     * Set cir_breaker value
     * @param string $cir_breaker
     * @return \StructType\DataMO
     */
    public function setCir_breaker($cir_breaker = null)
    {
        // validation for constraint: string
        if (!is_null($cir_breaker) && !is_string($cir_breaker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cir_breaker, true), gettype($cir_breaker)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($cir_breaker) && mb_strlen($cir_breaker) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($cir_breaker)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($cir_breaker) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $cir_breaker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($cir_breaker, true)), __LINE__);
        }
        $this->cir_breaker = $this->{'cir-breaker'} = $cir_breaker;
        return $this;
    }
    /**
     * Get am_enNT value
     * @return string|null
     */
    public function getAm_enNT()
    {
        return $this->{'am-enNT'};
    }
    /**
     * Set am_enNT value
     * @param string $am_enNT
     * @return \StructType\DataMO
     */
    public function setAm_enNT($am_enNT = null)
    {
        // validation for constraint: string
        if (!is_null($am_enNT) && !is_string($am_enNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($am_enNT, true), gettype($am_enNT)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($am_enNT) && mb_strlen($am_enNT) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($am_enNT)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($am_enNT) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $am_enNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($am_enNT, true)), __LINE__);
        }
        $this->am_enNT = $this->{'am-enNT'} = $am_enNT;
        return $this;
    }
    /**
     * Get am_comresource value
     * @return string|null
     */
    public function getAm_comresource()
    {
        return $this->{'am-comresource'};
    }
    /**
     * Set am_comresource value
     * @param string $am_comresource
     * @return \StructType\DataMO
     */
    public function setAm_comresource($am_comresource = null)
    {
        // validation for constraint: string
        if (!is_null($am_comresource) && !is_string($am_comresource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($am_comresource, true), gettype($am_comresource)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($am_comresource) && mb_strlen($am_comresource) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($am_comresource)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($am_comresource) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $am_comresource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($am_comresource, true)), __LINE__);
        }
        $this->am_comresource = $this->{'am-comresource'} = $am_comresource;
        return $this;
    }
    /**
     * Get num_phase value
     * @return string|null
     */
    public function getNum_phase()
    {
        return $this->{'num-phase'};
    }
    /**
     * Set num_phase value
     * @param string $num_phase
     * @return \StructType\DataMO
     */
    public function setNum_phase($num_phase = null)
    {
        // validation for constraint: string
        if (!is_null($num_phase) && !is_string($num_phase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($num_phase, true), gettype($num_phase)), __LINE__);
        }
        $this->num_phase = $this->{'num-phase'} = $num_phase;
        return $this;
    }
    /**
     * Get qty_prod value
     * @return string|null
     */
    public function getQty_prod()
    {
        return $this->{'qty-prod'};
    }
    /**
     * Set qty_prod value
     * @param string $qty_prod
     * @return \StructType\DataMO
     */
    public function setQty_prod($qty_prod = null)
    {
        // validation for constraint: string
        if (!is_null($qty_prod) && !is_string($qty_prod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty_prod, true), gettype($qty_prod)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qty_prod) && mb_strlen($qty_prod) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qty_prod)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($qty_prod) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $qty_prod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($qty_prod, true)), __LINE__);
        }
        $this->qty_prod = $this->{'qty-prod'} = $qty_prod;
        return $this;
    }
}
