<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Data StructType
 * Meta information extracted from the WSDL
 * - documentation: Locality | Měsíční výkaz - LDS | Data for profile and time interval | Data pro profil a časový interval | PDT data | Data o OPM | Locality and time interval data | Data pro lokalitu a časový interval
 * @subpackage Structs
 */
class Data extends AbstractStructBase
{
    /**
     * The date_time_from
     * Meta information extracted from the WSDL
     * - documentation: Beginning of data validity | Počátek platnosti dat
     * - use: required
     * @var string
     */
    public $date_time_from;
    /**
     * The date_time_to
     * Meta information extracted from the WSDL
     * - documentation: End of data validity | Konec platnosti dat
     * - use: required
     * @var string
     */
    public $date_time_to;
    /**
     * The qty
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: -?\d+(\.\d)?
     * - use: required
     * @var string
     */
    public $qty;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - use: required
     * @var string
     */
    public $unit;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $status;
    /**
     * The start_date
     * Meta information extracted from the WSDL
     * - documentation: Beginning of data validity | Počátek platnosti dat
     * - use: required
     * @var string
     */
    public $start_date;
    /**
     * The end_date
     * Meta information extracted from the WSDL
     * - documentation: End of data validity | Konec platnosti dat
     * - use: required
     * @var string
     */
    public $end_date;
    /**
     * The Workflow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Workflow
     */
    public $Workflow;
    /**
     * The Party
     * Meta information extracted from the WSDL
     * - maxOccurs: 14
     * - minOccurs: 0
     * @var \StructType\Party[]
     */
    public $Party;
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Response
     */
    public $Response;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Activity[]
     */
    public $Activity;
    /**
     * The opm_id
     * Meta information extracted from the WSDL
     * - documentation: EAN18 - PDT identification | EAN18 - identifikace OPM | Typ pro OPM (EAN, EIC) | POD type (EAN, EIC)
     * - base: xsd:string
     * - maxLength: 18
     * - minLength: 16
     * - pattern: \d{18}
     * - use: optional
     * @var string
     */
    public $opm_id;
    /**
     * The prepared
     * Meta information extracted from the WSDL
     * - documentation: EAN 13 - ID of subject, who prepared the data | EAN13 - id toho, kdo připravil data | EAN type | Typ pro EAN | Typ pro EAN 13 znaků | EAN 13 type
     * - base: ean
     * - length: 13
     * - pattern: \d+
     * @var string
     */
    public $prepared;
    /**
     * The prev_rejection_date
     * Meta information extracted from the WSDL
     * - documentation: Previous rejection date | Datum původního zamítnutí požadavku
     * - use: optional
     * @var string
     */
    public $prev_rejection_date;
    /**
     * The process_status
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $process_status;
    /**
     * The reg_needed
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $reg_needed;
    /**
     * The real_diag
     * Meta information extracted from the WSDL
     * - documentation: Sending negotiated diagrams (for imbalace responsibility transfer) | Zasílání realizačních diagrmů (pro předání odpovědnosti za odchylky)
     * @var bool
     */
    public $real_diag;
    /**
     * The clearing
     * Meta information extracted from the WSDL
     * - documentation: Zúčtování rozdílů (for imbalace responsibility transfer) | Zúčtování rozdílů (pro předání odpovědnosti za odchylky)
     * @var bool
     */
    public $clearing;
    /**
     * The chs_type
     * @var string
     */
    public $chs_type;
    /**
     * The contract_type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $contract_type;
    /**
     * The rejection_reason
     * @var string
     */
    public $rejection_reason;
    /**
     * The chs_reason
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $chs_reason;
    /**
     * The contract_negotiation_type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $contract_negotiation_type;
    /**
     * The multiple_mp
     * Meta information extracted from the WSDL
     * - documentation: More transfer point | Více předávacích míst
     * - use: optional
     * @var bool
     */
    public $multiple_mp;
    /**
     * The Row
     * Meta information extracted from the WSDL
     * - documentation: Report row | Řádek výkazu (výkazy za rok 2016 a dále)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Row_type[]
     */
    public $Row;
    /**
     * The grid_id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $grid_id;
    /**
     * The val_year
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 4
     * @var string
     */
    public $val_year;
    /**
     * The val_month
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 2
     * @var string
     */
    public $val_month;
    /**
     * The rep_type
     * @var string
     */
    public $rep_type;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4
     * @var string
     */
    public $version;
    /**
     * The v1_ds_cons
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * @var string
     */
    public $v1_ds_cons;
    /**
     * The v2_ds_supply
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * @var string
     */
    public $v2_ds_supply;
    /**
     * The v3_prod_prod
     * @var string
     */
    public $v3_prod_prod;
    /**
     * The v4_prod_cons
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * @var string
     */
    public $v4_prod_cons;
    /**
     * The v5_end_cons
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * @var string
     */
    public $v5_end_cons;
    /**
     * The v6_local_cons
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * @var string
     */
    public $v6_local_cons;
    /**
     * The v7_tot_lds_cons
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * @var string
     */
    public $v7_tot_lds_cons;
    /**
     * The v8_tot_loc_cons
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * @var string
     */
    public $v8_tot_loc_cons;
    /**
     * The v9_loss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * @var string
     */
    public $v9_loss;
    /**
     * The v10_pdt
     * Meta information extracted from the WSDL
     * - documentation: Označení předávacího místa podle smlouvy o připojení k nadřazené soustavě | EAN type | Typ pro EAN | Typ pro EAN 18 znaků | EAN 18 type
     * - base: ean
     * - length: 18
     * - pattern: \d+
     * @var string
     */
    public $v10_pdt;
    /**
     * The v11_voltage
     * Meta information extracted from the WSDL
     * - documentation: Napětí v předávacím místě s nadřazenou soustavou (výkazy za rok 2015 a dříve)
     * @var string
     */
    public $v11_voltage;
    /**
     * Constructor method for Data
     * @uses Data::setDate_time_from()
     * @uses Data::setDate_time_to()
     * @uses Data::setQty()
     * @uses Data::setUnit()
     * @uses Data::setStatus()
     * @uses Data::setStart_date()
     * @uses Data::setEnd_date()
     * @uses Data::setWorkflow()
     * @uses Data::setParty()
     * @uses Data::setResponse()
     * @uses Data::setActivity()
     * @uses Data::setOpm_id()
     * @uses Data::setPrepared()
     * @uses Data::setPrev_rejection_date()
     * @uses Data::setProcess_status()
     * @uses Data::setReg_needed()
     * @uses Data::setReal_diag()
     * @uses Data::setClearing()
     * @uses Data::setChs_type()
     * @uses Data::setContract_type()
     * @uses Data::setRejection_reason()
     * @uses Data::setChs_reason()
     * @uses Data::setContract_negotiation_type()
     * @uses Data::setMultiple_mp()
     * @uses Data::setRow()
     * @uses Data::setGrid_id()
     * @uses Data::setVal_year()
     * @uses Data::setVal_month()
     * @uses Data::setRep_type()
     * @uses Data::setVersion()
     * @uses Data::setV1_ds_cons()
     * @uses Data::setV2_ds_supply()
     * @uses Data::setV3_prod_prod()
     * @uses Data::setV4_prod_cons()
     * @uses Data::setV5_end_cons()
     * @uses Data::setV6_local_cons()
     * @uses Data::setV7_tot_lds_cons()
     * @uses Data::setV8_tot_loc_cons()
     * @uses Data::setV9_loss()
     * @uses Data::setV10_pdt()
     * @uses Data::setV11_voltage()
     * @param string $date_time_from
     * @param string $date_time_to
     * @param string $qty
     * @param string $unit
     * @param string $status
     * @param string $start_date
     * @param string $end_date
     * @param \StructType\Workflow $workflow
     * @param \StructType\Party[] $party
     * @param \StructType\Response $response
     * @param \StructType\Activity[] $activity
     * @param string $opm_id
     * @param string $prepared
     * @param string $prev_rejection_date
     * @param string $process_status
     * @param string $reg_needed
     * @param bool $real_diag
     * @param bool $clearing
     * @param string $chs_type
     * @param string $contract_type
     * @param string $rejection_reason
     * @param string $chs_reason
     * @param string $contract_negotiation_type
     * @param bool $multiple_mp
     * @param \StructType\Row_type[] $row
     * @param string $grid_id
     * @param string $val_year
     * @param string $val_month
     * @param string $rep_type
     * @param string $version
     * @param string $v1_ds_cons
     * @param string $v2_ds_supply
     * @param string $v3_prod_prod
     * @param string $v4_prod_cons
     * @param string $v5_end_cons
     * @param string $v6_local_cons
     * @param string $v7_tot_lds_cons
     * @param string $v8_tot_loc_cons
     * @param string $v9_loss
     * @param string $v10_pdt
     * @param string $v11_voltage
     */
    public function __construct($date_time_from = null, $date_time_to = null, $qty = null, $unit = null, $status = null, $start_date = null, $end_date = null, \StructType\Workflow $workflow = null, array $party = array(), \StructType\Response $response = null, array $activity = array(), $opm_id = null, $prepared = null, $prev_rejection_date = null, $process_status = null, $reg_needed = null, $real_diag = null, $clearing = null, $chs_type = null, $contract_type = null, $rejection_reason = null, $chs_reason = null, $contract_negotiation_type = null, $multiple_mp = null, array $row = array(), $grid_id = null, $val_year = null, $val_month = null, $rep_type = null, $version = null, $v1_ds_cons = null, $v2_ds_supply = null, $v3_prod_prod = null, $v4_prod_cons = null, $v5_end_cons = null, $v6_local_cons = null, $v7_tot_lds_cons = null, $v8_tot_loc_cons = null, $v9_loss = null, $v10_pdt = null, $v11_voltage = null)
    {
        $this
            ->setDate_time_from($date_time_from)
            ->setDate_time_to($date_time_to)
            ->setQty($qty)
            ->setUnit($unit)
            ->setStatus($status)
            ->setStart_date($start_date)
            ->setEnd_date($end_date)
            ->setWorkflow($workflow)
            ->setParty($party)
            ->setResponse($response)
            ->setActivity($activity)
            ->setOpm_id($opm_id)
            ->setPrepared($prepared)
            ->setPrev_rejection_date($prev_rejection_date)
            ->setProcess_status($process_status)
            ->setReg_needed($reg_needed)
            ->setReal_diag($real_diag)
            ->setClearing($clearing)
            ->setChs_type($chs_type)
            ->setContract_type($contract_type)
            ->setRejection_reason($rejection_reason)
            ->setChs_reason($chs_reason)
            ->setContract_negotiation_type($contract_negotiation_type)
            ->setMultiple_mp($multiple_mp)
            ->setRow($row)
            ->setGrid_id($grid_id)
            ->setVal_year($val_year)
            ->setVal_month($val_month)
            ->setRep_type($rep_type)
            ->setVersion($version)
            ->setV1_ds_cons($v1_ds_cons)
            ->setV2_ds_supply($v2_ds_supply)
            ->setV3_prod_prod($v3_prod_prod)
            ->setV4_prod_cons($v4_prod_cons)
            ->setV5_end_cons($v5_end_cons)
            ->setV6_local_cons($v6_local_cons)
            ->setV7_tot_lds_cons($v7_tot_lds_cons)
            ->setV8_tot_loc_cons($v8_tot_loc_cons)
            ->setV9_loss($v9_loss)
            ->setV10_pdt($v10_pdt)
            ->setV11_voltage($v11_voltage);
    }
    /**
     * Get date_time_from value
     * @return string
     */
    public function getDate_time_from()
    {
        return $this->{'date-time-from'};
    }
    /**
     * Set date_time_from value
     * @param string $date_time_from
     * @return \StructType\Data
     */
    public function setDate_time_from($date_time_from = null)
    {
        // validation for constraint: string
        if (!is_null($date_time_from) && !is_string($date_time_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time_from, true), gettype($date_time_from)), __LINE__);
        }
        $this->date_time_from = $this->{'date-time-from'} = $date_time_from;
        return $this;
    }
    /**
     * Get date_time_to value
     * @return string
     */
    public function getDate_time_to()
    {
        return $this->{'date-time-to'};
    }
    /**
     * Set date_time_to value
     * @param string $date_time_to
     * @return \StructType\Data
     */
    public function setDate_time_to($date_time_to = null)
    {
        // validation for constraint: string
        if (!is_null($date_time_to) && !is_string($date_time_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time_to, true), gettype($date_time_to)), __LINE__);
        }
        $this->date_time_to = $this->{'date-time-to'} = $date_time_to;
        return $this;
    }
    /**
     * Get qty value
     * @return string
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param string $qty
     * @return \StructType\Data
     */
    public function setQty($qty = null)
    {
        // validation for constraint: string
        if (!is_null($qty) && !is_string($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d)?)
        if (!is_null($qty) && !preg_match('/-?\\d+(\\.\\d)?/', $qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d)?', var_export($qty, true)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
    /**
     * Get unit value
     * @return string
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param string $unit
     * @return \StructType\Data
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unit, true), gettype($unit)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($unit) && mb_strlen($unit) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($unit)), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Data
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get start_date value
     * @return string
     */
    public function getStart_date()
    {
        return $this->{'start-date'};
    }
    /**
     * Set start_date value
     * @param string $start_date
     * @return \StructType\Data
     */
    public function setStart_date($start_date = null)
    {
        // validation for constraint: string
        if (!is_null($start_date) && !is_string($start_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_date, true), gettype($start_date)), __LINE__);
        }
        $this->start_date = $this->{'start-date'} = $start_date;
        return $this;
    }
    /**
     * Get end_date value
     * @return string
     */
    public function getEnd_date()
    {
        return $this->{'end-date'};
    }
    /**
     * Set end_date value
     * @param string $end_date
     * @return \StructType\Data
     */
    public function setEnd_date($end_date = null)
    {
        // validation for constraint: string
        if (!is_null($end_date) && !is_string($end_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_date, true), gettype($end_date)), __LINE__);
        }
        $this->end_date = $this->{'end-date'} = $end_date;
        return $this;
    }
    /**
     * Get Workflow value
     * @return \StructType\Workflow|null
     */
    public function getWorkflow()
    {
        return $this->Workflow;
    }
    /**
     * Set Workflow value
     * @param \StructType\Workflow $workflow
     * @return \StructType\Data
     */
    public function setWorkflow(\StructType\Workflow $workflow = null)
    {
        $this->Workflow = $workflow;
        return $this;
    }
    /**
     * Get Party value
     * @return \StructType\Party[]|null
     */
    public function getParty()
    {
        return $this->Party;
    }
    /**
     * This method is responsible for validating the values passed to the setParty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyForArrayConstraintsFromSetParty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dataPartyItem) {
            // validation for constraint: itemType
            if (!$dataPartyItem instanceof \StructType\Party) {
                $invalidValues[] = is_object($dataPartyItem) ? get_class($dataPartyItem) : sprintf('%s(%s)', gettype($dataPartyItem), var_export($dataPartyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Party property can only contain items of type \StructType\Party, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Party value
     * @throws \InvalidArgumentException
     * @param \StructType\Party[] $party
     * @return \StructType\Data
     */
    public function setParty(array $party = array())
    {
        // validation for constraint: array
        if ('' !== ($partyArrayErrorMessage = self::validatePartyForArrayConstraintsFromSetParty($party))) {
            throw new \InvalidArgumentException($partyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(14)
        if (is_array($party) && count($party) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 14', count($party)), __LINE__);
        }
        $this->Party = $party;
        return $this;
    }
    /**
     * Add item to Party value
     * @throws \InvalidArgumentException
     * @param \StructType\Party $item
     * @return \StructType\Data
     */
    public function addToParty(\StructType\Party $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Party) {
            throw new \InvalidArgumentException(sprintf('The Party property can only contain items of type \StructType\Party, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(14)
        if (is_array($this->Party) && count($this->Party) >= 14) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 14', count($this->Party)), __LINE__);
        }
        $this->Party[] = $item;
        return $this;
    }
    /**
     * Get Response value
     * @return \StructType\Response|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param \StructType\Response $response
     * @return \StructType\Data
     */
    public function setResponse(\StructType\Response $response = null)
    {
        $this->Response = $response;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity[]|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * This method is responsible for validating the values passed to the setActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityForArrayConstraintsFromSetActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dataActivityItem) {
            // validation for constraint: itemType
            if (!$dataActivityItem instanceof \StructType\Activity) {
                $invalidValues[] = is_object($dataActivityItem) ? get_class($dataActivityItem) : sprintf('%s(%s)', gettype($dataActivityItem), var_export($dataActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Activity property can only contain items of type \StructType\Activity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Activity value
     * @throws \InvalidArgumentException
     * @param \StructType\Activity[] $activity
     * @return \StructType\Data
     */
    public function setActivity(array $activity = array())
    {
        // validation for constraint: array
        if ('' !== ($activityArrayErrorMessage = self::validateActivityForArrayConstraintsFromSetActivity($activity))) {
            throw new \InvalidArgumentException($activityArrayErrorMessage, __LINE__);
        }
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Add item to Activity value
     * @throws \InvalidArgumentException
     * @param \StructType\Activity $item
     * @return \StructType\Data
     */
    public function addToActivity(\StructType\Activity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Activity) {
            throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of type \StructType\Activity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Activity[] = $item;
        return $this;
    }
    /**
     * Get opm_id value
     * @return string|null
     */
    public function getOpm_id()
    {
        return $this->{'opm-id'};
    }
    /**
     * Set opm_id value
     * @param string $opm_id
     * @return \StructType\Data
     */
    public function setOpm_id($opm_id = null)
    {
        // validation for constraint: string
        if (!is_null($opm_id) && !is_string($opm_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opm_id, true), gettype($opm_id)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($opm_id) && mb_strlen($opm_id) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($opm_id)), __LINE__);
        }
        // validation for constraint: minLength(16)
        if (!is_null($opm_id) && mb_strlen($opm_id) < 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 16', mb_strlen($opm_id)), __LINE__);
        }
        // validation for constraint: pattern(\d{18})
        if (!is_null($opm_id) && !preg_match('/\\d{18}/', $opm_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{18}', var_export($opm_id, true)), __LINE__);
        }
        $this->opm_id = $this->{'opm-id'} = $opm_id;
        return $this;
    }
    /**
     * Get prepared value
     * @return string|null
     */
    public function getPrepared()
    {
        return $this->prepared;
    }
    /**
     * Set prepared value
     * @param string $prepared
     * @return \StructType\Data
     */
    public function setPrepared($prepared = null)
    {
        // validation for constraint: string
        if (!is_null($prepared) && !is_string($prepared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prepared, true), gettype($prepared)), __LINE__);
        }
        // validation for constraint: length(13)
        if (!is_null($prepared) && mb_strlen($prepared) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 13', mb_strlen($prepared)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($prepared) && !preg_match('/\\d+/', $prepared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($prepared, true)), __LINE__);
        }
        $this->prepared = $prepared;
        return $this;
    }
    /**
     * Get prev_rejection_date value
     * @return string|null
     */
    public function getPrev_rejection_date()
    {
        return $this->{'prev-rejection-date'};
    }
    /**
     * Set prev_rejection_date value
     * @param string $prev_rejection_date
     * @return \StructType\Data
     */
    public function setPrev_rejection_date($prev_rejection_date = null)
    {
        // validation for constraint: string
        if (!is_null($prev_rejection_date) && !is_string($prev_rejection_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prev_rejection_date, true), gettype($prev_rejection_date)), __LINE__);
        }
        $this->prev_rejection_date = $this->{'prev-rejection-date'} = $prev_rejection_date;
        return $this;
    }
    /**
     * Get process_status value
     * @return string|null
     */
    public function getProcess_status()
    {
        return $this->{'process-status'};
    }
    /**
     * Set process_status value
     * @param string $process_status
     * @return \StructType\Data
     */
    public function setProcess_status($process_status = null)
    {
        // validation for constraint: string
        if (!is_null($process_status) && !is_string($process_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($process_status, true), gettype($process_status)), __LINE__);
        }
        $this->process_status = $this->{'process-status'} = $process_status;
        return $this;
    }
    /**
     * Get reg_needed value
     * @return string|null
     */
    public function getReg_needed()
    {
        return $this->{'reg-needed'};
    }
    /**
     * Set reg_needed value
     * @param string $reg_needed
     * @return \StructType\Data
     */
    public function setReg_needed($reg_needed = null)
    {
        // validation for constraint: string
        if (!is_null($reg_needed) && !is_string($reg_needed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reg_needed, true), gettype($reg_needed)), __LINE__);
        }
        $this->reg_needed = $this->{'reg-needed'} = $reg_needed;
        return $this;
    }
    /**
     * Get real_diag value
     * @return bool|null
     */
    public function getReal_diag()
    {
        return $this->{'real-diag'};
    }
    /**
     * Set real_diag value
     * @param bool $real_diag
     * @return \StructType\Data
     */
    public function setReal_diag($real_diag = null)
    {
        // validation for constraint: boolean
        if (!is_null($real_diag) && !is_bool($real_diag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($real_diag, true), gettype($real_diag)), __LINE__);
        }
        $this->real_diag = $this->{'real-diag'} = $real_diag;
        return $this;
    }
    /**
     * Get clearing value
     * @return bool|null
     */
    public function getClearing()
    {
        return $this->clearing;
    }
    /**
     * Set clearing value
     * @param bool $clearing
     * @return \StructType\Data
     */
    public function setClearing($clearing = null)
    {
        // validation for constraint: boolean
        if (!is_null($clearing) && !is_bool($clearing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($clearing, true), gettype($clearing)), __LINE__);
        }
        $this->clearing = $clearing;
        return $this;
    }
    /**
     * Get chs_type value
     * @return string|null
     */
    public function getChs_type()
    {
        return $this->{'chs-type'};
    }
    /**
     * Set chs_type value
     * @param string $chs_type
     * @return \StructType\Data
     */
    public function setChs_type($chs_type = null)
    {
        // validation for constraint: string
        if (!is_null($chs_type) && !is_string($chs_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chs_type, true), gettype($chs_type)), __LINE__);
        }
        $this->chs_type = $this->{'chs-type'} = $chs_type;
        return $this;
    }
    /**
     * Get contract_type value
     * @return string|null
     */
    public function getContract_type()
    {
        return $this->{'contract-type'};
    }
    /**
     * Set contract_type value
     * @param string $contract_type
     * @return \StructType\Data
     */
    public function setContract_type($contract_type = null)
    {
        // validation for constraint: string
        if (!is_null($contract_type) && !is_string($contract_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_type, true), gettype($contract_type)), __LINE__);
        }
        $this->contract_type = $this->{'contract-type'} = $contract_type;
        return $this;
    }
    /**
     * Get rejection_reason value
     * @return string|null
     */
    public function getRejection_reason()
    {
        return $this->{'rejection-reason'};
    }
    /**
     * Set rejection_reason value
     * @param string $rejection_reason
     * @return \StructType\Data
     */
    public function setRejection_reason($rejection_reason = null)
    {
        // validation for constraint: string
        if (!is_null($rejection_reason) && !is_string($rejection_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejection_reason, true), gettype($rejection_reason)), __LINE__);
        }
        $this->rejection_reason = $this->{'rejection-reason'} = $rejection_reason;
        return $this;
    }
    /**
     * Get chs_reason value
     * @return string|null
     */
    public function getChs_reason()
    {
        return $this->{'chs-reason'};
    }
    /**
     * Set chs_reason value
     * @param string $chs_reason
     * @return \StructType\Data
     */
    public function setChs_reason($chs_reason = null)
    {
        // validation for constraint: string
        if (!is_null($chs_reason) && !is_string($chs_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chs_reason, true), gettype($chs_reason)), __LINE__);
        }
        $this->chs_reason = $this->{'chs-reason'} = $chs_reason;
        return $this;
    }
    /**
     * Get contract_negotiation_type value
     * @return string|null
     */
    public function getContract_negotiation_type()
    {
        return $this->{'contract-negotiation-type'};
    }
    /**
     * Set contract_negotiation_type value
     * @param string $contract_negotiation_type
     * @return \StructType\Data
     */
    public function setContract_negotiation_type($contract_negotiation_type = null)
    {
        // validation for constraint: string
        if (!is_null($contract_negotiation_type) && !is_string($contract_negotiation_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_negotiation_type, true), gettype($contract_negotiation_type)), __LINE__);
        }
        $this->contract_negotiation_type = $this->{'contract-negotiation-type'} = $contract_negotiation_type;
        return $this;
    }
    /**
     * Get multiple_mp value
     * @return bool|null
     */
    public function getMultiple_mp()
    {
        return $this->{'multiple-mp'};
    }
    /**
     * Set multiple_mp value
     * @param bool $multiple_mp
     * @return \StructType\Data
     */
    public function setMultiple_mp($multiple_mp = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiple_mp) && !is_bool($multiple_mp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiple_mp, true), gettype($multiple_mp)), __LINE__);
        }
        $this->multiple_mp = $this->{'multiple-mp'} = $multiple_mp;
        return $this;
    }
    /**
     * Get Row value
     * @return \StructType\Row_type[]|null
     */
    public function getRow()
    {
        return $this->Row;
    }
    /**
     * This method is responsible for validating the values passed to the setRow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRowForArrayConstraintsFromSetRow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dataRowItem) {
            // validation for constraint: itemType
            if (!$dataRowItem instanceof \StructType\Row_type) {
                $invalidValues[] = is_object($dataRowItem) ? get_class($dataRowItem) : sprintf('%s(%s)', gettype($dataRowItem), var_export($dataRowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Row property can only contain items of type \StructType\Row_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Row value
     * @throws \InvalidArgumentException
     * @param \StructType\Row_type[] $row
     * @return \StructType\Data
     */
    public function setRow(array $row = array())
    {
        // validation for constraint: array
        if ('' !== ($rowArrayErrorMessage = self::validateRowForArrayConstraintsFromSetRow($row))) {
            throw new \InvalidArgumentException($rowArrayErrorMessage, __LINE__);
        }
        $this->Row = $row;
        return $this;
    }
    /**
     * Add item to Row value
     * @throws \InvalidArgumentException
     * @param \StructType\Row_type $item
     * @return \StructType\Data
     */
    public function addToRow(\StructType\Row_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Row_type) {
            throw new \InvalidArgumentException(sprintf('The Row property can only contain items of type \StructType\Row_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Row[] = $item;
        return $this;
    }
    /**
     * Get grid_id value
     * @return string|null
     */
    public function getGrid_id()
    {
        return $this->{'grid-id'};
    }
    /**
     * Set grid_id value
     * @param string $grid_id
     * @return \StructType\Data
     */
    public function setGrid_id($grid_id = null)
    {
        // validation for constraint: string
        if (!is_null($grid_id) && !is_string($grid_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grid_id, true), gettype($grid_id)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($grid_id) && mb_strlen($grid_id) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($grid_id)), __LINE__);
        }
        $this->grid_id = $this->{'grid-id'} = $grid_id;
        return $this;
    }
    /**
     * Get val_year value
     * @return string|null
     */
    public function getVal_year()
    {
        return $this->{'val-year'};
    }
    /**
     * Set val_year value
     * @param string $val_year
     * @return \StructType\Data
     */
    public function setVal_year($val_year = null)
    {
        // validation for constraint: string
        if (!is_null($val_year) && !is_string($val_year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($val_year, true), gettype($val_year)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($val_year) && mb_strlen($val_year) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($val_year)), __LINE__);
        }
        $this->val_year = $this->{'val-year'} = $val_year;
        return $this;
    }
    /**
     * Get val_month value
     * @return string|null
     */
    public function getVal_month()
    {
        return $this->{'val-month'};
    }
    /**
     * Set val_month value
     * @param string $val_month
     * @return \StructType\Data
     */
    public function setVal_month($val_month = null)
    {
        // validation for constraint: string
        if (!is_null($val_month) && !is_string($val_month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($val_month, true), gettype($val_month)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($val_month) && mb_strlen($val_month) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($val_month)), __LINE__);
        }
        $this->val_month = $this->{'val-month'} = $val_month;
        return $this;
    }
    /**
     * Get rep_type value
     * @return string|null
     */
    public function getRep_type()
    {
        return $this->{'rep-type'};
    }
    /**
     * Set rep_type value
     * @param string $rep_type
     * @return \StructType\Data
     */
    public function setRep_type($rep_type = null)
    {
        // validation for constraint: string
        if (!is_null($rep_type) && !is_string($rep_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rep_type, true), gettype($rep_type)), __LINE__);
        }
        $this->rep_type = $this->{'rep-type'} = $rep_type;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Data
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($version) && mb_strlen($version) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get v1_ds_cons value
     * @return string|null
     */
    public function getV1_ds_cons()
    {
        return $this->{'v1-ds-cons'};
    }
    /**
     * Set v1_ds_cons value
     * @param string $v1_ds_cons
     * @return \StructType\Data
     */
    public function setV1_ds_cons($v1_ds_cons = null)
    {
        // validation for constraint: string
        if (!is_null($v1_ds_cons) && !is_string($v1_ds_cons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v1_ds_cons, true), gettype($v1_ds_cons)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($v1_ds_cons) && mb_strlen($v1_ds_cons) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($v1_ds_cons)), __LINE__);
        }
        $this->v1_ds_cons = $this->{'v1-ds-cons'} = $v1_ds_cons;
        return $this;
    }
    /**
     * Get v2_ds_supply value
     * @return string|null
     */
    public function getV2_ds_supply()
    {
        return $this->{'v2-ds-supply'};
    }
    /**
     * Set v2_ds_supply value
     * @param string $v2_ds_supply
     * @return \StructType\Data
     */
    public function setV2_ds_supply($v2_ds_supply = null)
    {
        // validation for constraint: string
        if (!is_null($v2_ds_supply) && !is_string($v2_ds_supply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v2_ds_supply, true), gettype($v2_ds_supply)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($v2_ds_supply) && mb_strlen($v2_ds_supply) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($v2_ds_supply)), __LINE__);
        }
        $this->v2_ds_supply = $this->{'v2-ds-supply'} = $v2_ds_supply;
        return $this;
    }
    /**
     * Get v3_prod_prod value
     * @return string|null
     */
    public function getV3_prod_prod()
    {
        return $this->{'v3-prod-prod'};
    }
    /**
     * Set v3_prod_prod value
     * @param string $v3_prod_prod
     * @return \StructType\Data
     */
    public function setV3_prod_prod($v3_prod_prod = null)
    {
        // validation for constraint: string
        if (!is_null($v3_prod_prod) && !is_string($v3_prod_prod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v3_prod_prod, true), gettype($v3_prod_prod)), __LINE__);
        }
        $this->v3_prod_prod = $this->{'v3-prod-prod'} = $v3_prod_prod;
        return $this;
    }
    /**
     * Get v4_prod_cons value
     * @return string|null
     */
    public function getV4_prod_cons()
    {
        return $this->{'v4-prod-cons'};
    }
    /**
     * Set v4_prod_cons value
     * @param string $v4_prod_cons
     * @return \StructType\Data
     */
    public function setV4_prod_cons($v4_prod_cons = null)
    {
        // validation for constraint: string
        if (!is_null($v4_prod_cons) && !is_string($v4_prod_cons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v4_prod_cons, true), gettype($v4_prod_cons)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($v4_prod_cons) && mb_strlen($v4_prod_cons) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($v4_prod_cons)), __LINE__);
        }
        $this->v4_prod_cons = $this->{'v4-prod-cons'} = $v4_prod_cons;
        return $this;
    }
    /**
     * Get v5_end_cons value
     * @return string|null
     */
    public function getV5_end_cons()
    {
        return $this->{'v5-end-cons'};
    }
    /**
     * Set v5_end_cons value
     * @param string $v5_end_cons
     * @return \StructType\Data
     */
    public function setV5_end_cons($v5_end_cons = null)
    {
        // validation for constraint: string
        if (!is_null($v5_end_cons) && !is_string($v5_end_cons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v5_end_cons, true), gettype($v5_end_cons)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($v5_end_cons) && mb_strlen($v5_end_cons) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($v5_end_cons)), __LINE__);
        }
        $this->v5_end_cons = $this->{'v5-end-cons'} = $v5_end_cons;
        return $this;
    }
    /**
     * Get v6_local_cons value
     * @return string|null
     */
    public function getV6_local_cons()
    {
        return $this->{'v6-local-cons'};
    }
    /**
     * Set v6_local_cons value
     * @param string $v6_local_cons
     * @return \StructType\Data
     */
    public function setV6_local_cons($v6_local_cons = null)
    {
        // validation for constraint: string
        if (!is_null($v6_local_cons) && !is_string($v6_local_cons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v6_local_cons, true), gettype($v6_local_cons)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($v6_local_cons) && mb_strlen($v6_local_cons) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($v6_local_cons)), __LINE__);
        }
        $this->v6_local_cons = $this->{'v6-local-cons'} = $v6_local_cons;
        return $this;
    }
    /**
     * Get v7_tot_lds_cons value
     * @return string|null
     */
    public function getV7_tot_lds_cons()
    {
        return $this->{'v7-tot-lds-cons'};
    }
    /**
     * Set v7_tot_lds_cons value
     * @param string $v7_tot_lds_cons
     * @return \StructType\Data
     */
    public function setV7_tot_lds_cons($v7_tot_lds_cons = null)
    {
        // validation for constraint: string
        if (!is_null($v7_tot_lds_cons) && !is_string($v7_tot_lds_cons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v7_tot_lds_cons, true), gettype($v7_tot_lds_cons)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($v7_tot_lds_cons) && mb_strlen($v7_tot_lds_cons) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($v7_tot_lds_cons)), __LINE__);
        }
        $this->v7_tot_lds_cons = $this->{'v7-tot-lds-cons'} = $v7_tot_lds_cons;
        return $this;
    }
    /**
     * Get v8_tot_loc_cons value
     * @return string|null
     */
    public function getV8_tot_loc_cons()
    {
        return $this->{'v8-tot-loc-cons'};
    }
    /**
     * Set v8_tot_loc_cons value
     * @param string $v8_tot_loc_cons
     * @return \StructType\Data
     */
    public function setV8_tot_loc_cons($v8_tot_loc_cons = null)
    {
        // validation for constraint: string
        if (!is_null($v8_tot_loc_cons) && !is_string($v8_tot_loc_cons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v8_tot_loc_cons, true), gettype($v8_tot_loc_cons)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($v8_tot_loc_cons) && mb_strlen($v8_tot_loc_cons) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($v8_tot_loc_cons)), __LINE__);
        }
        $this->v8_tot_loc_cons = $this->{'v8-tot-loc-cons'} = $v8_tot_loc_cons;
        return $this;
    }
    /**
     * Get v9_loss value
     * @return string|null
     */
    public function getV9_loss()
    {
        return $this->{'v9-loss'};
    }
    /**
     * Set v9_loss value
     * @param string $v9_loss
     * @return \StructType\Data
     */
    public function setV9_loss($v9_loss = null)
    {
        // validation for constraint: string
        if (!is_null($v9_loss) && !is_string($v9_loss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v9_loss, true), gettype($v9_loss)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($v9_loss) && mb_strlen($v9_loss) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($v9_loss)), __LINE__);
        }
        $this->v9_loss = $this->{'v9-loss'} = $v9_loss;
        return $this;
    }
    /**
     * Get v10_pdt value
     * @return string|null
     */
    public function getV10_pdt()
    {
        return $this->{'v10-pdt'};
    }
    /**
     * Set v10_pdt value
     * @param string $v10_pdt
     * @return \StructType\Data
     */
    public function setV10_pdt($v10_pdt = null)
    {
        // validation for constraint: string
        if (!is_null($v10_pdt) && !is_string($v10_pdt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v10_pdt, true), gettype($v10_pdt)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($v10_pdt) && mb_strlen($v10_pdt) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($v10_pdt)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($v10_pdt) && !preg_match('/\\d+/', $v10_pdt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($v10_pdt, true)), __LINE__);
        }
        $this->v10_pdt = $this->{'v10-pdt'} = $v10_pdt;
        return $this;
    }
    /**
     * Get v11_voltage value
     * @return string|null
     */
    public function getV11_voltage()
    {
        return $this->{'v11-voltage'};
    }
    /**
     * Set v11_voltage value
     * @uses \EnumType\Voltage_level::valueIsValid()
     * @uses \EnumType\Voltage_level::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $v11_voltage
     * @return \StructType\Data
     */
    public function setV11_voltage($v11_voltage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Voltage_level::valueIsValid($v11_voltage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Voltage_level', is_array($v11_voltage) ? implode(', ', $v11_voltage) : var_export($v11_voltage, true), implode(', ', \EnumType\Voltage_level::getValidValues())), __LINE__);
        }
        $this->v11_voltage = $this->{'v11-voltage'} = $v11_voltage;
        return $this;
    }
}
