<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Claim-reference StructType
 * Meta information extracted from the WSDL
 * - documentation: Referenced object | Odkazovaný objekt
 * @subpackage Structs
 */
class Claim_reference extends AbstractStructBase
{
    /**
     * The obj_type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $obj_type;
    /**
     * The obj_key
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $obj_key;
    /**
     * Constructor method for Claim-reference
     * @uses Claim_reference::setObj_type()
     * @uses Claim_reference::setObj_key()
     * @param string $obj_type
     * @param string $obj_key
     */
    public function __construct($obj_type = null, $obj_key = null)
    {
        $this
            ->setObj_type($obj_type)
            ->setObj_key($obj_key);
    }
    /**
     * Get obj_type value
     * @return string
     */
    public function getObj_type()
    {
        return $this->{'obj-type'};
    }
    /**
     * Set obj_type value
     * @param string $obj_type
     * @return \StructType\Claim_reference
     */
    public function setObj_type($obj_type = null)
    {
        // validation for constraint: string
        if (!is_null($obj_type) && !is_string($obj_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obj_type, true), gettype($obj_type)), __LINE__);
        }
        $this->obj_type = $this->{'obj-type'} = $obj_type;
        return $this;
    }
    /**
     * Get obj_key value
     * @return string
     */
    public function getObj_key()
    {
        return $this->{'obj-key'};
    }
    /**
     * Set obj_key value
     * @param string $obj_key
     * @return \StructType\Claim_reference
     */
    public function setObj_key($obj_key = null)
    {
        // validation for constraint: string
        if (!is_null($obj_key) && !is_string($obj_key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obj_key, true), gettype($obj_key)), __LINE__);
        }
        $this->obj_key = $this->{'obj-key'} = $obj_key;
        return $this;
    }
}
