<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CDSREQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Following part of xml document contains either PDT information or IS OTE trade information | Další část xml dokumentu obsahuje buď informace o OPM nebo obchodu v IS OTE | Root element containing basic message data | Rootovský
 * element obsahující základní údaje o zprávě
 * @subpackage Structs
 */
class CDSREQ extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Unique message identification | Jednoznačný identifikátor zprávy | Typ pro číslo zprávy | Message number type
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The message_code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $message_code;
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Date and time of message | Datum a čas zprávy
     * - use: required
     * @var string
     */
    public $date_time;
    /**
     * The dtd_version
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions. So far a constant '1' | Rezervováno pro pozdější verze. Nyní konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_version;
    /**
     * The dtd_release
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions. So far a constant '1' | Rezervováno pro pozdější verze. Nyní konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_release;
    /**
     * The SenderIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message sender identification | Identifikace odesílatele zprávy
     * @var \StructType\SenderIdentificationType
     */
    public $SenderIdentification;
    /**
     * The ReceiverIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message receiver identification | Identifikace příjemce zprávy
     * @var \StructType\ReceiverIdentificationType
     */
    public $ReceiverIdentification;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Document
     */
    public $Document;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - choice: Location
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\Location[]
     */
    public $Location;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - documentation: Message language | Jazyk zprávy
     * - use: optional
     * @var string
     */
    public $language;
    /**
     * Constructor method for CDSREQ
     * @uses CDSREQ::setId()
     * @uses CDSREQ::setMessage_code()
     * @uses CDSREQ::setDate_time()
     * @uses CDSREQ::setDtd_version()
     * @uses CDSREQ::setDtd_release()
     * @uses CDSREQ::setSenderIdentification()
     * @uses CDSREQ::setReceiverIdentification()
     * @uses CDSREQ::setDocument()
     * @uses CDSREQ::setLocation()
     * @uses CDSREQ::setLanguage()
     * @param string $id
     * @param string $message_code
     * @param string $date_time
     * @param string $dtd_version
     * @param string $dtd_release
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @param \StructType\Document $document
     * @param \StructType\Location[] $location
     * @param string $language
     */
    public function __construct($id = null, $message_code = null, $date_time = null, $dtd_version = null, $dtd_release = null, \StructType\SenderIdentificationType $senderIdentification = null, \StructType\ReceiverIdentificationType $receiverIdentification = null, \StructType\Document $document = null, array $location = array(), $language = null)
    {
        $this
            ->setId($id)
            ->setMessage_code($message_code)
            ->setDate_time($date_time)
            ->setDtd_version($dtd_version)
            ->setDtd_release($dtd_release)
            ->setSenderIdentification($senderIdentification)
            ->setReceiverIdentification($receiverIdentification)
            ->setDocument($document)
            ->setLocation($location)
            ->setLanguage($language);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\CDSREQ
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($id) && mb_strlen($id) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get message_code value
     * @return string
     */
    public function getMessage_code()
    {
        return $this->{'message-code'};
    }
    /**
     * Set message_code value
     * @param string $message_code
     * @return \StructType\CDSREQ
     */
    public function setMessage_code($message_code = null)
    {
        // validation for constraint: string
        if (!is_null($message_code) && !is_string($message_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message_code, true), gettype($message_code)), __LINE__);
        }
        $this->message_code = $this->{'message-code'} = $message_code;
        return $this;
    }
    /**
     * Get date_time value
     * @return string
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\CDSREQ
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
    /**
     * Get dtd_version value
     * @return string
     */
    public function getDtd_version()
    {
        return $this->{'dtd-version'};
    }
    /**
     * Set dtd_version value
     * @param string $dtd_version
     * @return \StructType\CDSREQ
     */
    public function setDtd_version($dtd_version = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_version) && !is_string($dtd_version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_version, true), gettype($dtd_version)), __LINE__);
        }
        $this->dtd_version = $this->{'dtd-version'} = $dtd_version;
        return $this;
    }
    /**
     * Get dtd_release value
     * @return string
     */
    public function getDtd_release()
    {
        return $this->{'dtd-release'};
    }
    /**
     * Set dtd_release value
     * @param string $dtd_release
     * @return \StructType\CDSREQ
     */
    public function setDtd_release($dtd_release = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_release) && !is_string($dtd_release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_release, true), gettype($dtd_release)), __LINE__);
        }
        $this->dtd_release = $this->{'dtd-release'} = $dtd_release;
        return $this;
    }
    /**
     * Get SenderIdentification value
     * @return \StructType\SenderIdentificationType|null
     */
    public function getSenderIdentification()
    {
        return $this->SenderIdentification;
    }
    /**
     * Set SenderIdentification value
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @return \StructType\CDSREQ
     */
    public function setSenderIdentification(\StructType\SenderIdentificationType $senderIdentification = null)
    {
        $this->SenderIdentification = $senderIdentification;
        return $this;
    }
    /**
     * Get ReceiverIdentification value
     * @return \StructType\ReceiverIdentificationType|null
     */
    public function getReceiverIdentification()
    {
        return $this->ReceiverIdentification;
    }
    /**
     * Set ReceiverIdentification value
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @return \StructType\CDSREQ
     */
    public function setReceiverIdentification(\StructType\ReceiverIdentificationType $receiverIdentification = null)
    {
        $this->ReceiverIdentification = $receiverIdentification;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\Document|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \StructType\Document $document
     * @return \StructType\CDSREQ
     */
    public function setDocument(\StructType\Document $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Location[]|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cDSREQLocationItem) {
            // validation for constraint: itemType
            if (!$cDSREQLocationItem instanceof \StructType\Location) {
                $invalidValues[] = is_object($cDSREQLocationItem) ? get_class($cDSREQLocationItem) : sprintf('%s(%s)', gettype($cDSREQLocationItem), var_export($cDSREQLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location property can only contain items of type \StructType\Location, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLocationForChoiceConstraintsFromSetLocation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Location can\'t be set as the property %s is already set. Only one property must be set among these properties: Location, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Location value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Location[] $location
     * @return \StructType\CDSREQ
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Location)
        if ('' !== ($locationChoiceErrorMessage = self::validateLocationForChoiceConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationChoiceErrorMessage, __LINE__);
        }
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToLocation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToLocation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Location can\'t be set as the property %s is already set. Only one property must be set among these properties: Location, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Location value
     * @throws \InvalidArgumentException
     * @param \StructType\Location $item
     * @return \StructType\CDSREQ
     */
    public function addToLocation(\StructType\Location $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Location) {
            throw new \InvalidArgumentException(sprintf('The Location property can only contain items of type \StructType\Location, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Location)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToLocation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Location[] = $item;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\CDSREQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
}
