<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CDSDATA StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element containing basic message data | Rootovský element obsahující základní údaje o zprávě
 * @subpackage Structs
 */
class CDSDATA extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Identifikátor zprávy | Message Identification | Typ pro číslo zprávy | Message number type
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The message_code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $message_code;
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Date and time of message | Datum a čas zprávy
     * - use: required
     * @var string
     */
    public $date_time;
    /**
     * The dtd_version
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions; so far a constant '1' | Rezervováno pro příští verze, zatím konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_version;
    /**
     * The dtd_release
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions. So far a constant '1' | Rezervováno pro příští verze. Zatím konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_release;
    /**
     * The answer_required
     * Meta information extracted from the WSDL
     * - documentation: Indication of request for response 1=YES, 0=NO | Indikace požadavku na odpověď 1=ANO, 0=NE
     * - use: required
     * @var bool
     */
    public $answer_required;
    /**
     * The SenderIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message sender identification | Identifikace odesílatele zprávy
     * @var \StructType\SenderIdentificationType
     */
    public $SenderIdentification;
    /**
     * The ReceiverIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message receiver identification | Identifikace příjemce zprávy
     * @var \StructType\ReceiverIdentificationType
     */
    public $ReceiverIdentification;
    /**
     * The DataProvider
     * Meta information extracted from the WSDL
     * - documentation: Data provider identification | Identifikace poskytovatele dat
     * - minOccurs: 0
     * @var \StructType\DataProviderType
     */
    public $DataProvider;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the previous message | Reference na předešlou zprávu
     * - minOccurs: 0
     * @var \StructType\ReferenceType
     */
    public $Reference;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Location[]
     */
    public $Location;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType
     */
    public $Signature;
    /**
     * The interval
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?/\d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?
     * - use: optional
     * @var string
     */
    public $interval;
    /**
     * The time_offset
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: +1
     * - pattern: [-+]?2[01234]
     * - use: optional
     * @var string
     */
    public $time_offset;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - documentation: Message language | Jazyk zprávy
     * - use: optional
     * @var string
     */
    public $language;
    /**
     * The split_counter
     * Meta information extracted from the WSDL
     * - documentation: Message order within response | Pořadí zprávy v rámci odpovědi
     * - use: optional
     * @var int
     */
    public $split_counter;
    /**
     * The split_last
     * Meta information extracted from the WSDL
     * - documentation: Last message | Poslední zpráva
     * - use: optional
     * @var bool
     */
    public $split_last;
    /**
     * Constructor method for CDSDATA
     * @uses CDSDATA::setId()
     * @uses CDSDATA::setMessage_code()
     * @uses CDSDATA::setDate_time()
     * @uses CDSDATA::setDtd_version()
     * @uses CDSDATA::setDtd_release()
     * @uses CDSDATA::setAnswer_required()
     * @uses CDSDATA::setSenderIdentification()
     * @uses CDSDATA::setReceiverIdentification()
     * @uses CDSDATA::setDataProvider()
     * @uses CDSDATA::setReference()
     * @uses CDSDATA::setLocation()
     * @uses CDSDATA::setSignature()
     * @uses CDSDATA::setInterval()
     * @uses CDSDATA::setTime_offset()
     * @uses CDSDATA::setLanguage()
     * @uses CDSDATA::setSplit_counter()
     * @uses CDSDATA::setSplit_last()
     * @param string $id
     * @param string $message_code
     * @param string $date_time
     * @param string $dtd_version
     * @param string $dtd_release
     * @param bool $answer_required
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @param \StructType\DataProviderType $dataProvider
     * @param \StructType\ReferenceType $reference
     * @param \StructType\Location[] $location
     * @param \StructType\SignatureType $signature
     * @param string $interval
     * @param string $time_offset
     * @param string $language
     * @param int $split_counter
     * @param bool $split_last
     */
    public function __construct($id = null, $message_code = null, $date_time = null, $dtd_version = null, $dtd_release = null, $answer_required = null, \StructType\SenderIdentificationType $senderIdentification = null, \StructType\ReceiverIdentificationType $receiverIdentification = null, \StructType\DataProviderType $dataProvider = null, \StructType\ReferenceType $reference = null, array $location = array(), \StructType\SignatureType $signature = null, $interval = null, $time_offset = '+1', $language = null, $split_counter = null, $split_last = null)
    {
        $this
            ->setId($id)
            ->setMessage_code($message_code)
            ->setDate_time($date_time)
            ->setDtd_version($dtd_version)
            ->setDtd_release($dtd_release)
            ->setAnswer_required($answer_required)
            ->setSenderIdentification($senderIdentification)
            ->setReceiverIdentification($receiverIdentification)
            ->setDataProvider($dataProvider)
            ->setReference($reference)
            ->setLocation($location)
            ->setSignature($signature)
            ->setInterval($interval)
            ->setTime_offset($time_offset)
            ->setLanguage($language)
            ->setSplit_counter($split_counter)
            ->setSplit_last($split_last);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\CDSDATA
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($id) && mb_strlen($id) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get message_code value
     * @return string
     */
    public function getMessage_code()
    {
        return $this->{'message-code'};
    }
    /**
     * Set message_code value
     * @param string $message_code
     * @return \StructType\CDSDATA
     */
    public function setMessage_code($message_code = null)
    {
        // validation for constraint: string
        if (!is_null($message_code) && !is_string($message_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message_code, true), gettype($message_code)), __LINE__);
        }
        $this->message_code = $this->{'message-code'} = $message_code;
        return $this;
    }
    /**
     * Get date_time value
     * @return string
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\CDSDATA
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
    /**
     * Get dtd_version value
     * @return string
     */
    public function getDtd_version()
    {
        return $this->{'dtd-version'};
    }
    /**
     * Set dtd_version value
     * @param string $dtd_version
     * @return \StructType\CDSDATA
     */
    public function setDtd_version($dtd_version = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_version) && !is_string($dtd_version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_version, true), gettype($dtd_version)), __LINE__);
        }
        $this->dtd_version = $this->{'dtd-version'} = $dtd_version;
        return $this;
    }
    /**
     * Get dtd_release value
     * @return string
     */
    public function getDtd_release()
    {
        return $this->{'dtd-release'};
    }
    /**
     * Set dtd_release value
     * @param string $dtd_release
     * @return \StructType\CDSDATA
     */
    public function setDtd_release($dtd_release = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_release) && !is_string($dtd_release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_release, true), gettype($dtd_release)), __LINE__);
        }
        $this->dtd_release = $this->{'dtd-release'} = $dtd_release;
        return $this;
    }
    /**
     * Get answer_required value
     * @return bool
     */
    public function getAnswer_required()
    {
        return $this->{'answer-required'};
    }
    /**
     * Set answer_required value
     * @param bool $answer_required
     * @return \StructType\CDSDATA
     */
    public function setAnswer_required($answer_required = null)
    {
        // validation for constraint: boolean
        if (!is_null($answer_required) && !is_bool($answer_required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($answer_required, true), gettype($answer_required)), __LINE__);
        }
        $this->answer_required = $this->{'answer-required'} = $answer_required;
        return $this;
    }
    /**
     * Get SenderIdentification value
     * @return \StructType\SenderIdentificationType|null
     */
    public function getSenderIdentification()
    {
        return $this->SenderIdentification;
    }
    /**
     * Set SenderIdentification value
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @return \StructType\CDSDATA
     */
    public function setSenderIdentification(\StructType\SenderIdentificationType $senderIdentification = null)
    {
        $this->SenderIdentification = $senderIdentification;
        return $this;
    }
    /**
     * Get ReceiverIdentification value
     * @return \StructType\ReceiverIdentificationType|null
     */
    public function getReceiverIdentification()
    {
        return $this->ReceiverIdentification;
    }
    /**
     * Set ReceiverIdentification value
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @return \StructType\CDSDATA
     */
    public function setReceiverIdentification(\StructType\ReceiverIdentificationType $receiverIdentification = null)
    {
        $this->ReceiverIdentification = $receiverIdentification;
        return $this;
    }
    /**
     * Get DataProvider value
     * @return \StructType\DataProviderType|null
     */
    public function getDataProvider()
    {
        return $this->DataProvider;
    }
    /**
     * Set DataProvider value
     * @param \StructType\DataProviderType $dataProvider
     * @return \StructType\CDSDATA
     */
    public function setDataProvider(\StructType\DataProviderType $dataProvider = null)
    {
        $this->DataProvider = $dataProvider;
        return $this;
    }
    /**
     * Get Reference value
     * @return \StructType\ReferenceType|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \StructType\ReferenceType $reference
     * @return \StructType\CDSDATA
     */
    public function setReference(\StructType\ReferenceType $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Location[]|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cDSDATALocationItem) {
            // validation for constraint: itemType
            if (!$cDSDATALocationItem instanceof \StructType\Location) {
                $invalidValues[] = is_object($cDSDATALocationItem) ? get_class($cDSDATALocationItem) : sprintf('%s(%s)', gettype($cDSDATALocationItem), var_export($cDSDATALocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location property can only contain items of type \StructType\Location, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location value
     * @throws \InvalidArgumentException
     * @param \StructType\Location[] $location
     * @return \StructType\CDSDATA
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Add item to Location value
     * @throws \InvalidArgumentException
     * @param \StructType\Location $item
     * @return \StructType\CDSDATA
     */
    public function addToLocation(\StructType\Location $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Location) {
            throw new \InvalidArgumentException(sprintf('The Location property can only contain items of type \StructType\Location, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \StructType\SignatureType $signature
     * @return \StructType\CDSDATA
     */
    public function setSignature(\StructType\SignatureType $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get interval value
     * @return string|null
     */
    public function getInterval()
    {
        return $this->interval;
    }
    /**
     * Set interval value
     * @param string $interval
     * @return \StructType\CDSDATA
     */
    public function setInterval($interval = null)
    {
        // validation for constraint: string
        if (!is_null($interval) && !is_string($interval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interval, true), gettype($interval)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?/\d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?)
        if (!is_null($interval) && !preg_match('/\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d(:\\d\\d)?\/\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d(:\\d\\d)?/', $interval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?/\d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?', var_export($interval, true)), __LINE__);
        }
        $this->interval = $interval;
        return $this;
    }
    /**
     * Get time_offset value
     * @return string|null
     */
    public function getTime_offset()
    {
        return $this->{'time-offset'};
    }
    /**
     * Set time_offset value
     * @param string $time_offset
     * @return \StructType\CDSDATA
     */
    public function setTime_offset($time_offset = '+1')
    {
        // validation for constraint: string
        if (!is_null($time_offset) && !is_string($time_offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time_offset, true), gettype($time_offset)), __LINE__);
        }
        // validation for constraint: pattern([-+]?2[01234])
        if (!is_null($time_offset) && !preg_match('/[-+]?2[01234]/', $time_offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [-+]?2[01234]', var_export($time_offset, true)), __LINE__);
        }
        $this->time_offset = $this->{'time-offset'} = $time_offset;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\CDSDATA
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get split_counter value
     * @return int|null
     */
    public function getSplit_counter()
    {
        return $this->{'split-counter'};
    }
    /**
     * Set split_counter value
     * @param int $split_counter
     * @return \StructType\CDSDATA
     */
    public function setSplit_counter($split_counter = null)
    {
        // validation for constraint: int
        if (!is_null($split_counter) && !(is_int($split_counter) || ctype_digit($split_counter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($split_counter, true), gettype($split_counter)), __LINE__);
        }
        $this->split_counter = $this->{'split-counter'} = $split_counter;
        return $this;
    }
    /**
     * Get split_last value
     * @return bool|null
     */
    public function getSplit_last()
    {
        return $this->{'split-last'};
    }
    /**
     * Set split_last value
     * @param bool $split_last
     * @return \StructType\CDSDATA
     */
    public function setSplit_last($split_last = null)
    {
        // validation for constraint: boolean
        if (!is_null($split_last) && !is_bool($split_last)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($split_last, true), gettype($split_last)), __LINE__);
        }
        $this->split_last = $this->{'split-last'} = $split_last;
        return $this;
    }
}
