<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentHeader StructType
 * Meta information extracted from the WSDL
 * - documentation: Attachment Header | Hlavička přílohy
 * @subpackage Structs
 */
class AttachmentHeader extends AbstractStructBase
{
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DeliveryDate;
    /**
     * The TypeOfTrade
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TypeOfTrade;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Quantity;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $UnitPrice;
    /**
     * The BeforeTax
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $BeforeTax;
    /**
     * The VAT
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $VAT;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Currency;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Total;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ExchangeRate;
    /**
     * The PaymentReceived
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentReceived;
    /**
     * The InvoiceNo
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $InvoiceNo;
    /**
     * The IdRut
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $IdRut;
    /**
     * The ReferenceNo
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReferenceNo;
    /**
     * The ElectricityTax
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ElectricityTax;
    /**
     * The BaseTax
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BaseTax;
    /**
     * Constructor method for AttachmentHeader
     * @uses AttachmentHeader::setDeliveryDate()
     * @uses AttachmentHeader::setTypeOfTrade()
     * @uses AttachmentHeader::setQuantity()
     * @uses AttachmentHeader::setUnitPrice()
     * @uses AttachmentHeader::setBeforeTax()
     * @uses AttachmentHeader::setVAT()
     * @uses AttachmentHeader::setCurrency()
     * @uses AttachmentHeader::setTotal()
     * @uses AttachmentHeader::setExchangeRate()
     * @uses AttachmentHeader::setPaymentReceived()
     * @uses AttachmentHeader::setInvoiceNo()
     * @uses AttachmentHeader::setIdRut()
     * @uses AttachmentHeader::setReferenceNo()
     * @uses AttachmentHeader::setElectricityTax()
     * @uses AttachmentHeader::setBaseTax()
     * @param string $deliveryDate
     * @param string $typeOfTrade
     * @param string $quantity
     * @param string $unitPrice
     * @param string $beforeTax
     * @param string $vAT
     * @param string $currency
     * @param string $total
     * @param string $exchangeRate
     * @param string $paymentReceived
     * @param string $invoiceNo
     * @param string $idRut
     * @param string $referenceNo
     * @param string $electricityTax
     * @param string $baseTax
     */
    public function __construct($deliveryDate = null, $typeOfTrade = null, $quantity = null, $unitPrice = null, $beforeTax = null, $vAT = null, $currency = null, $total = null, $exchangeRate = null, $paymentReceived = null, $invoiceNo = null, $idRut = null, $referenceNo = null, $electricityTax = null, $baseTax = null)
    {
        $this
            ->setDeliveryDate($deliveryDate)
            ->setTypeOfTrade($typeOfTrade)
            ->setQuantity($quantity)
            ->setUnitPrice($unitPrice)
            ->setBeforeTax($beforeTax)
            ->setVAT($vAT)
            ->setCurrency($currency)
            ->setTotal($total)
            ->setExchangeRate($exchangeRate)
            ->setPaymentReceived($paymentReceived)
            ->setInvoiceNo($invoiceNo)
            ->setIdRut($idRut)
            ->setReferenceNo($referenceNo)
            ->setElectricityTax($electricityTax)
            ->setBaseTax($baseTax);
    }
    /**
     * Get DeliveryDate value
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\AttachmentHeader
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get TypeOfTrade value
     * @return string
     */
    public function getTypeOfTrade()
    {
        return $this->TypeOfTrade;
    }
    /**
     * Set TypeOfTrade value
     * @param string $typeOfTrade
     * @return \StructType\AttachmentHeader
     */
    public function setTypeOfTrade($typeOfTrade = null)
    {
        // validation for constraint: string
        if (!is_null($typeOfTrade) && !is_string($typeOfTrade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeOfTrade, true), gettype($typeOfTrade)), __LINE__);
        }
        $this->TypeOfTrade = $typeOfTrade;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \StructType\AttachmentHeader
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return string
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param string $unitPrice
     * @return \StructType\AttachmentHeader
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: string
        if (!is_null($unitPrice) && !is_string($unitPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get BeforeTax value
     * @return string
     */
    public function getBeforeTax()
    {
        return $this->BeforeTax;
    }
    /**
     * Set BeforeTax value
     * @param string $beforeTax
     * @return \StructType\AttachmentHeader
     */
    public function setBeforeTax($beforeTax = null)
    {
        // validation for constraint: string
        if (!is_null($beforeTax) && !is_string($beforeTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beforeTax, true), gettype($beforeTax)), __LINE__);
        }
        $this->BeforeTax = $beforeTax;
        return $this;
    }
    /**
     * Get VAT value
     * @return string
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * Set VAT value
     * @param string $vAT
     * @return \StructType\AttachmentHeader
     */
    public function setVAT($vAT = null)
    {
        // validation for constraint: string
        if (!is_null($vAT) && !is_string($vAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vAT, true), gettype($vAT)), __LINE__);
        }
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Get Currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\AttachmentHeader
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Total value
     * @return string
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param string $total
     * @return \StructType\AttachmentHeader
     */
    public function setTotal($total = null)
    {
        // validation for constraint: string
        if (!is_null($total) && !is_string($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return string|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param string $exchangeRate
     * @return \StructType\AttachmentHeader
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRate) && !is_string($exchangeRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get PaymentReceived value
     * @return string|null
     */
    public function getPaymentReceived()
    {
        return $this->PaymentReceived;
    }
    /**
     * Set PaymentReceived value
     * @param string $paymentReceived
     * @return \StructType\AttachmentHeader
     */
    public function setPaymentReceived($paymentReceived = null)
    {
        // validation for constraint: string
        if (!is_null($paymentReceived) && !is_string($paymentReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentReceived, true), gettype($paymentReceived)), __LINE__);
        }
        $this->PaymentReceived = $paymentReceived;
        return $this;
    }
    /**
     * Get InvoiceNo value
     * @return string|null
     */
    public function getInvoiceNo()
    {
        return $this->InvoiceNo;
    }
    /**
     * Set InvoiceNo value
     * @param string $invoiceNo
     * @return \StructType\AttachmentHeader
     */
    public function setInvoiceNo($invoiceNo = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNo) && !is_string($invoiceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNo, true), gettype($invoiceNo)), __LINE__);
        }
        $this->InvoiceNo = $invoiceNo;
        return $this;
    }
    /**
     * Get IdRut value
     * @return string|null
     */
    public function getIdRut()
    {
        return $this->IdRut;
    }
    /**
     * Set IdRut value
     * @param string $idRut
     * @return \StructType\AttachmentHeader
     */
    public function setIdRut($idRut = null)
    {
        // validation for constraint: string
        if (!is_null($idRut) && !is_string($idRut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idRut, true), gettype($idRut)), __LINE__);
        }
        $this->IdRut = $idRut;
        return $this;
    }
    /**
     * Get ReferenceNo value
     * @return string|null
     */
    public function getReferenceNo()
    {
        return $this->ReferenceNo;
    }
    /**
     * Set ReferenceNo value
     * @param string $referenceNo
     * @return \StructType\AttachmentHeader
     */
    public function setReferenceNo($referenceNo = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNo) && !is_string($referenceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNo, true), gettype($referenceNo)), __LINE__);
        }
        $this->ReferenceNo = $referenceNo;
        return $this;
    }
    /**
     * Get ElectricityTax value
     * @return string|null
     */
    public function getElectricityTax()
    {
        return $this->ElectricityTax;
    }
    /**
     * Set ElectricityTax value
     * @param string $electricityTax
     * @return \StructType\AttachmentHeader
     */
    public function setElectricityTax($electricityTax = null)
    {
        // validation for constraint: string
        if (!is_null($electricityTax) && !is_string($electricityTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($electricityTax, true), gettype($electricityTax)), __LINE__);
        }
        $this->ElectricityTax = $electricityTax;
        return $this;
    }
    /**
     * Get BaseTax value
     * @return string|null
     */
    public function getBaseTax()
    {
        return $this->BaseTax;
    }
    /**
     * Set BaseTax value
     * @param string $baseTax
     * @return \StructType\AttachmentHeader
     */
    public function setBaseTax($baseTax = null)
    {
        // validation for constraint: string
        if (!is_null($baseTax) && !is_string($baseTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseTax, true), gettype($baseTax)), __LINE__);
        }
        $this->BaseTax = $baseTax;
        return $this;
    }
}
