<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Action StructType
 * @subpackage Structs
 */
class Action extends AbstractStructBase
{
    /**
     * The action_type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $action_type;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The action_id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $action_id;
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Action creation date and time | Datum a čas vytvoření akce
     * - use: optional
     * @var string
     */
    public $date_time;
    /**
     * Constructor method for Action
     * @uses Action::setAction_type()
     * @uses Action::set_()
     * @uses Action::setAction_id()
     * @uses Action::setDate_time()
     * @param string $action_type
     * @param string $_
     * @param string $action_id
     * @param string $date_time
     */
    public function __construct($action_type = null, $_ = null, $action_id = null, $date_time = null)
    {
        $this
            ->setAction_type($action_type)
            ->set_($_)
            ->setAction_id($action_id)
            ->setDate_time($date_time);
    }
    /**
     * Get action_type value
     * @return string
     */
    public function getAction_type()
    {
        return $this->{'action-type'};
    }
    /**
     * Set action_type value
     * @param string $action_type
     * @return \StructType\Action
     */
    public function setAction_type($action_type = null)
    {
        // validation for constraint: string
        if (!is_null($action_type) && !is_string($action_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action_type, true), gettype($action_type)), __LINE__);
        }
        $this->action_type = $this->{'action-type'} = $action_type;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\Action
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get action_id value
     * @return string|null
     */
    public function getAction_id()
    {
        return $this->{'action-id'};
    }
    /**
     * Set action_id value
     * @param string $action_id
     * @return \StructType\Action
     */
    public function setAction_id($action_id = null)
    {
        // validation for constraint: string
        if (!is_null($action_id) && !is_string($action_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action_id, true), gettype($action_id)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($action_id) && mb_strlen($action_id) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($action_id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($action_id) && mb_strlen($action_id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($action_id)), __LINE__);
        }
        $this->action_id = $this->{'action-id'} = $action_id;
        return $this;
    }
    /**
     * Get date_time value
     * @return string|null
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\Action
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
}
