<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubTotal StructType
 * @subpackage Structs
 */
class SubTotal extends AbstractStructBase
{
    /**
     * The SubTotalNetValue
     * @var \StructType\Price_Type
     */
    public $SubTotalNetValue;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_Type[]
     */
    public $Tax;
    /**
     * The SubTotalGrossValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Price_Type
     */
    public $SubTotalGrossValue;
    /**
     * Constructor method for SubTotal
     * @uses SubTotal::setSubTotalNetValue()
     * @uses SubTotal::setTax()
     * @uses SubTotal::setSubTotalGrossValue()
     * @param \StructType\Price_Type $subTotalNetValue
     * @param \StructType\Tax_Type[] $tax
     * @param \StructType\Price_Type $subTotalGrossValue
     */
    public function __construct(\StructType\Price_Type $subTotalNetValue = null, array $tax = array(), \StructType\Price_Type $subTotalGrossValue = null)
    {
        $this
            ->setSubTotalNetValue($subTotalNetValue)
            ->setTax($tax)
            ->setSubTotalGrossValue($subTotalGrossValue);
    }
    /**
     * Get SubTotalNetValue value
     * @return \StructType\Price_Type|null
     */
    public function getSubTotalNetValue()
    {
        return $this->SubTotalNetValue;
    }
    /**
     * Set SubTotalNetValue value
     * @param \StructType\Price_Type $subTotalNetValue
     * @return \StructType\SubTotal
     */
    public function setSubTotalNetValue(\StructType\Price_Type $subTotalNetValue = null)
    {
        $this->SubTotalNetValue = $subTotalNetValue;
        return $this;
    }
    /**
     * Get Tax value
     * @return \StructType\Tax_Type[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subTotalTaxItem) {
            // validation for constraint: itemType
            if (!$subTotalTaxItem instanceof \StructType\Tax_Type) {
                $invalidValues[] = is_object($subTotalTaxItem) ? get_class($subTotalTaxItem) : sprintf('%s(%s)', gettype($subTotalTaxItem), var_export($subTotalTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type \StructType\Tax_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Type[] $tax
     * @return \StructType\SubTotal
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Type $item
     * @return \StructType\SubTotal
     */
    public function addToTax(\StructType\Tax_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_Type) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type \StructType\Tax_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get SubTotalGrossValue value
     * @return \StructType\Price_Type|null
     */
    public function getSubTotalGrossValue()
    {
        return $this->SubTotalGrossValue;
    }
    /**
     * Set SubTotalGrossValue value
     * @param \StructType\Price_Type $subTotalGrossValue
     * @return \StructType\SubTotal
     */
    public function setSubTotalGrossValue(\StructType\Price_Type $subTotalGrossValue = null)
    {
        $this->SubTotalGrossValue = $subTotalGrossValue;
        return $this;
    }
}
