<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Party StructType
 * Meta information extracted from the WSDL
 * - documentation: Party | Partner | Identification of change of supplier participant | Identifikace účastníka v procesu změny dodavatele
 * @subpackage Structs
 */
class Party extends AbstractStructBase
{
    /**
     * The role
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $role;
    /**
     * The party_role
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $party_role;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Participant Id (EAN 13) | Id účastníka (EAN 13) | Typ pro pseudo-EIC kód | EIC code type
     * - base: xsd:string
     * - maxLength: 16
     * - minLength: 13
     * - pattern: \c{16}
     * - use: optional
     * @var string
     */
    public $id;
    /**
     * The PartyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartyID
     */
    public $PartyID;
    /**
     * The BankAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BankAccount
     */
    public $BankAccount;
    /**
     * The NameAddress
     * @var \StructType\NameAddress
     */
    public $NameAddress;
    /**
     * The Communication
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Communication
     */
    public $Communication;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Contact[]
     */
    public $Contact;
    /**
     * The ReferencePartyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReferencePartyID
     */
    public $ReferencePartyID;
    /**
     * Constructor method for Party
     * @uses Party::setRole()
     * @uses Party::setParty_role()
     * @uses Party::setId()
     * @uses Party::setPartyID()
     * @uses Party::setBankAccount()
     * @uses Party::setNameAddress()
     * @uses Party::setCommunication()
     * @uses Party::setContact()
     * @uses Party::setReferencePartyID()
     * @param string $role
     * @param string $party_role
     * @param string $id
     * @param \StructType\PartyID $partyID
     * @param \StructType\BankAccount $bankAccount
     * @param \StructType\NameAddress $nameAddress
     * @param \StructType\Communication $communication
     * @param \StructType\Contact[] $contact
     * @param \StructType\ReferencePartyID $referencePartyID
     */
    public function __construct($role = null, $party_role = null, $id = null, \StructType\PartyID $partyID = null, \StructType\BankAccount $bankAccount = null, \StructType\NameAddress $nameAddress = null, \StructType\Communication $communication = null, array $contact = array(), \StructType\ReferencePartyID $referencePartyID = null)
    {
        $this
            ->setRole($role)
            ->setParty_role($party_role)
            ->setId($id)
            ->setPartyID($partyID)
            ->setBankAccount($bankAccount)
            ->setNameAddress($nameAddress)
            ->setCommunication($communication)
            ->setContact($contact)
            ->setReferencePartyID($referencePartyID);
    }
    /**
     * Get role value
     * @return string
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \StructType\Party
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get party_role value
     * @return string
     */
    public function getParty_role()
    {
        return $this->{'party-role'};
    }
    /**
     * Set party_role value
     * @param string $party_role
     * @return \StructType\Party
     */
    public function setParty_role($party_role = null)
    {
        // validation for constraint: string
        if (!is_null($party_role) && !is_string($party_role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($party_role, true), gettype($party_role)), __LINE__);
        }
        $this->party_role = $this->{'party-role'} = $party_role;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Party
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($id) && mb_strlen($id) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(13)
        if (!is_null($id) && mb_strlen($id) < 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 13', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: pattern(\c{16})
        if (!is_null($id) && !preg_match('/\\c{16}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \c{16}', var_export($id, true)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get PartyID value
     * @return \StructType\PartyID|null
     */
    public function getPartyID()
    {
        return $this->PartyID;
    }
    /**
     * Set PartyID value
     * @param \StructType\PartyID $partyID
     * @return \StructType\Party
     */
    public function setPartyID(\StructType\PartyID $partyID = null)
    {
        $this->PartyID = $partyID;
        return $this;
    }
    /**
     * Get BankAccount value
     * @return \StructType\BankAccount|null
     */
    public function getBankAccount()
    {
        return $this->BankAccount;
    }
    /**
     * Set BankAccount value
     * @param \StructType\BankAccount $bankAccount
     * @return \StructType\Party
     */
    public function setBankAccount(\StructType\BankAccount $bankAccount = null)
    {
        $this->BankAccount = $bankAccount;
        return $this;
    }
    /**
     * Get NameAddress value
     * @return \StructType\NameAddress|null
     */
    public function getNameAddress()
    {
        return $this->NameAddress;
    }
    /**
     * Set NameAddress value
     * @param \StructType\NameAddress $nameAddress
     * @return \StructType\Party
     */
    public function setNameAddress(\StructType\NameAddress $nameAddress = null)
    {
        $this->NameAddress = $nameAddress;
        return $this;
    }
    /**
     * Get Communication value
     * @return \StructType\Communication|null
     */
    public function getCommunication()
    {
        return $this->Communication;
    }
    /**
     * Set Communication value
     * @param \StructType\Communication $communication
     * @return \StructType\Party
     */
    public function setCommunication(\StructType\Communication $communication = null)
    {
        $this->Communication = $communication;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\Contact[]|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * This method is responsible for validating the values passed to the setContact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactForArrayConstraintsFromSetContact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partyContactItem) {
            // validation for constraint: itemType
            if (!$partyContactItem instanceof \StructType\Contact) {
                $invalidValues[] = is_object($partyContactItem) ? get_class($partyContactItem) : sprintf('%s(%s)', gettype($partyContactItem), var_export($partyContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Contact property can only contain items of type \StructType\Contact, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Contact value
     * @throws \InvalidArgumentException
     * @param \StructType\Contact[] $contact
     * @return \StructType\Party
     */
    public function setContact(array $contact = array())
    {
        // validation for constraint: array
        if ('' !== ($contactArrayErrorMessage = self::validateContactForArrayConstraintsFromSetContact($contact))) {
            throw new \InvalidArgumentException($contactArrayErrorMessage, __LINE__);
        }
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Add item to Contact value
     * @throws \InvalidArgumentException
     * @param \StructType\Contact $item
     * @return \StructType\Party
     */
    public function addToContact(\StructType\Contact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Contact) {
            throw new \InvalidArgumentException(sprintf('The Contact property can only contain items of type \StructType\Contact, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Contact[] = $item;
        return $this;
    }
    /**
     * Get ReferencePartyID value
     * @return \StructType\ReferencePartyID|null
     */
    public function getReferencePartyID()
    {
        return $this->ReferencePartyID;
    }
    /**
     * Set ReferencePartyID value
     * @param \StructType\ReferencePartyID $referencePartyID
     * @return \StructType\Party
     */
    public function setReferencePartyID(\StructType\ReferencePartyID $referencePartyID = null)
    {
        $this->ReferencePartyID = $referencePartyID;
        return $this;
    }
}
