<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for METER StructType
 * Meta information extracted from the WSDL
 * - documentation: Segment of electrometer within DGI RCS | Blok elektroměr v rámci DUF MO
 * @subpackage Structs
 */
class METER extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The inv_per_from
     * Meta information extracted from the WSDL
     * - documentation: Beginning of invoicing period | Počátek fakturačního období
     * - use: required
     * @var string
     */
    public $inv_per_from;
    /**
     * The inv_per_to
     * Meta information extracted from the WSDL
     * - documentation: End of invoicing period | Konec fakturačního období
     * - use: required
     * @var string
     */
    public $inv_per_to;
    /**
     * The mr_status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $mr_status;
    /**
     * The prim_multiplier
     * Meta information extracted from the WSDL
     * - documentation: Primary multiplier | Primární násobitel | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $prim_multiplier;
    /**
     * The qtyVT
     * Meta information extracted from the WSDL
     * - documentation: Quantity in high tarrif | Množství ve VT | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $qtyVT;
    /**
     * The mr_readVTs
     * Meta information extracted from the WSDL
     * - documentation: Initial state HT | Počáteční stav VT | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $mr_readVTs;
    /**
     * The mr_readVTe
     * Meta information extracted from the WSDL
     * - documentation: Final state HT | Koncový stav VT | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $mr_readVTe;
    /**
     * The qtyNT
     * Meta information extracted from the WSDL
     * - documentation: Quantity in low tariff, since 2016 required | Množství v NT, od 2016 povinný | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $qtyNT;
    /**
     * The mr_readNTs
     * Meta information extracted from the WSDL
     * - documentation: Initial state LT, since 2016 required | Počáteční stav NT, od 2016 povinný | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $mr_readNTs;
    /**
     * The mr_readNTe
     * Meta information extracted from the WSDL
     * - documentation: Final state LT, since 2016 required | Koncový stav NT, od 2016 povinný | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $mr_readNTe;
    /**
     * The mr_addbillVT
     * Meta information extracted from the WSDL
     * - documentation: Additional billing of HT work | Doúčtování práce VT | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $mr_addbillVT;
    /**
     * The mr_addbillNT
     * Meta information extracted from the WSDL
     * - documentation: Additional billing of LT work | Doúčtování práce NT | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $mr_addbillNT;
    /**
     * The up_enVT
     * Meta information extracted from the WSDL
     * - documentation: Unit price - payment for distributed quantity in high tariff (CZK/MWh), since 2016 not used | Jednotková cena - platba za distribuované množství ve vysokém tarifu (Kč/MWh), od 2016 nepoužívané | Jednotková cena - desetinné
     * číslo na max 14 des. míst
     * - base: xsd:string
     * - maxLength: 31
     * - pattern: \d+(\.\d{1,14})?
     * @var string
     */
    public $up_enVT;
    /**
     * The up_enNT
     * Meta information extracted from the WSDL
     * - documentation: Unit price - payment for distributed quantity in low tariff (CZK/MWh), since 2016 not used | Jednotková cena - platba za distribuované množství v nízkém tarifu (Kč/MWh), od 2016 nepoužívané | Jednotková cena - desetinné
     * číslo na max 14 des. míst
     * - base: xsd:string
     * - maxLength: 31
     * - pattern: \d+(\.\d{1,14})?
     * @var string
     */
    public $up_enNT;
    /**
     * The flatp_rescap
     * Meta information extracted from the WSDL
     * - documentation: Unit price - payment for circuit breaker - flat price for breaker, since 2016 not used | Jednotková cena - platba za příkon (jistič) - paušální cena za jistič, od 2016 nepoužívané | Jednotková cena - desetinné číslo na
     * max 14 des. míst
     * - base: xsd:string
     * - maxLength: 31
     * - pattern: \d+(\.\d{1,14})?
     * @var string
     */
    public $flatp_rescap;
    /**
     * The up_rescap
     * Meta information extracted from the WSDL
     * - documentation: Unit price - payment for circuit breaker - price per A (CZK/A), since 2016 not used | Jednotková cena - platba za příkon (jistič) - cena za A (Kč/A), od 2016 nepoužívané | Jednotková cena - desetinné číslo na max 14 des.
     * míst
     * - base: xsd:string
     * - maxLength: 31
     * - pattern: \d+(\.\d{1,14})?
     * @var string
     */
    public $up_rescap;
    /**
     * The up_sysservice
     * Meta information extracted from the WSDL
     * - documentation: Unit price - payment for system services (CZK/MWh), since 2016 not used | Jednotková cena - platba za systémové služby (Kč/MWh), od 2016 nepoužívané | Jednotková cena - desetinné číslo na max 14 des. míst
     * - base: xsd:string
     * - maxLength: 31
     * - pattern: \d+(\.\d{1,14})?
     * @var string
     */
    public $up_sysservice;
    /**
     * The up_oteservice
     * Meta information extracted from the WSDL
     * - documentation: Unit price - payment for MO settlement service (CZK/MWh), since 2016 not used | Jednotková cena - platba za služby zúčtování OTE (Kč/MWh), od 2016 nepoužívané | Jednotková cena - desetinné číslo na max 14 des. míst
     * - base: xsd:string
     * - maxLength: 31
     * - pattern: \d+(\.\d{1,14})?
     * @var string
     */
    public $up_oteservice;
    /**
     * The up_renressource
     * Meta information extracted from the WSDL
     * - documentation: Unit price - payment for renewvable resources (CZK/MWh), since 2016 not used | Jednotková cena - platba za obnovitelné zdroje (Kč/MWh), od 2016 nepoužívané | Jednotková cena - desetinné číslo na max 14 des. míst
     * - base: xsd:string
     * - maxLength: 31
     * - pattern: \d+(\.\d{1,14})?
     * @var string
     */
    public $up_renressource;
    /**
     * The up_comressource
     * Meta information extracted from the WSDL
     * - documentation: Unit price - payment for combined heat and electricity resources (CZK/MWh), since 2016 not used | Jednotková cena - platba za zdroje kombinované výroby elektřiny a tepla (Kč/MWh), od 2016 nepoužívané | Jednotková cena -
     * desetinné číslo na max 14 des. míst
     * - base: xsd:string
     * - maxLength: 31
     * - pattern: \d+(\.\d{1,14})?
     * @var string
     */
    public $up_comressource;
    /**
     * The dist_rate_type
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $dist_rate_type;
    /**
     * Constructor method for METER
     * @uses METER::setId()
     * @uses METER::setInv_per_from()
     * @uses METER::setInv_per_to()
     * @uses METER::setMr_status()
     * @uses METER::setPrim_multiplier()
     * @uses METER::setQtyVT()
     * @uses METER::setMr_readVTs()
     * @uses METER::setMr_readVTe()
     * @uses METER::setQtyNT()
     * @uses METER::setMr_readNTs()
     * @uses METER::setMr_readNTe()
     * @uses METER::setMr_addbillVT()
     * @uses METER::setMr_addbillNT()
     * @uses METER::setUp_enVT()
     * @uses METER::setUp_enNT()
     * @uses METER::setFlatp_rescap()
     * @uses METER::setUp_rescap()
     * @uses METER::setUp_sysservice()
     * @uses METER::setUp_oteservice()
     * @uses METER::setUp_renressource()
     * @uses METER::setUp_comressource()
     * @uses METER::setDist_rate_type()
     * @param string $id
     * @param string $inv_per_from
     * @param string $inv_per_to
     * @param string $mr_status
     * @param string $prim_multiplier
     * @param string $qtyVT
     * @param string $mr_readVTs
     * @param string $mr_readVTe
     * @param string $qtyNT
     * @param string $mr_readNTs
     * @param string $mr_readNTe
     * @param string $mr_addbillVT
     * @param string $mr_addbillNT
     * @param string $up_enVT
     * @param string $up_enNT
     * @param string $flatp_rescap
     * @param string $up_rescap
     * @param string $up_sysservice
     * @param string $up_oteservice
     * @param string $up_renressource
     * @param string $up_comressource
     * @param string $dist_rate_type
     */
    public function __construct($id = null, $inv_per_from = null, $inv_per_to = null, $mr_status = null, $prim_multiplier = null, $qtyVT = null, $mr_readVTs = null, $mr_readVTe = null, $qtyNT = null, $mr_readNTs = null, $mr_readNTe = null, $mr_addbillVT = null, $mr_addbillNT = null, $up_enVT = null, $up_enNT = null, $flatp_rescap = null, $up_rescap = null, $up_sysservice = null, $up_oteservice = null, $up_renressource = null, $up_comressource = null, $dist_rate_type = null)
    {
        $this
            ->setId($id)
            ->setInv_per_from($inv_per_from)
            ->setInv_per_to($inv_per_to)
            ->setMr_status($mr_status)
            ->setPrim_multiplier($prim_multiplier)
            ->setQtyVT($qtyVT)
            ->setMr_readVTs($mr_readVTs)
            ->setMr_readVTe($mr_readVTe)
            ->setQtyNT($qtyNT)
            ->setMr_readNTs($mr_readNTs)
            ->setMr_readNTe($mr_readNTe)
            ->setMr_addbillVT($mr_addbillVT)
            ->setMr_addbillNT($mr_addbillNT)
            ->setUp_enVT($up_enVT)
            ->setUp_enNT($up_enNT)
            ->setFlatp_rescap($flatp_rescap)
            ->setUp_rescap($up_rescap)
            ->setUp_sysservice($up_sysservice)
            ->setUp_oteservice($up_oteservice)
            ->setUp_renressource($up_renressource)
            ->setUp_comressource($up_comressource)
            ->setDist_rate_type($dist_rate_type);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\METER
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($id) && mb_strlen($id) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get inv_per_from value
     * @return string
     */
    public function getInv_per_from()
    {
        return $this->{'inv-per-from'};
    }
    /**
     * Set inv_per_from value
     * @param string $inv_per_from
     * @return \StructType\METER
     */
    public function setInv_per_from($inv_per_from = null)
    {
        // validation for constraint: string
        if (!is_null($inv_per_from) && !is_string($inv_per_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_per_from, true), gettype($inv_per_from)), __LINE__);
        }
        $this->inv_per_from = $this->{'inv-per-from'} = $inv_per_from;
        return $this;
    }
    /**
     * Get inv_per_to value
     * @return string
     */
    public function getInv_per_to()
    {
        return $this->{'inv-per-to'};
    }
    /**
     * Set inv_per_to value
     * @param string $inv_per_to
     * @return \StructType\METER
     */
    public function setInv_per_to($inv_per_to = null)
    {
        // validation for constraint: string
        if (!is_null($inv_per_to) && !is_string($inv_per_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_per_to, true), gettype($inv_per_to)), __LINE__);
        }
        $this->inv_per_to = $this->{'inv-per-to'} = $inv_per_to;
        return $this;
    }
    /**
     * Get mr_status value
     * @return string
     */
    public function getMr_status()
    {
        return $this->{'mr-status'};
    }
    /**
     * Set mr_status value
     * @param string $mr_status
     * @return \StructType\METER
     */
    public function setMr_status($mr_status = null)
    {
        // validation for constraint: string
        if (!is_null($mr_status) && !is_string($mr_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mr_status, true), gettype($mr_status)), __LINE__);
        }
        $this->mr_status = $this->{'mr-status'} = $mr_status;
        return $this;
    }
    /**
     * Get prim_multiplier value
     * @return string
     */
    public function getPrim_multiplier()
    {
        return $this->{'prim-multiplier'};
    }
    /**
     * Set prim_multiplier value
     * @param string $prim_multiplier
     * @return \StructType\METER
     */
    public function setPrim_multiplier($prim_multiplier = null)
    {
        // validation for constraint: string
        if (!is_null($prim_multiplier) && !is_string($prim_multiplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prim_multiplier, true), gettype($prim_multiplier)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($prim_multiplier) && mb_strlen($prim_multiplier) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($prim_multiplier)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($prim_multiplier) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $prim_multiplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($prim_multiplier, true)), __LINE__);
        }
        $this->prim_multiplier = $this->{'prim-multiplier'} = $prim_multiplier;
        return $this;
    }
    /**
     * Get qtyVT value
     * @return string
     */
    public function getQtyVT()
    {
        return $this->qtyVT;
    }
    /**
     * Set qtyVT value
     * @param string $qtyVT
     * @return \StructType\METER
     */
    public function setQtyVT($qtyVT = null)
    {
        // validation for constraint: string
        if (!is_null($qtyVT) && !is_string($qtyVT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qtyVT, true), gettype($qtyVT)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qtyVT) && mb_strlen($qtyVT) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qtyVT)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($qtyVT) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $qtyVT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($qtyVT, true)), __LINE__);
        }
        $this->qtyVT = $qtyVT;
        return $this;
    }
    /**
     * Get mr_readVTs value
     * @return string
     */
    public function getMr_readVTs()
    {
        return $this->{'mr-readVTs'};
    }
    /**
     * Set mr_readVTs value
     * @param string $mr_readVTs
     * @return \StructType\METER
     */
    public function setMr_readVTs($mr_readVTs = null)
    {
        // validation for constraint: string
        if (!is_null($mr_readVTs) && !is_string($mr_readVTs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mr_readVTs, true), gettype($mr_readVTs)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($mr_readVTs) && mb_strlen($mr_readVTs) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($mr_readVTs)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($mr_readVTs) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $mr_readVTs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($mr_readVTs, true)), __LINE__);
        }
        $this->mr_readVTs = $this->{'mr-readVTs'} = $mr_readVTs;
        return $this;
    }
    /**
     * Get mr_readVTe value
     * @return string
     */
    public function getMr_readVTe()
    {
        return $this->{'mr-readVTe'};
    }
    /**
     * Set mr_readVTe value
     * @param string $mr_readVTe
     * @return \StructType\METER
     */
    public function setMr_readVTe($mr_readVTe = null)
    {
        // validation for constraint: string
        if (!is_null($mr_readVTe) && !is_string($mr_readVTe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mr_readVTe, true), gettype($mr_readVTe)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($mr_readVTe) && mb_strlen($mr_readVTe) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($mr_readVTe)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($mr_readVTe) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $mr_readVTe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($mr_readVTe, true)), __LINE__);
        }
        $this->mr_readVTe = $this->{'mr-readVTe'} = $mr_readVTe;
        return $this;
    }
    /**
     * Get qtyNT value
     * @return string|null
     */
    public function getQtyNT()
    {
        return $this->qtyNT;
    }
    /**
     * Set qtyNT value
     * @param string $qtyNT
     * @return \StructType\METER
     */
    public function setQtyNT($qtyNT = null)
    {
        // validation for constraint: string
        if (!is_null($qtyNT) && !is_string($qtyNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qtyNT, true), gettype($qtyNT)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qtyNT) && mb_strlen($qtyNT) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qtyNT)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($qtyNT) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $qtyNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($qtyNT, true)), __LINE__);
        }
        $this->qtyNT = $qtyNT;
        return $this;
    }
    /**
     * Get mr_readNTs value
     * @return string|null
     */
    public function getMr_readNTs()
    {
        return $this->{'mr-readNTs'};
    }
    /**
     * Set mr_readNTs value
     * @param string $mr_readNTs
     * @return \StructType\METER
     */
    public function setMr_readNTs($mr_readNTs = null)
    {
        // validation for constraint: string
        if (!is_null($mr_readNTs) && !is_string($mr_readNTs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mr_readNTs, true), gettype($mr_readNTs)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($mr_readNTs) && mb_strlen($mr_readNTs) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($mr_readNTs)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($mr_readNTs) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $mr_readNTs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($mr_readNTs, true)), __LINE__);
        }
        $this->mr_readNTs = $this->{'mr-readNTs'} = $mr_readNTs;
        return $this;
    }
    /**
     * Get mr_readNTe value
     * @return string|null
     */
    public function getMr_readNTe()
    {
        return $this->{'mr-readNTe'};
    }
    /**
     * Set mr_readNTe value
     * @param string $mr_readNTe
     * @return \StructType\METER
     */
    public function setMr_readNTe($mr_readNTe = null)
    {
        // validation for constraint: string
        if (!is_null($mr_readNTe) && !is_string($mr_readNTe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mr_readNTe, true), gettype($mr_readNTe)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($mr_readNTe) && mb_strlen($mr_readNTe) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($mr_readNTe)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($mr_readNTe) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $mr_readNTe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($mr_readNTe, true)), __LINE__);
        }
        $this->mr_readNTe = $this->{'mr-readNTe'} = $mr_readNTe;
        return $this;
    }
    /**
     * Get mr_addbillVT value
     * @return string|null
     */
    public function getMr_addbillVT()
    {
        return $this->{'mr-addbillVT'};
    }
    /**
     * Set mr_addbillVT value
     * @param string $mr_addbillVT
     * @return \StructType\METER
     */
    public function setMr_addbillVT($mr_addbillVT = null)
    {
        // validation for constraint: string
        if (!is_null($mr_addbillVT) && !is_string($mr_addbillVT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mr_addbillVT, true), gettype($mr_addbillVT)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($mr_addbillVT) && mb_strlen($mr_addbillVT) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($mr_addbillVT)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($mr_addbillVT) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $mr_addbillVT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($mr_addbillVT, true)), __LINE__);
        }
        $this->mr_addbillVT = $this->{'mr-addbillVT'} = $mr_addbillVT;
        return $this;
    }
    /**
     * Get mr_addbillNT value
     * @return string|null
     */
    public function getMr_addbillNT()
    {
        return $this->{'mr-addbillNT'};
    }
    /**
     * Set mr_addbillNT value
     * @param string $mr_addbillNT
     * @return \StructType\METER
     */
    public function setMr_addbillNT($mr_addbillNT = null)
    {
        // validation for constraint: string
        if (!is_null($mr_addbillNT) && !is_string($mr_addbillNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mr_addbillNT, true), gettype($mr_addbillNT)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($mr_addbillNT) && mb_strlen($mr_addbillNT) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($mr_addbillNT)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($mr_addbillNT) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $mr_addbillNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($mr_addbillNT, true)), __LINE__);
        }
        $this->mr_addbillNT = $this->{'mr-addbillNT'} = $mr_addbillNT;
        return $this;
    }
    /**
     * Get up_enVT value
     * @return string|null
     */
    public function getUp_enVT()
    {
        return $this->{'up-enVT'};
    }
    /**
     * Set up_enVT value
     * @param string $up_enVT
     * @return \StructType\METER
     */
    public function setUp_enVT($up_enVT = null)
    {
        // validation for constraint: string
        if (!is_null($up_enVT) && !is_string($up_enVT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($up_enVT, true), gettype($up_enVT)), __LINE__);
        }
        // validation for constraint: maxLength(31)
        if (!is_null($up_enVT) && mb_strlen($up_enVT) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 31', mb_strlen($up_enVT)), __LINE__);
        }
        // validation for constraint: pattern(\d+(\.\d{1,14})?)
        if (!is_null($up_enVT) && !preg_match('/\\d+(\\.\\d{1,14})?/', $up_enVT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+(\.\d{1,14})?', var_export($up_enVT, true)), __LINE__);
        }
        $this->up_enVT = $this->{'up-enVT'} = $up_enVT;
        return $this;
    }
    /**
     * Get up_enNT value
     * @return string|null
     */
    public function getUp_enNT()
    {
        return $this->{'up-enNT'};
    }
    /**
     * Set up_enNT value
     * @param string $up_enNT
     * @return \StructType\METER
     */
    public function setUp_enNT($up_enNT = null)
    {
        // validation for constraint: string
        if (!is_null($up_enNT) && !is_string($up_enNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($up_enNT, true), gettype($up_enNT)), __LINE__);
        }
        // validation for constraint: maxLength(31)
        if (!is_null($up_enNT) && mb_strlen($up_enNT) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 31', mb_strlen($up_enNT)), __LINE__);
        }
        // validation for constraint: pattern(\d+(\.\d{1,14})?)
        if (!is_null($up_enNT) && !preg_match('/\\d+(\\.\\d{1,14})?/', $up_enNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+(\.\d{1,14})?', var_export($up_enNT, true)), __LINE__);
        }
        $this->up_enNT = $this->{'up-enNT'} = $up_enNT;
        return $this;
    }
    /**
     * Get flatp_rescap value
     * @return string|null
     */
    public function getFlatp_rescap()
    {
        return $this->{'flatp-rescap'};
    }
    /**
     * Set flatp_rescap value
     * @param string $flatp_rescap
     * @return \StructType\METER
     */
    public function setFlatp_rescap($flatp_rescap = null)
    {
        // validation for constraint: string
        if (!is_null($flatp_rescap) && !is_string($flatp_rescap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flatp_rescap, true), gettype($flatp_rescap)), __LINE__);
        }
        // validation for constraint: maxLength(31)
        if (!is_null($flatp_rescap) && mb_strlen($flatp_rescap) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 31', mb_strlen($flatp_rescap)), __LINE__);
        }
        // validation for constraint: pattern(\d+(\.\d{1,14})?)
        if (!is_null($flatp_rescap) && !preg_match('/\\d+(\\.\\d{1,14})?/', $flatp_rescap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+(\.\d{1,14})?', var_export($flatp_rescap, true)), __LINE__);
        }
        $this->flatp_rescap = $this->{'flatp-rescap'} = $flatp_rescap;
        return $this;
    }
    /**
     * Get up_rescap value
     * @return string|null
     */
    public function getUp_rescap()
    {
        return $this->{'up-rescap'};
    }
    /**
     * Set up_rescap value
     * @param string $up_rescap
     * @return \StructType\METER
     */
    public function setUp_rescap($up_rescap = null)
    {
        // validation for constraint: string
        if (!is_null($up_rescap) && !is_string($up_rescap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($up_rescap, true), gettype($up_rescap)), __LINE__);
        }
        // validation for constraint: maxLength(31)
        if (!is_null($up_rescap) && mb_strlen($up_rescap) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 31', mb_strlen($up_rescap)), __LINE__);
        }
        // validation for constraint: pattern(\d+(\.\d{1,14})?)
        if (!is_null($up_rescap) && !preg_match('/\\d+(\\.\\d{1,14})?/', $up_rescap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+(\.\d{1,14})?', var_export($up_rescap, true)), __LINE__);
        }
        $this->up_rescap = $this->{'up-rescap'} = $up_rescap;
        return $this;
    }
    /**
     * Get up_sysservice value
     * @return string|null
     */
    public function getUp_sysservice()
    {
        return $this->{'up-sysservice'};
    }
    /**
     * Set up_sysservice value
     * @param string $up_sysservice
     * @return \StructType\METER
     */
    public function setUp_sysservice($up_sysservice = null)
    {
        // validation for constraint: string
        if (!is_null($up_sysservice) && !is_string($up_sysservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($up_sysservice, true), gettype($up_sysservice)), __LINE__);
        }
        // validation for constraint: maxLength(31)
        if (!is_null($up_sysservice) && mb_strlen($up_sysservice) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 31', mb_strlen($up_sysservice)), __LINE__);
        }
        // validation for constraint: pattern(\d+(\.\d{1,14})?)
        if (!is_null($up_sysservice) && !preg_match('/\\d+(\\.\\d{1,14})?/', $up_sysservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+(\.\d{1,14})?', var_export($up_sysservice, true)), __LINE__);
        }
        $this->up_sysservice = $this->{'up-sysservice'} = $up_sysservice;
        return $this;
    }
    /**
     * Get up_oteservice value
     * @return string|null
     */
    public function getUp_oteservice()
    {
        return $this->{'up-oteservice'};
    }
    /**
     * Set up_oteservice value
     * @param string $up_oteservice
     * @return \StructType\METER
     */
    public function setUp_oteservice($up_oteservice = null)
    {
        // validation for constraint: string
        if (!is_null($up_oteservice) && !is_string($up_oteservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($up_oteservice, true), gettype($up_oteservice)), __LINE__);
        }
        // validation for constraint: maxLength(31)
        if (!is_null($up_oteservice) && mb_strlen($up_oteservice) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 31', mb_strlen($up_oteservice)), __LINE__);
        }
        // validation for constraint: pattern(\d+(\.\d{1,14})?)
        if (!is_null($up_oteservice) && !preg_match('/\\d+(\\.\\d{1,14})?/', $up_oteservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+(\.\d{1,14})?', var_export($up_oteservice, true)), __LINE__);
        }
        $this->up_oteservice = $this->{'up-oteservice'} = $up_oteservice;
        return $this;
    }
    /**
     * Get up_renressource value
     * @return string|null
     */
    public function getUp_renressource()
    {
        return $this->{'up-renressource'};
    }
    /**
     * Set up_renressource value
     * @param string $up_renressource
     * @return \StructType\METER
     */
    public function setUp_renressource($up_renressource = null)
    {
        // validation for constraint: string
        if (!is_null($up_renressource) && !is_string($up_renressource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($up_renressource, true), gettype($up_renressource)), __LINE__);
        }
        // validation for constraint: maxLength(31)
        if (!is_null($up_renressource) && mb_strlen($up_renressource) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 31', mb_strlen($up_renressource)), __LINE__);
        }
        // validation for constraint: pattern(\d+(\.\d{1,14})?)
        if (!is_null($up_renressource) && !preg_match('/\\d+(\\.\\d{1,14})?/', $up_renressource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+(\.\d{1,14})?', var_export($up_renressource, true)), __LINE__);
        }
        $this->up_renressource = $this->{'up-renressource'} = $up_renressource;
        return $this;
    }
    /**
     * Get up_comressource value
     * @return string|null
     */
    public function getUp_comressource()
    {
        return $this->{'up-comressource'};
    }
    /**
     * Set up_comressource value
     * @param string $up_comressource
     * @return \StructType\METER
     */
    public function setUp_comressource($up_comressource = null)
    {
        // validation for constraint: string
        if (!is_null($up_comressource) && !is_string($up_comressource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($up_comressource, true), gettype($up_comressource)), __LINE__);
        }
        // validation for constraint: maxLength(31)
        if (!is_null($up_comressource) && mb_strlen($up_comressource) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 31', mb_strlen($up_comressource)), __LINE__);
        }
        // validation for constraint: pattern(\d+(\.\d{1,14})?)
        if (!is_null($up_comressource) && !preg_match('/\\d+(\\.\\d{1,14})?/', $up_comressource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+(\.\d{1,14})?', var_export($up_comressource, true)), __LINE__);
        }
        $this->up_comressource = $this->{'up-comressource'} = $up_comressource;
        return $this;
    }
    /**
     * Get dist_rate_type value
     * @return string|null
     */
    public function getDist_rate_type()
    {
        return $this->{'dist-rate-type'};
    }
    /**
     * Set dist_rate_type value
     * @param string $dist_rate_type
     * @return \StructType\METER
     */
    public function setDist_rate_type($dist_rate_type = null)
    {
        // validation for constraint: string
        if (!is_null($dist_rate_type) && !is_string($dist_rate_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dist_rate_type, true), gettype($dist_rate_type)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($dist_rate_type) && mb_strlen($dist_rate_type) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($dist_rate_type)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($dist_rate_type) && mb_strlen($dist_rate_type) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($dist_rate_type)), __LINE__);
        }
        $this->dist_rate_type = $this->{'dist-rate-type'} = $dist_rate_type;
        return $this;
    }
}
