<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOfSumItems StructType
 * @subpackage Structs
 */
class ListOfSumItems extends AbstractStructBase
{
    /**
     * The items_category
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $items_category;
    /**
     * The SumItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SumItem[]
     */
    public $SumItem;
    /**
     * The SubTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubTotal
     */
    public $SubTotal;
    /**
     * Constructor method for ListOfSumItems
     * @uses ListOfSumItems::setItems_category()
     * @uses ListOfSumItems::setSumItem()
     * @uses ListOfSumItems::setSubTotal()
     * @param string $items_category
     * @param \StructType\SumItem[] $sumItem
     * @param \StructType\SubTotal $subTotal
     */
    public function __construct($items_category = null, array $sumItem = array(), \StructType\SubTotal $subTotal = null)
    {
        $this
            ->setItems_category($items_category)
            ->setSumItem($sumItem)
            ->setSubTotal($subTotal);
    }
    /**
     * Get items_category value
     * @return string
     */
    public function getItems_category()
    {
        return $this->{'items-category'};
    }
    /**
     * Set items_category value
     * @param string $items_category
     * @return \StructType\ListOfSumItems
     */
    public function setItems_category($items_category = null)
    {
        // validation for constraint: string
        if (!is_null($items_category) && !is_string($items_category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($items_category, true), gettype($items_category)), __LINE__);
        }
        $this->items_category = $this->{'items-category'} = $items_category;
        return $this;
    }
    /**
     * Get SumItem value
     * @return \StructType\SumItem[]|null
     */
    public function getSumItem()
    {
        return $this->SumItem;
    }
    /**
     * This method is responsible for validating the values passed to the setSumItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSumItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSumItemForArrayConstraintsFromSetSumItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listOfSumItemsSumItemItem) {
            // validation for constraint: itemType
            if (!$listOfSumItemsSumItemItem instanceof \StructType\SumItem) {
                $invalidValues[] = is_object($listOfSumItemsSumItemItem) ? get_class($listOfSumItemsSumItemItem) : sprintf('%s(%s)', gettype($listOfSumItemsSumItemItem), var_export($listOfSumItemsSumItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SumItem property can only contain items of type \StructType\SumItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SumItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SumItem[] $sumItem
     * @return \StructType\ListOfSumItems
     */
    public function setSumItem(array $sumItem = array())
    {
        // validation for constraint: array
        if ('' !== ($sumItemArrayErrorMessage = self::validateSumItemForArrayConstraintsFromSetSumItem($sumItem))) {
            throw new \InvalidArgumentException($sumItemArrayErrorMessage, __LINE__);
        }
        $this->SumItem = $sumItem;
        return $this;
    }
    /**
     * Add item to SumItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SumItem $item
     * @return \StructType\ListOfSumItems
     */
    public function addToSumItem(\StructType\SumItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SumItem) {
            throw new \InvalidArgumentException(sprintf('The SumItem property can only contain items of type \StructType\SumItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SumItem[] = $item;
        return $this;
    }
    /**
     * Get SubTotal value
     * @return \StructType\SubTotal|null
     */
    public function getSubTotal()
    {
        return $this->SubTotal;
    }
    /**
     * Set SubTotal value
     * @param \StructType\SubTotal $subTotal
     * @return \StructType\ListOfSumItems
     */
    public function setSubTotal(\StructType\SubTotal $subTotal = null)
    {
        $this->SubTotal = $subTotal;
        return $this;
    }
}
