<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOfItems StructType
 * Meta information extracted from the WSDL
 * - documentation: List / block of items | Blok / seznam položek
 * @subpackage Structs
 */
class ListOfItems extends AbstractStructBase
{
    /**
     * The items_category
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $items_category;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Item[]
     */
    public $Item;
    /**
     * The ListOfItemsSubTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ListOfItemsSubTotal
     */
    public $ListOfItemsSubTotal;
    /**
     * Constructor method for ListOfItems
     * @uses ListOfItems::setItems_category()
     * @uses ListOfItems::setItem()
     * @uses ListOfItems::setListOfItemsSubTotal()
     * @param string $items_category
     * @param \StructType\Item[] $item
     * @param \StructType\ListOfItemsSubTotal $listOfItemsSubTotal
     */
    public function __construct($items_category = null, array $item = array(), \StructType\ListOfItemsSubTotal $listOfItemsSubTotal = null)
    {
        $this
            ->setItems_category($items_category)
            ->setItem($item)
            ->setListOfItemsSubTotal($listOfItemsSubTotal);
    }
    /**
     * Get items_category value
     * @return string
     */
    public function getItems_category()
    {
        return $this->{'items-category'};
    }
    /**
     * Set items_category value
     * @param string $items_category
     * @return \StructType\ListOfItems
     */
    public function setItems_category($items_category = null)
    {
        // validation for constraint: string
        if (!is_null($items_category) && !is_string($items_category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($items_category, true), gettype($items_category)), __LINE__);
        }
        $this->items_category = $this->{'items-category'} = $items_category;
        return $this;
    }
    /**
     * Get Item value
     * @return \StructType\Item[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listOfItemsItemItem) {
            // validation for constraint: itemType
            if (!$listOfItemsItemItem instanceof \StructType\Item) {
                $invalidValues[] = is_object($listOfItemsItemItem) ? get_class($listOfItemsItemItem) : sprintf('%s(%s)', gettype($listOfItemsItemItem), var_export($listOfItemsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item property can only contain items of type \StructType\Item, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item[] $item
     * @return \StructType\ListOfItems
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item $item
     * @return \StructType\ListOfItems
     */
    public function addToItem(\StructType\Item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of type \StructType\Item, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Get ListOfItemsSubTotal value
     * @return \StructType\ListOfItemsSubTotal|null
     */
    public function getListOfItemsSubTotal()
    {
        return $this->ListOfItemsSubTotal;
    }
    /**
     * Set ListOfItemsSubTotal value
     * @param \StructType\ListOfItemsSubTotal $listOfItemsSubTotal
     * @return \StructType\ListOfItems
     */
    public function setListOfItemsSubTotal(\StructType\ListOfItemsSubTotal $listOfItemsSubTotal = null)
    {
        $this->ListOfItemsSubTotal = $listOfItemsSubTotal;
        return $this;
    }
}
