<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for item_type StructType
 * @subpackage Structs
 */
class Item_type extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: Item type | Typ položky
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The inv_per_from
     * Meta information extracted from the WSDL
     * - documentation: Beginning of period | Počátek období
     * - use: required
     * @var string
     */
    public $inv_per_from;
    /**
     * The inv_per_to
     * Meta information extracted from the WSDL
     * - documentation: End of period | Konec období
     * - use: required
     * @var string
     */
    public $inv_per_to;
    /**
     * The qty
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,4})?
     * - use: required
     * @var string
     */
    public $qty;
    /**
     * The unit_price
     * Meta information extracted from the WSDL
     * - documentation: Unit price | Jednotková cena | Jednotková cena - desetinné číslo na max 4 des. míst
     * - base: xsd:string
     * - maxLength: 31
     * - pattern: -?\d+(\.\d{1,4})?
     * - use: required
     * @var string
     */
    public $unit_price;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - documentation: Item total | Celková částka | Jednotková cena - desetinné číslo na max 2 des. místa
     * - base: xsd:string
     * - maxLength: 31
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $price;
    /**
     * The bill_relevant
     * Meta information extracted from the WSDL
     * - documentation: Billing relevant | Účetně relevantní
     * - use: required
     * @var bool
     */
    public $bill_relevant;
    /**
     * The descript
     * Meta information extracted from the WSDL
     * - documentation: Descritpion | Doplňkový text | Popis
     * - base: xsd:string
     * - maxLength: 30
     * - use: optional
     * @var string
     */
    public $descript;
    /**
     * Constructor method for item_type
     * @uses Item_type::setType()
     * @uses Item_type::setInv_per_from()
     * @uses Item_type::setInv_per_to()
     * @uses Item_type::setQty()
     * @uses Item_type::setUnit_price()
     * @uses Item_type::setPrice()
     * @uses Item_type::setBill_relevant()
     * @uses Item_type::setDescript()
     * @param string $type
     * @param string $inv_per_from
     * @param string $inv_per_to
     * @param string $qty
     * @param string $unit_price
     * @param string $price
     * @param bool $bill_relevant
     * @param string $descript
     */
    public function __construct($type = null, $inv_per_from = null, $inv_per_to = null, $qty = null, $unit_price = null, $price = null, $bill_relevant = null, $descript = null)
    {
        $this
            ->setType($type)
            ->setInv_per_from($inv_per_from)
            ->setInv_per_to($inv_per_to)
            ->setQty($qty)
            ->setUnit_price($unit_price)
            ->setPrice($price)
            ->setBill_relevant($bill_relevant)
            ->setDescript($descript);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Item_type
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get inv_per_from value
     * @return string
     */
    public function getInv_per_from()
    {
        return $this->{'inv-per-from'};
    }
    /**
     * Set inv_per_from value
     * @param string $inv_per_from
     * @return \StructType\Item_type
     */
    public function setInv_per_from($inv_per_from = null)
    {
        // validation for constraint: string
        if (!is_null($inv_per_from) && !is_string($inv_per_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_per_from, true), gettype($inv_per_from)), __LINE__);
        }
        $this->inv_per_from = $this->{'inv-per-from'} = $inv_per_from;
        return $this;
    }
    /**
     * Get inv_per_to value
     * @return string
     */
    public function getInv_per_to()
    {
        return $this->{'inv-per-to'};
    }
    /**
     * Set inv_per_to value
     * @param string $inv_per_to
     * @return \StructType\Item_type
     */
    public function setInv_per_to($inv_per_to = null)
    {
        // validation for constraint: string
        if (!is_null($inv_per_to) && !is_string($inv_per_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_per_to, true), gettype($inv_per_to)), __LINE__);
        }
        $this->inv_per_to = $this->{'inv-per-to'} = $inv_per_to;
        return $this;
    }
    /**
     * Get qty value
     * @return string
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param string $qty
     * @return \StructType\Item_type
     */
    public function setQty($qty = null)
    {
        // validation for constraint: string
        if (!is_null($qty) && !is_string($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qty) && mb_strlen($qty) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qty)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,4})?)
        if (!is_null($qty) && !preg_match('/-?\\d+(\\.\\d{1,4})?/', $qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,4})?', var_export($qty, true)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
    /**
     * Get unit_price value
     * @return string
     */
    public function getUnit_price()
    {
        return $this->{'unit-price'};
    }
    /**
     * Set unit_price value
     * @param string $unit_price
     * @return \StructType\Item_type
     */
    public function setUnit_price($unit_price = null)
    {
        // validation for constraint: string
        if (!is_null($unit_price) && !is_string($unit_price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unit_price, true), gettype($unit_price)), __LINE__);
        }
        // validation for constraint: maxLength(31)
        if (!is_null($unit_price) && mb_strlen($unit_price) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 31', mb_strlen($unit_price)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,4})?)
        if (!is_null($unit_price) && !preg_match('/-?\\d+(\\.\\d{1,4})?/', $unit_price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,4})?', var_export($unit_price, true)), __LINE__);
        }
        $this->unit_price = $this->{'unit-price'} = $unit_price;
        return $this;
    }
    /**
     * Get price value
     * @return string
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param string $price
     * @return \StructType\Item_type
     */
    public function setPrice($price = null)
    {
        // validation for constraint: string
        if (!is_null($price) && !is_string($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        // validation for constraint: maxLength(31)
        if (!is_null($price) && mb_strlen($price) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 31', mb_strlen($price)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($price) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($price, true)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get bill_relevant value
     * @return bool
     */
    public function getBill_relevant()
    {
        return $this->{'bill-relevant'};
    }
    /**
     * Set bill_relevant value
     * @param bool $bill_relevant
     * @return \StructType\Item_type
     */
    public function setBill_relevant($bill_relevant = null)
    {
        // validation for constraint: boolean
        if (!is_null($bill_relevant) && !is_bool($bill_relevant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bill_relevant, true), gettype($bill_relevant)), __LINE__);
        }
        $this->bill_relevant = $this->{'bill-relevant'} = $bill_relevant;
        return $this;
    }
    /**
     * Get descript value
     * @return string|null
     */
    public function getDescript()
    {
        return $this->descript;
    }
    /**
     * Set descript value
     * @param string $descript
     * @return \StructType\Item_type
     */
    public function setDescript($descript = null)
    {
        // validation for constraint: string
        if (!is_null($descript) && !is_string($descript)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descript, true), gettype($descript)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($descript) && mb_strlen($descript) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($descript)), __LINE__);
        }
        $this->descript = $descript;
        return $this;
    }
}
