<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item StructType
 * Meta information extracted from the WSDL
 * - documentation: Document item | Položka dokladu
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The item_type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $item_type;
    /**
     * The BaseItemDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BaseItemDetail
     */
    public $BaseItemDetail;
    /**
     * The PricingDetail
     * @var \StructType\PricingDetail
     */
    public $PricingDetail;
    /**
     * The PaymentInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentInfo
     */
    public $PaymentInfo;
    /**
     * The ItemDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemDates
     */
    public $ItemDates;
    /**
     * The doc_number
     * @var string
     */
    public $doc_number;
    /**
     * Constructor method for Item
     * @uses Item::setItem_type()
     * @uses Item::setBaseItemDetail()
     * @uses Item::setPricingDetail()
     * @uses Item::setPaymentInfo()
     * @uses Item::setItemDates()
     * @uses Item::setDoc_number()
     * @param string $item_type
     * @param \StructType\BaseItemDetail $baseItemDetail
     * @param \StructType\PricingDetail $pricingDetail
     * @param \StructType\PaymentInfo $paymentInfo
     * @param \StructType\ItemDates $itemDates
     * @param string $doc_number
     */
    public function __construct($item_type = null, \StructType\BaseItemDetail $baseItemDetail = null, \StructType\PricingDetail $pricingDetail = null, \StructType\PaymentInfo $paymentInfo = null, \StructType\ItemDates $itemDates = null, $doc_number = null)
    {
        $this
            ->setItem_type($item_type)
            ->setBaseItemDetail($baseItemDetail)
            ->setPricingDetail($pricingDetail)
            ->setPaymentInfo($paymentInfo)
            ->setItemDates($itemDates)
            ->setDoc_number($doc_number);
    }
    /**
     * Get item_type value
     * @return string
     */
    public function getItem_type()
    {
        return $this->{'item-type'};
    }
    /**
     * Set item_type value
     * @param string $item_type
     * @return \StructType\Item
     */
    public function setItem_type($item_type = null)
    {
        // validation for constraint: string
        if (!is_null($item_type) && !is_string($item_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_type, true), gettype($item_type)), __LINE__);
        }
        $this->item_type = $this->{'item-type'} = $item_type;
        return $this;
    }
    /**
     * Get BaseItemDetail value
     * @return \StructType\BaseItemDetail|null
     */
    public function getBaseItemDetail()
    {
        return $this->BaseItemDetail;
    }
    /**
     * Set BaseItemDetail value
     * @param \StructType\BaseItemDetail $baseItemDetail
     * @return \StructType\Item
     */
    public function setBaseItemDetail(\StructType\BaseItemDetail $baseItemDetail = null)
    {
        $this->BaseItemDetail = $baseItemDetail;
        return $this;
    }
    /**
     * Get PricingDetail value
     * @return \StructType\PricingDetail|null
     */
    public function getPricingDetail()
    {
        return $this->PricingDetail;
    }
    /**
     * Set PricingDetail value
     * @param \StructType\PricingDetail $pricingDetail
     * @return \StructType\Item
     */
    public function setPricingDetail(\StructType\PricingDetail $pricingDetail = null)
    {
        $this->PricingDetail = $pricingDetail;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \StructType\PaymentInfo|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @param \StructType\PaymentInfo $paymentInfo
     * @return \StructType\Item
     */
    public function setPaymentInfo(\StructType\PaymentInfo $paymentInfo = null)
    {
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get ItemDates value
     * @return \StructType\ItemDates|null
     */
    public function getItemDates()
    {
        return $this->ItemDates;
    }
    /**
     * Set ItemDates value
     * @param \StructType\ItemDates $itemDates
     * @return \StructType\Item
     */
    public function setItemDates(\StructType\ItemDates $itemDates = null)
    {
        $this->ItemDates = $itemDates;
        return $this;
    }
    /**
     * Get doc_number value
     * @return string|null
     */
    public function getDoc_number()
    {
        return $this->{'doc-number'};
    }
    /**
     * Set doc_number value
     * @param string $doc_number
     * @return \StructType\Item
     */
    public function setDoc_number($doc_number = null)
    {
        // validation for constraint: string
        if (!is_null($doc_number) && !is_string($doc_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_number, true), gettype($doc_number)), __LINE__);
        }
        $this->doc_number = $this->{'doc-number'} = $doc_number;
        return $this;
    }
}
