<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAccount StructType
 * Meta information extracted from the WSDL
 * - documentation: Bank account | Bankovní spojení
 * @subpackage Structs
 */
class BankAccount extends AbstractStructBase
{
    /**
     * The bank_id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - minLength: 0
     * - use: required
     * @var string
     */
    public $bank_id;
    /**
     * The account_num
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $account_num;
    /**
     * The bank_country
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $bank_country;
    /**
     * The bank_name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - minLength: 0
     * @var string
     */
    public $bank_name;
    /**
     * The iban
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 24
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $iban;
    /**
     * Constructor method for BankAccount
     * @uses BankAccount::setBank_id()
     * @uses BankAccount::setAccount_num()
     * @uses BankAccount::setBank_country()
     * @uses BankAccount::setBank_name()
     * @uses BankAccount::setIban()
     * @param string $bank_id
     * @param string $account_num
     * @param string $bank_country
     * @param string $bank_name
     * @param string $iban
     */
    public function __construct($bank_id = null, $account_num = null, $bank_country = null, $bank_name = null, $iban = null)
    {
        $this
            ->setBank_id($bank_id)
            ->setAccount_num($account_num)
            ->setBank_country($bank_country)
            ->setBank_name($bank_name)
            ->setIban($iban);
    }
    /**
     * Get bank_id value
     * @return string
     */
    public function getBank_id()
    {
        return $this->{'bank-id'};
    }
    /**
     * Set bank_id value
     * @param string $bank_id
     * @return \StructType\BankAccount
     */
    public function setBank_id($bank_id = null)
    {
        // validation for constraint: string
        if (!is_null($bank_id) && !is_string($bank_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bank_id, true), gettype($bank_id)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($bank_id) && mb_strlen($bank_id) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($bank_id)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bank_id) && mb_strlen($bank_id) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bank_id)), __LINE__);
        }
        $this->bank_id = $this->{'bank-id'} = $bank_id;
        return $this;
    }
    /**
     * Get account_num value
     * @return string
     */
    public function getAccount_num()
    {
        return $this->{'account-num'};
    }
    /**
     * Set account_num value
     * @param string $account_num
     * @return \StructType\BankAccount
     */
    public function setAccount_num($account_num = null)
    {
        // validation for constraint: string
        if (!is_null($account_num) && !is_string($account_num)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account_num, true), gettype($account_num)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($account_num) && mb_strlen($account_num) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($account_num)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($account_num) && mb_strlen($account_num) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($account_num)), __LINE__);
        }
        $this->account_num = $this->{'account-num'} = $account_num;
        return $this;
    }
    /**
     * Get bank_country value
     * @return string
     */
    public function getBank_country()
    {
        return $this->{'bank-country'};
    }
    /**
     * Set bank_country value
     * @param string $bank_country
     * @return \StructType\BankAccount
     */
    public function setBank_country($bank_country = null)
    {
        // validation for constraint: string
        if (!is_null($bank_country) && !is_string($bank_country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bank_country, true), gettype($bank_country)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($bank_country) && mb_strlen($bank_country) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($bank_country)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bank_country) && mb_strlen($bank_country) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bank_country)), __LINE__);
        }
        $this->bank_country = $this->{'bank-country'} = $bank_country;
        return $this;
    }
    /**
     * Get bank_name value
     * @return string|null
     */
    public function getBank_name()
    {
        return $this->{'bank-name'};
    }
    /**
     * Set bank_name value
     * @param string $bank_name
     * @return \StructType\BankAccount
     */
    public function setBank_name($bank_name = null)
    {
        // validation for constraint: string
        if (!is_null($bank_name) && !is_string($bank_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bank_name, true), gettype($bank_name)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($bank_name) && mb_strlen($bank_name) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($bank_name)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bank_name) && mb_strlen($bank_name) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bank_name)), __LINE__);
        }
        $this->bank_name = $this->{'bank-name'} = $bank_name;
        return $this;
    }
    /**
     * Get iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \StructType\BankAccount
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        // validation for constraint: maxLength(24)
        if (!is_null($iban) && mb_strlen($iban) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 24', mb_strlen($iban)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($iban) && mb_strlen($iban) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
}
