<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentSum StructType
 * Meta information extracted from the WSDL
 * - documentation: Attachment summary | Shrnutí přílohy
 * @subpackage Structs
 */
class AttachmentSum extends AbstractStructBase
{
    /**
     * The BeforeTax
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $BeforeTax;
    /**
     * The VAT
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $VAT;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Currency;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Total;
    /**
     * The ElectricityTax
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ElectricityTax;
    /**
     * The BaseTax
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BaseTax;
    /**
     * Constructor method for AttachmentSum
     * @uses AttachmentSum::setBeforeTax()
     * @uses AttachmentSum::setVAT()
     * @uses AttachmentSum::setCurrency()
     * @uses AttachmentSum::setTotal()
     * @uses AttachmentSum::setElectricityTax()
     * @uses AttachmentSum::setBaseTax()
     * @param string $beforeTax
     * @param string $vAT
     * @param string $currency
     * @param string $total
     * @param string $electricityTax
     * @param string $baseTax
     */
    public function __construct($beforeTax = null, $vAT = null, $currency = null, $total = null, $electricityTax = null, $baseTax = null)
    {
        $this
            ->setBeforeTax($beforeTax)
            ->setVAT($vAT)
            ->setCurrency($currency)
            ->setTotal($total)
            ->setElectricityTax($electricityTax)
            ->setBaseTax($baseTax);
    }
    /**
     * Get BeforeTax value
     * @return string
     */
    public function getBeforeTax()
    {
        return $this->BeforeTax;
    }
    /**
     * Set BeforeTax value
     * @param string $beforeTax
     * @return \StructType\AttachmentSum
     */
    public function setBeforeTax($beforeTax = null)
    {
        // validation for constraint: string
        if (!is_null($beforeTax) && !is_string($beforeTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beforeTax, true), gettype($beforeTax)), __LINE__);
        }
        $this->BeforeTax = $beforeTax;
        return $this;
    }
    /**
     * Get VAT value
     * @return string
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * Set VAT value
     * @param string $vAT
     * @return \StructType\AttachmentSum
     */
    public function setVAT($vAT = null)
    {
        // validation for constraint: string
        if (!is_null($vAT) && !is_string($vAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vAT, true), gettype($vAT)), __LINE__);
        }
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Get Currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\AttachmentSum
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Total value
     * @return string
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param string $total
     * @return \StructType\AttachmentSum
     */
    public function setTotal($total = null)
    {
        // validation for constraint: string
        if (!is_null($total) && !is_string($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get ElectricityTax value
     * @return string|null
     */
    public function getElectricityTax()
    {
        return $this->ElectricityTax;
    }
    /**
     * Set ElectricityTax value
     * @param string $electricityTax
     * @return \StructType\AttachmentSum
     */
    public function setElectricityTax($electricityTax = null)
    {
        // validation for constraint: string
        if (!is_null($electricityTax) && !is_string($electricityTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($electricityTax, true), gettype($electricityTax)), __LINE__);
        }
        $this->ElectricityTax = $electricityTax;
        return $this;
    }
    /**
     * Get BaseTax value
     * @return string|null
     */
    public function getBaseTax()
    {
        return $this->BaseTax;
    }
    /**
     * Set BaseTax value
     * @param string $baseTax
     * @return \StructType\AttachmentSum
     */
    public function setBaseTax($baseTax = null)
    {
        // validation for constraint: string
        if (!is_null($baseTax) && !is_string($baseTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseTax, true), gettype($baseTax)), __LINE__);
        }
        $this->BaseTax = $baseTax;
        return $this;
    }
}
