<?php

namespace \GlsApi\Tracking;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuPODRequestType StructType
 * @subpackage Structs
 */
class TuPODRequestType extends AbstractStructBase
{
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\GlsApi\Tracking\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The RefValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RefValue;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \\GlsApi\Tracking\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TuPODRequestType
     * @uses TuPODRequestType::setCredentials()
     * @uses TuPODRequestType::setRefValue()
     * @uses TuPODRequestType::setParameters()
     * @param \\GlsApi\Tracking\GLSUserCredentials $credentials
     * @param string $refValue
     * @param \\GlsApi\Tracking\GLSParameters[] $parameters
     */
    public function __construct(\\GlsApi\Tracking\GLSUserCredentials $credentials = null, $refValue = null, array $parameters = array())
    {
        $this
            ->setCredentials($credentials)
            ->setRefValue($refValue)
            ->setParameters($parameters);
    }
    /**
     * Get Credentials value
     * @return \\GlsApi\Tracking\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \\GlsApi\Tracking\GLSUserCredentials $credentials
     * @return \\GlsApi\Tracking\TuPODRequestType
     */
    public function setCredentials(\\GlsApi\Tracking\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get RefValue value
     * @return string
     */
    public function getRefValue()
    {
        return $this->RefValue;
    }
    /**
     * Set RefValue value
     * @param string $refValue
     * @return \\GlsApi\Tracking\TuPODRequestType
     */
    public function setRefValue($refValue = null)
    {
        $this->RefValue = $refValue;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \\GlsApi\Tracking\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \\GlsApi\Tracking\GLSParameters[] $parameters
     * @return \\GlsApi\Tracking\TuPODRequestType
     */
    public function setParameters(array $parameters = array())
    {
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \\GlsApi\Tracking\GLSParameters $item
     * @return \\GlsApi\Tracking\TuPODRequestType
     */
    public function addToParameters(\\GlsApi\Tracking\GLSParameters $item)
    {
        $this->Parameters[] = $item;
        return $this;
    }
}
