<?php

namespace \GlsApi\Tracking;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuListRequestType StructType
 * @subpackage Structs
 */
class TuListRequestType extends AbstractStructBase
{
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\GlsApi\Tracking\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The RefValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefValue;
    /**
     * The DateFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\GlsApi\Tracking\GLSDateTime
     */
    public $DateFrom;
    /**
     * The DateTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\GlsApi\Tracking\GLSDateTime
     */
    public $DateTo;
    /**
     * The CustomRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomRef;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \\GlsApi\Tracking\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TuListRequestType
     * @uses TuListRequestType::setCredentials()
     * @uses TuListRequestType::setRefValue()
     * @uses TuListRequestType::setDateFrom()
     * @uses TuListRequestType::setDateTo()
     * @uses TuListRequestType::setCustomRef()
     * @uses TuListRequestType::setParameters()
     * @param \\GlsApi\Tracking\GLSUserCredentials $credentials
     * @param string $refValue
     * @param \\GlsApi\Tracking\GLSDateTime $dateFrom
     * @param \\GlsApi\Tracking\GLSDateTime $dateTo
     * @param string $customRef
     * @param \\GlsApi\Tracking\GLSParameters[] $parameters
     */
    public function __construct(\\GlsApi\Tracking\GLSUserCredentials $credentials = null, $refValue = null, \\GlsApi\Tracking\GLSDateTime $dateFrom = null, \\GlsApi\Tracking\GLSDateTime $dateTo = null, $customRef = null, array $parameters = array())
    {
        $this
            ->setCredentials($credentials)
            ->setRefValue($refValue)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setCustomRef($customRef)
            ->setParameters($parameters);
    }
    /**
     * Get Credentials value
     * @return \\GlsApi\Tracking\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \\GlsApi\Tracking\GLSUserCredentials $credentials
     * @return \\GlsApi\Tracking\TuListRequestType
     */
    public function setCredentials(\\GlsApi\Tracking\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get RefValue value
     * @return string|null
     */
    public function getRefValue()
    {
        return $this->RefValue;
    }
    /**
     * Set RefValue value
     * @param string $refValue
     * @return \\GlsApi\Tracking\TuListRequestType
     */
    public function setRefValue($refValue = null)
    {
        $this->RefValue = $refValue;
        return $this;
    }
    /**
     * Get DateFrom value
     * @return \\GlsApi\Tracking\GLSDateTime|null
     */
    public function getDateFrom()
    {
        return $this->DateFrom;
    }
    /**
     * Set DateFrom value
     * @param \\GlsApi\Tracking\GLSDateTime $dateFrom
     * @return \\GlsApi\Tracking\TuListRequestType
     */
    public function setDateFrom(\\GlsApi\Tracking\GLSDateTime $dateFrom = null)
    {
        $this->DateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get DateTo value
     * @return \\GlsApi\Tracking\GLSDateTime|null
     */
    public function getDateTo()
    {
        return $this->DateTo;
    }
    /**
     * Set DateTo value
     * @param \\GlsApi\Tracking\GLSDateTime $dateTo
     * @return \\GlsApi\Tracking\TuListRequestType
     */
    public function setDateTo(\\GlsApi\Tracking\GLSDateTime $dateTo = null)
    {
        $this->DateTo = $dateTo;
        return $this;
    }
    /**
     * Get CustomRef value
     * @return string|null
     */
    public function getCustomRef()
    {
        return $this->CustomRef;
    }
    /**
     * Set CustomRef value
     * @param string $customRef
     * @return \\GlsApi\Tracking\TuListRequestType
     */
    public function setCustomRef($customRef = null)
    {
        $this->CustomRef = $customRef;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \\GlsApi\Tracking\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \\GlsApi\Tracking\GLSParameters[] $parameters
     * @return \\GlsApi\Tracking\TuListRequestType
     */
    public function setParameters(array $parameters = array())
    {
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \\GlsApi\Tracking\GLSParameters $item
     * @return \\GlsApi\Tracking\TuListRequestType
     */
    public function addToParameters(\\GlsApi\Tracking\GLSParameters $item)
    {
        $this->Parameters[] = $item;
        return $this;
    }
}
