<?php

namespace \GlsApi\Tracking;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSDateTime StructType
 * Meta information extracted from the WSDL
 * - documentation: A datetime with precisions to the hour, all units is 1 based, and hour is less then 24 <br / > Year > 1900, Month 1 = January, Day 1 = first day in month, 0 <= hour > 24, 0 >= Minut > 60
 * @subpackage Structs
 */
class GLSDateTime extends AbstractStructBase
{
    /**
     * The Year
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Year;
    /**
     * The Month
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Month;
    /**
     * The Day
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Day;
    /**
     * The Hour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Hour;
    /**
     * The Minut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Minut;
    /**
     * Constructor method for GLSDateTime
     * @uses GLSDateTime::setYear()
     * @uses GLSDateTime::setMonth()
     * @uses GLSDateTime::setDay()
     * @uses GLSDateTime::setHour()
     * @uses GLSDateTime::setMinut()
     * @param int $year
     * @param int $month
     * @param int $day
     * @param int $hour
     * @param int $minut
     */
    public function __construct($year = null, $month = null, $day = null, $hour = null, $minut = null)
    {
        $this
            ->setYear($year)
            ->setMonth($month)
            ->setDay($day)
            ->setHour($hour)
            ->setMinut($minut);
    }
    /**
     * Get Year value
     * @return int
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \\GlsApi\Tracking\GLSDateTime
     */
    public function setYear($year = null)
    {
        $this->Year = $year;
        return $this;
    }
    /**
     * Get Month value
     * @return int
     */
    public function getMonth()
    {
        return $this->Month;
    }
    /**
     * Set Month value
     * @param int $month
     * @return \\GlsApi\Tracking\GLSDateTime
     */
    public function setMonth($month = null)
    {
        $this->Month = $month;
        return $this;
    }
    /**
     * Get Day value
     * @return int
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param int $day
     * @return \\GlsApi\Tracking\GLSDateTime
     */
    public function setDay($day = null)
    {
        $this->Day = $day;
        return $this;
    }
    /**
     * Get Hour value
     * @return int
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param int $hour
     * @return \\GlsApi\Tracking\GLSDateTime
     */
    public function setHour($hour = null)
    {
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get Minut value
     * @return int
     */
    public function getMinut()
    {
        return $this->Minut;
    }
    /**
     * Set Minut value
     * @param int $minut
     * @return \\GlsApi\Tracking\GLSDateTime
     */
    public function setMinut($minut = null)
    {
        $this->Minut = $minut;
        return $this;
    }
}
