<?php

namespace \GlsApi\Tracking;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSCustomerReference StructType
 * @subpackage Structs
 */
class GLSCustomerReference extends AbstractStructBase
{
    /**
     * The ReferenceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReferenceType;
    /**
     * The ReferenceValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReferenceValue;
    /**
     * Constructor method for GLSCustomerReference
     * @uses GLSCustomerReference::setReferenceType()
     * @uses GLSCustomerReference::setReferenceValue()
     * @param string $referenceType
     * @param string $referenceValue
     */
    public function __construct($referenceType = null, $referenceValue = null)
    {
        $this
            ->setReferenceType($referenceType)
            ->setReferenceValue($referenceValue);
    }
    /**
     * Get ReferenceType value
     * @return string
     */
    public function getReferenceType()
    {
        return $this->ReferenceType;
    }
    /**
     * Set ReferenceType value
     * @param string $referenceType
     * @return \\GlsApi\Tracking\GLSCustomerReference
     */
    public function setReferenceType($referenceType = null)
    {
        $this->ReferenceType = $referenceType;
        return $this;
    }
    /**
     * Get ReferenceValue value
     * @return string
     */
    public function getReferenceValue()
    {
        return $this->ReferenceValue;
    }
    /**
     * Set ReferenceValue value
     * @param string $referenceValue
     * @return \\GlsApi\Tracking\GLSCustomerReference
     */
    public function setReferenceValue($referenceValue = null)
    {
        $this->ReferenceValue = $referenceValue;
        return $this;
    }
}
