<?php

namespace \GlsApi\Tracking;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TusDetailsReponseType StructType
 * @subpackage Structs
 */
class TusDetailsReponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\GlsApi\Tracking\GLSExitCode
     */
    public $ExitCode;
    /**
     * The TusDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \\GlsApi\Tracking\TuDetailsResponseType[]
     */
    public $TusDetails;
    /**
     * Constructor method for TusDetailsReponseType
     * @uses TusDetailsReponseType::setExitCode()
     * @uses TusDetailsReponseType::setTusDetails()
     * @param \\GlsApi\Tracking\GLSExitCode $exitCode
     * @param \\GlsApi\Tracking\TuDetailsResponseType[] $tusDetails
     */
    public function __construct(\\GlsApi\Tracking\GLSExitCode $exitCode = null, array $tusDetails = array())
    {
        $this
            ->setExitCode($exitCode)
            ->setTusDetails($tusDetails);
    }
    /**
     * Get ExitCode value
     * @return \\GlsApi\Tracking\GLSExitCode
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \\GlsApi\Tracking\GLSExitCode $exitCode
     * @return \\GlsApi\Tracking\TusDetailsReponseType
     */
    public function setExitCode(\\GlsApi\Tracking\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get TusDetails value
     * @return \\GlsApi\Tracking\TuDetailsResponseType[]|null
     */
    public function getTusDetails()
    {
        return $this->TusDetails;
    }
    /**
     * Set TusDetails value
     * @param \\GlsApi\Tracking\TuDetailsResponseType[] $tusDetails
     * @return \\GlsApi\Tracking\TusDetailsReponseType
     */
    public function setTusDetails(array $tusDetails = array())
    {
        $this->TusDetails = $tusDetails;
        return $this;
    }
    /**
     * Add item to TusDetails value
     * @throws \InvalidArgumentException
     * @param \\GlsApi\Tracking\TuDetailsResponseType $item
     * @return \\GlsApi\Tracking\TusDetailsReponseType
     */
    public function addToTusDetails(\\GlsApi\Tracking\TuDetailsResponseType $item)
    {
        $this->TusDetails[] = $item;
        return $this;
    }
}
