<?php

namespace \GlsApi\Tracking;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TusDetailsRequestType StructType
 * @subpackage Structs
 */
class TusDetailsRequestType extends AbstractStructBase
{
    /**
     * The RefValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 1
     * @var string[]
     */
    public $RefValues;
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\GlsApi\Tracking\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \\GlsApi\Tracking\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TusDetailsRequestType
     * @uses TusDetailsRequestType::setRefValues()
     * @uses TusDetailsRequestType::setCredentials()
     * @uses TusDetailsRequestType::setParameters()
     * @param string[] $refValues
     * @param \\GlsApi\Tracking\GLSUserCredentials $credentials
     * @param \\GlsApi\Tracking\GLSParameters[] $parameters
     */
    public function __construct(array $refValues = array(), \\GlsApi\Tracking\GLSUserCredentials $credentials = null, array $parameters = array())
    {
        $this
            ->setRefValues($refValues)
            ->setCredentials($credentials)
            ->setParameters($parameters);
    }
    /**
     * Get RefValues value
     * @return string[]
     */
    public function getRefValues()
    {
        return $this->RefValues;
    }
    /**
     * Set RefValues value
     * @param string[] $refValues
     * @return \\GlsApi\Tracking\TusDetailsRequestType
     */
    public function setRefValues(array $refValues = array())
    {
        $this->RefValues = $refValues;
        return $this;
    }
    /**
     * Add item to RefValues value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \\GlsApi\Tracking\TusDetailsRequestType
     */
    public function addToRefValues($item)
    {
        $this->RefValues[] = $item;
        return $this;
    }
    /**
     * Get Credentials value
     * @return \\GlsApi\Tracking\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \\GlsApi\Tracking\GLSUserCredentials $credentials
     * @return \\GlsApi\Tracking\TusDetailsRequestType
     */
    public function setCredentials(\\GlsApi\Tracking\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \\GlsApi\Tracking\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \\GlsApi\Tracking\GLSParameters[] $parameters
     * @return \\GlsApi\Tracking\TusDetailsRequestType
     */
    public function setParameters(array $parameters = array())
    {
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \\GlsApi\Tracking\GLSParameters $item
     * @return \\GlsApi\Tracking\TusDetailsRequestType
     */
    public function addToParameters(\\GlsApi\Tracking\GLSParameters $item)
    {
        $this->Parameters[] = $item;
        return $this;
    }
}
