<?php

namespace \GlsApi\Tracking;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuListResponseType StructType
 * @subpackage Structs
 */
class TuListResponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\GlsApi\Tracking\GLSExitCode
     */
    public $ExitCode;
    /**
     * The TUList
     * Meta information extracted from the WSDL
     * - maxOccurs: 10000
     * - minOccurs: 0
     * @var \\GlsApi\Tracking\GLSUnitRow[]
     */
    public $TUList;
    /**
     * Constructor method for TuListResponseType
     * @uses TuListResponseType::setExitCode()
     * @uses TuListResponseType::setTUList()
     * @param \\GlsApi\Tracking\GLSExitCode $exitCode
     * @param \\GlsApi\Tracking\GLSUnitRow[] $tUList
     */
    public function __construct(\\GlsApi\Tracking\GLSExitCode $exitCode = null, array $tUList = array())
    {
        $this
            ->setExitCode($exitCode)
            ->setTUList($tUList);
    }
    /**
     * Get ExitCode value
     * @return \\GlsApi\Tracking\GLSExitCode
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \\GlsApi\Tracking\GLSExitCode $exitCode
     * @return \\GlsApi\Tracking\TuListResponseType
     */
    public function setExitCode(\\GlsApi\Tracking\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get TUList value
     * @return \\GlsApi\Tracking\GLSUnitRow[]|null
     */
    public function getTUList()
    {
        return $this->TUList;
    }
    /**
     * Set TUList value
     * @param \\GlsApi\Tracking\GLSUnitRow[] $tUList
     * @return \\GlsApi\Tracking\TuListResponseType
     */
    public function setTUList(array $tUList = array())
    {
        $this->TUList = $tUList;
        return $this;
    }
    /**
     * Add item to TUList value
     * @throws \InvalidArgumentException
     * @param \\GlsApi\Tracking\GLSUnitRow $item
     * @return \\GlsApi\Tracking\TuListResponseType
     */
    public function addToTUList(\\GlsApi\Tracking\GLSUnitRow $item)
    {
        $this->TUList[] = $item;
        return $this;
    }
}
