<?php

namespace \GlsApi\Tracking;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuDetailsResponseType StructType
 * @subpackage Structs
 */
class TuDetailsResponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\GlsApi\Tracking\GLSExitCode
     */
    public $ExitCode;
    /**
     * The TuNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TuNo;
    /**
     * The NationalRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NationalRef;
    /**
     * The ConsigneeAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\GlsApi\Tracking\GLSAddress
     */
    public $ConsigneeAddress;
    /**
     * The ShipperAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\GlsApi\Tracking\GLSAddress
     */
    public $ShipperAddress;
    /**
     * The RequesterAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\GlsApi\Tracking\GLSAddress
     */
    public $RequesterAddress;
    /**
     * The DeliveryDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\GlsApi\Tracking\GLSDateTime
     */
    public $DeliveryDateTime;
    /**
     * The PickupDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\GlsApi\Tracking\GLSDateTime
     */
    public $PickupDateTime;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Product;
    /**
     * The TuWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TuWeight;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var string[]
     */
    public $Services;
    /**
     * The CustomerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \\GlsApi\Tracking\GLSCustomerReference[]
     */
    public $CustomerReference;
    /**
     * The History
     * Meta information extracted from the WSDL
     * - maxOccurs: 1000
     * - minOccurs: 0
     * @var \\GlsApi\Tracking\GLSEvent[]
     */
    public $History;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Signature;
    /**
     * Constructor method for TuDetailsResponseType
     * @uses TuDetailsResponseType::setExitCode()
     * @uses TuDetailsResponseType::setTuNo()
     * @uses TuDetailsResponseType::setNationalRef()
     * @uses TuDetailsResponseType::setConsigneeAddress()
     * @uses TuDetailsResponseType::setShipperAddress()
     * @uses TuDetailsResponseType::setRequesterAddress()
     * @uses TuDetailsResponseType::setDeliveryDateTime()
     * @uses TuDetailsResponseType::setPickupDateTime()
     * @uses TuDetailsResponseType::setProduct()
     * @uses TuDetailsResponseType::setTuWeight()
     * @uses TuDetailsResponseType::setServices()
     * @uses TuDetailsResponseType::setCustomerReference()
     * @uses TuDetailsResponseType::setHistory()
     * @uses TuDetailsResponseType::setSignature()
     * @param \\GlsApi\Tracking\GLSExitCode $exitCode
     * @param string $tuNo
     * @param string $nationalRef
     * @param \\GlsApi\Tracking\GLSAddress $consigneeAddress
     * @param \\GlsApi\Tracking\GLSAddress $shipperAddress
     * @param \\GlsApi\Tracking\GLSAddress $requesterAddress
     * @param \\GlsApi\Tracking\GLSDateTime $deliveryDateTime
     * @param \\GlsApi\Tracking\GLSDateTime $pickupDateTime
     * @param string $product
     * @param float $tuWeight
     * @param string[] $services
     * @param \\GlsApi\Tracking\GLSCustomerReference[] $customerReference
     * @param \\GlsApi\Tracking\GLSEvent[] $history
     * @param string $signature
     */
    public function __construct(\\GlsApi\Tracking\GLSExitCode $exitCode = null, $tuNo = null, $nationalRef = null, \\GlsApi\Tracking\GLSAddress $consigneeAddress = null, \\GlsApi\Tracking\GLSAddress $shipperAddress = null, \\GlsApi\Tracking\GLSAddress $requesterAddress = null, \\GlsApi\Tracking\GLSDateTime $deliveryDateTime = null, \\GlsApi\Tracking\GLSDateTime $pickupDateTime = null, $product = null, $tuWeight = null, array $services = array(), array $customerReference = array(), array $history = array(), $signature = null)
    {
        $this
            ->setExitCode($exitCode)
            ->setTuNo($tuNo)
            ->setNationalRef($nationalRef)
            ->setConsigneeAddress($consigneeAddress)
            ->setShipperAddress($shipperAddress)
            ->setRequesterAddress($requesterAddress)
            ->setDeliveryDateTime($deliveryDateTime)
            ->setPickupDateTime($pickupDateTime)
            ->setProduct($product)
            ->setTuWeight($tuWeight)
            ->setServices($services)
            ->setCustomerReference($customerReference)
            ->setHistory($history)
            ->setSignature($signature);
    }
    /**
     * Get ExitCode value
     * @return \\GlsApi\Tracking\GLSExitCode
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \\GlsApi\Tracking\GLSExitCode $exitCode
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setExitCode(\\GlsApi\Tracking\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get TuNo value
     * @return string
     */
    public function getTuNo()
    {
        return $this->TuNo;
    }
    /**
     * Set TuNo value
     * @param string $tuNo
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setTuNo($tuNo = null)
    {
        $this->TuNo = $tuNo;
        return $this;
    }
    /**
     * Get NationalRef value
     * @return string
     */
    public function getNationalRef()
    {
        return $this->NationalRef;
    }
    /**
     * Set NationalRef value
     * @param string $nationalRef
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setNationalRef($nationalRef = null)
    {
        $this->NationalRef = $nationalRef;
        return $this;
    }
    /**
     * Get ConsigneeAddress value
     * @return \\GlsApi\Tracking\GLSAddress
     */
    public function getConsigneeAddress()
    {
        return $this->ConsigneeAddress;
    }
    /**
     * Set ConsigneeAddress value
     * @param \\GlsApi\Tracking\GLSAddress $consigneeAddress
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setConsigneeAddress(\\GlsApi\Tracking\GLSAddress $consigneeAddress = null)
    {
        $this->ConsigneeAddress = $consigneeAddress;
        return $this;
    }
    /**
     * Get ShipperAddress value
     * @return \\GlsApi\Tracking\GLSAddress
     */
    public function getShipperAddress()
    {
        return $this->ShipperAddress;
    }
    /**
     * Set ShipperAddress value
     * @param \\GlsApi\Tracking\GLSAddress $shipperAddress
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setShipperAddress(\\GlsApi\Tracking\GLSAddress $shipperAddress = null)
    {
        $this->ShipperAddress = $shipperAddress;
        return $this;
    }
    /**
     * Get RequesterAddress value
     * @return \\GlsApi\Tracking\GLSAddress
     */
    public function getRequesterAddress()
    {
        return $this->RequesterAddress;
    }
    /**
     * Set RequesterAddress value
     * @param \\GlsApi\Tracking\GLSAddress $requesterAddress
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setRequesterAddress(\\GlsApi\Tracking\GLSAddress $requesterAddress = null)
    {
        $this->RequesterAddress = $requesterAddress;
        return $this;
    }
    /**
     * Get DeliveryDateTime value
     * @return \\GlsApi\Tracking\GLSDateTime
     */
    public function getDeliveryDateTime()
    {
        return $this->DeliveryDateTime;
    }
    /**
     * Set DeliveryDateTime value
     * @param \\GlsApi\Tracking\GLSDateTime $deliveryDateTime
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setDeliveryDateTime(\\GlsApi\Tracking\GLSDateTime $deliveryDateTime = null)
    {
        $this->DeliveryDateTime = $deliveryDateTime;
        return $this;
    }
    /**
     * Get PickupDateTime value
     * @return \\GlsApi\Tracking\GLSDateTime
     */
    public function getPickupDateTime()
    {
        return $this->PickupDateTime;
    }
    /**
     * Set PickupDateTime value
     * @param \\GlsApi\Tracking\GLSDateTime $pickupDateTime
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setPickupDateTime(\\GlsApi\Tracking\GLSDateTime $pickupDateTime = null)
    {
        $this->PickupDateTime = $pickupDateTime;
        return $this;
    }
    /**
     * Get Product value
     * @return string
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param string $product
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setProduct($product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get TuWeight value
     * @return float
     */
    public function getTuWeight()
    {
        return $this->TuWeight;
    }
    /**
     * Set TuWeight value
     * @param float $tuWeight
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setTuWeight($tuWeight = null)
    {
        $this->TuWeight = $tuWeight;
        return $this;
    }
    /**
     * Get Services value
     * @return string[]|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param string[] $services
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setServices(array $services = array())
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Add item to Services value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function addToServices($item)
    {
        $this->Services[] = $item;
        return $this;
    }
    /**
     * Get CustomerReference value
     * @return \\GlsApi\Tracking\GLSCustomerReference[]|null
     */
    public function getCustomerReference()
    {
        return $this->CustomerReference;
    }
    /**
     * Set CustomerReference value
     * @param \\GlsApi\Tracking\GLSCustomerReference[] $customerReference
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setCustomerReference(array $customerReference = array())
    {
        $this->CustomerReference = $customerReference;
        return $this;
    }
    /**
     * Add item to CustomerReference value
     * @throws \InvalidArgumentException
     * @param \\GlsApi\Tracking\GLSCustomerReference $item
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function addToCustomerReference(\\GlsApi\Tracking\GLSCustomerReference $item)
    {
        $this->CustomerReference[] = $item;
        return $this;
    }
    /**
     * Get History value
     * @return \\GlsApi\Tracking\GLSEvent[]|null
     */
    public function getHistory()
    {
        return $this->History;
    }
    /**
     * Set History value
     * @param \\GlsApi\Tracking\GLSEvent[] $history
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setHistory(array $history = array())
    {
        $this->History = $history;
        return $this;
    }
    /**
     * Add item to History value
     * @throws \InvalidArgumentException
     * @param \\GlsApi\Tracking\GLSEvent $item
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function addToHistory(\\GlsApi\Tracking\GLSEvent $item)
    {
        $this->History[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param string $signature
     * @return \\GlsApi\Tracking\TuDetailsResponseType
     */
    public function setSignature($signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
}
