<?php

namespace \GlsApi\Tracking;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetTuDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\GlsApi\Tracking\TuDetailsRequestType $getTuDetailRequest
     * @return \\GlsApi\Tracking\TuDetailsResponseType|bool
     */
    public function GetTuDetail(\\GlsApi\Tracking\TuDetailsRequestType $getTuDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuDetail($getTuDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTuList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\GlsApi\Tracking\TuListRequestType $getTuListRequest
     * @return \\GlsApi\Tracking\TuListResponseType|bool
     */
    public function GetTuList(\\GlsApi\Tracking\TuListRequestType $getTuListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuList($getTuListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTuPOD
     * Meta information extracted from the WSDL
     * - documentation: Method to extract the signature of a POD. The result will contain original filename <PODFileName /> and a <PODFile /> that is the binary file encoded in BASE64
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\GlsApi\Tracking\TuPODRequestType $getTuPODRequest
     * @return \\GlsApi\Tracking\TuPODResponseType|bool
     */
    public function GetTuPOD(\\GlsApi\Tracking\TuPODRequestType $getTuPODRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuPOD($getTuPODRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTusDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\GlsApi\Tracking\TusDetailsRequestType $getTusDetailsRequest
     * @return \\GlsApi\Tracking\TusDetailsReponseType|bool
     */
    public function GetTusDetails(\\GlsApi\Tracking\TusDetailsRequestType $getTusDetailsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTusDetails($getTusDetailsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \\GlsApi\Tracking\TuDetailsResponseType|\\GlsApi\Tracking\TuListResponseType|\\GlsApi\Tracking\TuPODResponseType|\\GlsApi\Tracking\TusDetailsReponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
