<?php

namespace GlsApi;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TusDetailsRequestType Tracking
 * @subpackage Structs
 */
class TusDetailsRequestType extends AbstractStructBase
{
    /**
     * The RefValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 1
     * @var string[]
     */
    public $RefValues;
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GlsApi\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TusDetailsRequestType
     * @uses TusDetailsRequestType::setRefValues()
     * @uses TusDetailsRequestType::setCredentials()
     * @uses TusDetailsRequestType::setParameters()
     * @param string[] $refValues
     * @param \GlsApi\GLSUserCredentials $credentials
     * @param \GlsApi\GLSParameters[] $parameters
     */
    public function __construct(array $refValues = array(), \GlsApi\GLSUserCredentials $credentials = null, array $parameters = array())
    {
        $this
            ->setRefValues($refValues)
            ->setCredentials($credentials)
            ->setParameters($parameters);
    }
    /**
     * Get RefValues value
     * @return string[]
     */
    public function getRefValues()
    {
        return $this->RefValues;
    }
    /**
     * Set RefValues value
     * @param string[] $refValues
     * @return \GlsApi\TusDetailsRequestType
     */
    public function setRefValues(array $refValues = array())
    {
        $this->RefValues = $refValues;
        return $this;
    }
    /**
     * Add item to RefValues value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GlsApi\TusDetailsRequestType
     */
    public function addToRefValues($item)
    {
        $this->RefValues[] = $item;
        return $this;
    }
    /**
     * Get Credentials value
     * @return \GlsApi\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \GlsApi\GLSUserCredentials $credentials
     * @return \GlsApi\TusDetailsRequestType
     */
    public function setCredentials(\GlsApi\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \GlsApi\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \GlsApi\GLSParameters[] $parameters
     * @return \GlsApi\TusDetailsRequestType
     */
    public function setParameters(array $parameters = array())
    {
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \GlsApi\GLSParameters $item
     * @return \GlsApi\TusDetailsRequestType
     */
    public function addToParameters(\GlsApi\GLSParameters $item)
    {
        $this->Parameters[] = $item;
        return $this;
    }
}
