<?php

namespace GlsApi;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSExitCode Tracking
 * Meta information extracted from the WSDL
 * - documentation: ExitCode for execution a web service operations, ExitCode = 0 indicates no error
 * @subpackage Structs
 */
class GLSExitCode extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorDscr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorDscr;
    /**
     * Constructor method for GLSExitCode
     * @uses GLSExitCode::setErrorCode()
     * @uses GLSExitCode::setErrorDscr()
     * @param int $errorCode
     * @param string $errorDscr
     */
    public function __construct($errorCode = null, $errorDscr = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorDscr($errorDscr);
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \GlsApi\GLSExitCode
     */
    public function setErrorCode($errorCode = null)
    {
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorDscr value
     * @return string
     */
    public function getErrorDscr()
    {
        return $this->ErrorDscr;
    }
    /**
     * Set ErrorDscr value
     * @param string $errorDscr
     * @return \GlsApi\GLSExitCode
     */
    public function setErrorDscr($errorDscr = null)
    {
        $this->ErrorDscr = $errorDscr;
        return $this;
    }
}
