<?php

namespace GlsApi;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuPODResponseType Tracking
 * @subpackage Structs
 */
class TuPODResponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSExitCode
     */
    public $ExitCode;
    /**
     * The PODFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PODFile;
    /**
     * The PODFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PODFileName;
    /**
     * Constructor method for TuPODResponseType
     * @uses TuPODResponseType::setExitCode()
     * @uses TuPODResponseType::setPODFile()
     * @uses TuPODResponseType::setPODFileName()
     * @param \GlsApi\GLSExitCode $exitCode
     * @param string $pODFile
     * @param string $pODFileName
     */
    public function __construct(\GlsApi\GLSExitCode $exitCode = null, $pODFile = null, $pODFileName = null)
    {
        $this
            ->setExitCode($exitCode)
            ->setPODFile($pODFile)
            ->setPODFileName($pODFileName);
    }
    /**
     * Get ExitCode value
     * @return \GlsApi\GLSExitCode
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \GlsApi\GLSExitCode $exitCode
     * @return \GlsApi\TuPODResponseType
     */
    public function setExitCode(\GlsApi\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get PODFile value
     * @return string
     */
    public function getPODFile()
    {
        return $this->PODFile;
    }
    /**
     * Set PODFile value
     * @param string $pODFile
     * @return \GlsApi\TuPODResponseType
     */
    public function setPODFile($pODFile = null)
    {
        $this->PODFile = $pODFile;
        return $this;
    }
    /**
     * Get PODFileName value
     * @return string
     */
    public function getPODFileName()
    {
        return $this->PODFileName;
    }
    /**
     * Set PODFileName value
     * @param string $pODFileName
     * @return \GlsApi\TuPODResponseType
     */
    public function setPODFileName($pODFileName = null)
    {
        $this->PODFileName = $pODFileName;
        return $this;
    }
}
