<?php

namespace GlsApi;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSEvent Tracking
 * @subpackage Structs
 */
class GLSEvent extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSDateTime
     */
    public $Date;
    /**
     * The LocationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LocationCode;
    /**
     * The LocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LocationName;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CountryName;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Code;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Desc;
    /**
     * The ReasonName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReasonName;
    /**
     * Constructor method for GLSEvent
     * @uses GLSEvent::setDate()
     * @uses GLSEvent::setLocationCode()
     * @uses GLSEvent::setLocationName()
     * @uses GLSEvent::setCountryName()
     * @uses GLSEvent::setCode()
     * @uses GLSEvent::setDesc()
     * @uses GLSEvent::setReasonName()
     * @param \GlsApi\GLSDateTime $date
     * @param string $locationCode
     * @param string $locationName
     * @param string $countryName
     * @param string $code
     * @param string $desc
     * @param string $reasonName
     */
    public function __construct(\GlsApi\GLSDateTime $date = null, $locationCode = null, $locationName = null, $countryName = null, $code = null, $desc = null, $reasonName = null)
    {
        $this
            ->setDate($date)
            ->setLocationCode($locationCode)
            ->setLocationName($locationName)
            ->setCountryName($countryName)
            ->setCode($code)
            ->setDesc($desc)
            ->setReasonName($reasonName);
    }
    /**
     * Get Date value
     * @return \GlsApi\GLSDateTime
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param \GlsApi\GLSDateTime $date
     * @return \GlsApi\GLSEvent
     */
    public function setDate(\GlsApi\GLSDateTime $date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \GlsApi\GLSEvent
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \GlsApi\GLSEvent
     */
    public function setLocationName($locationName = null)
    {
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \GlsApi\GLSEvent
     */
    public function setCountryName($countryName = null)
    {
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \GlsApi\GLSEvent
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Desc value
     * @return string
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * Set Desc value
     * @param string $desc
     * @return \GlsApi\GLSEvent
     */
    public function setDesc($desc = null)
    {
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Get ReasonName value
     * @return string
     */
    public function getReasonName()
    {
        return $this->ReasonName;
    }
    /**
     * Set ReasonName value
     * @param string $reasonName
     * @return \GlsApi\GLSEvent
     */
    public function setReasonName($reasonName = null)
    {
        $this->ReasonName = $reasonName;
        return $this;
    }
}
