<?php

namespace GlsApi;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuDetailsRequestType Tracking
 * @subpackage Structs
 */
class TuDetailsRequestType extends AbstractStructBase
{
    /**
     * The RefValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RefValue;
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GlsApi\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TuDetailsRequestType
     * @uses TuDetailsRequestType::setRefValue()
     * @uses TuDetailsRequestType::setCredentials()
     * @uses TuDetailsRequestType::setParameters()
     * @param string $refValue
     * @param \GlsApi\GLSUserCredentials $credentials
     * @param \GlsApi\GLSParameters[] $parameters
     */
    public function __construct($refValue = null, \GlsApi\GLSUserCredentials $credentials = null, array $parameters = array())
    {
        $this
            ->setRefValue($refValue)
            ->setCredentials($credentials)
            ->setParameters($parameters);
    }
    /**
     * Get RefValue value
     * @return string
     */
    public function getRefValue()
    {
        return $this->RefValue;
    }
    /**
     * Set RefValue value
     * @param string $refValue
     * @return \GlsApi\TuDetailsRequestType
     */
    public function setRefValue($refValue = null)
    {
        $this->RefValue = $refValue;
        return $this;
    }
    /**
     * Get Credentials value
     * @return \GlsApi\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \GlsApi\GLSUserCredentials $credentials
     * @return \GlsApi\TuDetailsRequestType
     */
    public function setCredentials(\GlsApi\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \GlsApi\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \GlsApi\GLSParameters[] $parameters
     * @return \GlsApi\TuDetailsRequestType
     */
    public function setParameters(array $parameters = array())
    {
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \GlsApi\GLSParameters $item
     * @return \GlsApi\TuDetailsRequestType
     */
    public function addToParameters(\GlsApi\GLSParameters $item)
    {
        $this->Parameters[] = $item;
        return $this;
    }
}
